//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// DatabaseVulnerabilityAssessmentRuleBaselinesClient contains the methods for the DatabaseVulnerabilityAssessmentRuleBaselines group.
// Don't use this type directly, use NewDatabaseVulnerabilityAssessmentRuleBaselinesClient() instead.
type DatabaseVulnerabilityAssessmentRuleBaselinesClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewDatabaseVulnerabilityAssessmentRuleBaselinesClient creates a new instance of DatabaseVulnerabilityAssessmentRuleBaselinesClient with the specified values.
// subscriptionID - The subscription ID that identifies an Azure subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewDatabaseVulnerabilityAssessmentRuleBaselinesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DatabaseVulnerabilityAssessmentRuleBaselinesClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &DatabaseVulnerabilityAssessmentRuleBaselinesClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CreateOrUpdate - Creates or updates a database's vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serverName - The name of the server.
// databaseName - The name of the database for which the vulnerability assessment rule baseline is defined.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// ruleID - The vulnerability assessment rule ID.
// baselineName - The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule
// and master for server level rule).
// parameters - The requested rule baseline resource.
// options - DatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions contains the optional parameters for
// the DatabaseVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate method.
func (client *DatabaseVulnerabilityAssessmentRuleBaselinesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, parameters DatabaseVulnerabilityAssessmentRuleBaseline, options *DatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions) (DatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleID, baselineName, parameters, options)
	if err != nil {
		return DatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *DatabaseVulnerabilityAssessmentRuleBaselinesClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, parameters DatabaseVulnerabilityAssessmentRuleBaseline, options *DatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *DatabaseVulnerabilityAssessmentRuleBaselinesClient) createOrUpdateHandleResponse(resp *http.Response) (DatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse, error) {
	result := DatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseVulnerabilityAssessmentRuleBaseline); err != nil {
		return DatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Removes the database's vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serverName - The name of the server.
// databaseName - The name of the database for which the vulnerability assessment rule baseline is defined.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// ruleID - The vulnerability assessment rule ID.
// baselineName - The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule
// and master for server level rule).
// options - DatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentRuleBaselinesClient.Delete
// method.
func (client *DatabaseVulnerabilityAssessmentRuleBaselinesClient) Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, options *DatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteOptions) (DatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleID, baselineName, options)
	if err != nil {
		return DatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return DatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *DatabaseVulnerabilityAssessmentRuleBaselinesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, options *DatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Gets a database's vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serverName - The name of the server.
// databaseName - The name of the database for which the vulnerability assessment rule baseline is defined.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// ruleID - The vulnerability assessment rule ID.
// baselineName - The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule
// and master for server level rule).
// options - DatabaseVulnerabilityAssessmentRuleBaselinesClientGetOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentRuleBaselinesClient.Get
// method.
func (client *DatabaseVulnerabilityAssessmentRuleBaselinesClient) Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, options *DatabaseVulnerabilityAssessmentRuleBaselinesClientGetOptions) (DatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleID, baselineName, options)
	if err != nil {
		return DatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *DatabaseVulnerabilityAssessmentRuleBaselinesClient) getCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, options *DatabaseVulnerabilityAssessmentRuleBaselinesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *DatabaseVulnerabilityAssessmentRuleBaselinesClient) getHandleResponse(resp *http.Response) (DatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse, error) {
	result := DatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseVulnerabilityAssessmentRuleBaseline); err != nil {
		return DatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	return result, nil
}
