//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsearch

const (
	moduleName    = "armsearch"
	moduleVersion = "v1.0.0"
)

type AdminKeyKind string

const (
	AdminKeyKindPrimary   AdminKeyKind = "primary"
	AdminKeyKindSecondary AdminKeyKind = "secondary"
)

// PossibleAdminKeyKindValues returns the possible values for the AdminKeyKind const type.
func PossibleAdminKeyKindValues() []AdminKeyKind {
	return []AdminKeyKind{
		AdminKeyKindPrimary,
		AdminKeyKindSecondary,
	}
}

// HostingMode - Applicable only for the standard3 SKU. You can set this property to enable up to 3 high density partitions
// that allow up to 1000 indexes, which is much higher than the maximum indexes allowed for any
// other SKU. For the standard3 SKU, the value is either 'default' or 'highDensity'. For all other SKUs, this value must be
// 'default'.
type HostingMode string

const (
	HostingModeDefault     HostingMode = "default"
	HostingModeHighDensity HostingMode = "highDensity"
)

// PossibleHostingModeValues returns the possible values for the HostingMode const type.
func PossibleHostingModeValues() []HostingMode {
	return []HostingMode{
		HostingModeDefault,
		HostingModeHighDensity,
	}
}

// IdentityType - The identity type.
type IdentityType string

const (
	IdentityTypeNone           IdentityType = "None"
	IdentityTypeSystemAssigned IdentityType = "SystemAssigned"
)

// PossibleIdentityTypeValues returns the possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{
		IdentityTypeNone,
		IdentityTypeSystemAssigned,
	}
}

// PrivateLinkServiceConnectionStatus - Status of the the private link service connection. Can be Pending, Approved, Rejected,
// or Disconnected.
type PrivateLinkServiceConnectionStatus string

const (
	PrivateLinkServiceConnectionStatusPending      PrivateLinkServiceConnectionStatus = "Pending"
	PrivateLinkServiceConnectionStatusApproved     PrivateLinkServiceConnectionStatus = "Approved"
	PrivateLinkServiceConnectionStatusRejected     PrivateLinkServiceConnectionStatus = "Rejected"
	PrivateLinkServiceConnectionStatusDisconnected PrivateLinkServiceConnectionStatus = "Disconnected"
)

// PossiblePrivateLinkServiceConnectionStatusValues returns the possible values for the PrivateLinkServiceConnectionStatus const type.
func PossiblePrivateLinkServiceConnectionStatusValues() []PrivateLinkServiceConnectionStatus {
	return []PrivateLinkServiceConnectionStatus{
		PrivateLinkServiceConnectionStatusPending,
		PrivateLinkServiceConnectionStatusApproved,
		PrivateLinkServiceConnectionStatusRejected,
		PrivateLinkServiceConnectionStatusDisconnected,
	}
}

// ProvisioningState - The state of the last provisioning operation performed on the search service. Provisioning is an intermediate
// state that occurs while service capacity is being established. After capacity is set up,
// provisioningState changes to either 'succeeded' or 'failed'. Client applications can poll provisioning status (the recommended
// polling interval is from 30 seconds to one minute) by using the Get
// Search Service operation to see when an operation is completed. If you are using the free service, this value tends to
// come back as 'succeeded' directly in the call to Create search service. This is
// because the free service uses capacity that is already set up.
type ProvisioningState string

const (
	ProvisioningStateSucceeded    ProvisioningState = "succeeded"
	ProvisioningStateProvisioning ProvisioningState = "provisioning"
	ProvisioningStateFailed       ProvisioningState = "failed"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateSucceeded,
		ProvisioningStateProvisioning,
		ProvisioningStateFailed,
	}
}

// PublicNetworkAccess - This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates.
// If set to 'disabled', traffic over public interface is not allowed, and private endpoint
// connections would be the exclusive access method.
type PublicNetworkAccess string

const (
	PublicNetworkAccessEnabled  PublicNetworkAccess = "enabled"
	PublicNetworkAccessDisabled PublicNetworkAccess = "disabled"
)

// PossiblePublicNetworkAccessValues returns the possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{
		PublicNetworkAccessEnabled,
		PublicNetworkAccessDisabled,
	}
}

// SKUName - The SKU of the search service. Valid values include: 'free': Shared service. 'basic': Dedicated service with
// up to 3 replicas. 'standard': Dedicated service with up to 12 partitions and 12 replicas.
// 'standard2': Similar to standard, but with more capacity per search unit. 'standard3': The largest Standard offering with
// up to 12 partitions and 12 replicas (or up to 3 partitions with more indexes
// if you also set the hostingMode property to 'highDensity'). 'storageoptimizedl1': Supports 1TB per partition, up to 12
// partitions. 'storageoptimizedl2': Supports 2TB per partition, up to 12
// partitions.'
type SKUName string

const (
	SKUNameFree               SKUName = "free"
	SKUNameBasic              SKUName = "basic"
	SKUNameStandard           SKUName = "standard"
	SKUNameStandard2          SKUName = "standard2"
	SKUNameStandard3          SKUName = "standard3"
	SKUNameStorageOptimizedL1 SKUName = "storage_optimized_l1"
	SKUNameStorageOptimizedL2 SKUName = "storage_optimized_l2"
)

// PossibleSKUNameValues returns the possible values for the SKUName const type.
func PossibleSKUNameValues() []SKUName {
	return []SKUName{
		SKUNameFree,
		SKUNameBasic,
		SKUNameStandard,
		SKUNameStandard2,
		SKUNameStandard3,
		SKUNameStorageOptimizedL1,
		SKUNameStorageOptimizedL2,
	}
}

// SearchServiceStatus - The status of the search service. Possible values include: 'running': The search service is running
// and no provisioning operations are underway. 'provisioning': The search service is being provisioned
// or scaled up or down. 'deleting': The search service is being deleted. 'degraded': The search service is degraded. This
// can occur when the underlying search units are not healthy. The search service
// is most likely operational, but performance might be slow and some requests might be dropped. 'disabled': The search service
// is disabled. In this state, the service will reject all API requests.
// 'error': The search service is in an error state. If your service is in the degraded, disabled, or error states, it means
// the Azure Cognitive Search team is actively investigating the underlying
// issue. Dedicated services in these states are still chargeable based on the number of search units provisioned.
type SearchServiceStatus string

const (
	SearchServiceStatusRunning      SearchServiceStatus = "running"
	SearchServiceStatusProvisioning SearchServiceStatus = "provisioning"
	SearchServiceStatusDeleting     SearchServiceStatus = "deleting"
	SearchServiceStatusDegraded     SearchServiceStatus = "degraded"
	SearchServiceStatusDisabled     SearchServiceStatus = "disabled"
	SearchServiceStatusError        SearchServiceStatus = "error"
)

// PossibleSearchServiceStatusValues returns the possible values for the SearchServiceStatus const type.
func PossibleSearchServiceStatusValues() []SearchServiceStatus {
	return []SearchServiceStatus{
		SearchServiceStatusRunning,
		SearchServiceStatusProvisioning,
		SearchServiceStatusDeleting,
		SearchServiceStatusDegraded,
		SearchServiceStatusDisabled,
		SearchServiceStatusError,
	}
}

// SharedPrivateLinkResourceAsyncOperationResult - The current status of the long running asynchronous shared private link
// resource operation.
type SharedPrivateLinkResourceAsyncOperationResult string

const (
	SharedPrivateLinkResourceAsyncOperationResultFailed    SharedPrivateLinkResourceAsyncOperationResult = "Failed"
	SharedPrivateLinkResourceAsyncOperationResultRunning   SharedPrivateLinkResourceAsyncOperationResult = "Running"
	SharedPrivateLinkResourceAsyncOperationResultSucceeded SharedPrivateLinkResourceAsyncOperationResult = "Succeeded"
)

// PossibleSharedPrivateLinkResourceAsyncOperationResultValues returns the possible values for the SharedPrivateLinkResourceAsyncOperationResult const type.
func PossibleSharedPrivateLinkResourceAsyncOperationResultValues() []SharedPrivateLinkResourceAsyncOperationResult {
	return []SharedPrivateLinkResourceAsyncOperationResult{
		SharedPrivateLinkResourceAsyncOperationResultFailed,
		SharedPrivateLinkResourceAsyncOperationResultRunning,
		SharedPrivateLinkResourceAsyncOperationResultSucceeded,
	}
}

// SharedPrivateLinkResourceProvisioningState - The provisioning state of the shared private link resource. Can be Updating,
// Deleting, Failed, Succeeded or Incomplete.
type SharedPrivateLinkResourceProvisioningState string

const (
	SharedPrivateLinkResourceProvisioningStateUpdating   SharedPrivateLinkResourceProvisioningState = "Updating"
	SharedPrivateLinkResourceProvisioningStateDeleting   SharedPrivateLinkResourceProvisioningState = "Deleting"
	SharedPrivateLinkResourceProvisioningStateFailed     SharedPrivateLinkResourceProvisioningState = "Failed"
	SharedPrivateLinkResourceProvisioningStateSucceeded  SharedPrivateLinkResourceProvisioningState = "Succeeded"
	SharedPrivateLinkResourceProvisioningStateIncomplete SharedPrivateLinkResourceProvisioningState = "Incomplete"
)

// PossibleSharedPrivateLinkResourceProvisioningStateValues returns the possible values for the SharedPrivateLinkResourceProvisioningState const type.
func PossibleSharedPrivateLinkResourceProvisioningStateValues() []SharedPrivateLinkResourceProvisioningState {
	return []SharedPrivateLinkResourceProvisioningState{
		SharedPrivateLinkResourceProvisioningStateUpdating,
		SharedPrivateLinkResourceProvisioningStateDeleting,
		SharedPrivateLinkResourceProvisioningStateFailed,
		SharedPrivateLinkResourceProvisioningStateSucceeded,
		SharedPrivateLinkResourceProvisioningStateIncomplete,
	}
}

// SharedPrivateLinkResourceStatus - Status of the shared private link resource. Can be Pending, Approved, Rejected or Disconnected.
type SharedPrivateLinkResourceStatus string

const (
	SharedPrivateLinkResourceStatusPending      SharedPrivateLinkResourceStatus = "Pending"
	SharedPrivateLinkResourceStatusApproved     SharedPrivateLinkResourceStatus = "Approved"
	SharedPrivateLinkResourceStatusRejected     SharedPrivateLinkResourceStatus = "Rejected"
	SharedPrivateLinkResourceStatusDisconnected SharedPrivateLinkResourceStatus = "Disconnected"
)

// PossibleSharedPrivateLinkResourceStatusValues returns the possible values for the SharedPrivateLinkResourceStatus const type.
func PossibleSharedPrivateLinkResourceStatusValues() []SharedPrivateLinkResourceStatus {
	return []SharedPrivateLinkResourceStatus{
		SharedPrivateLinkResourceStatusPending,
		SharedPrivateLinkResourceStatusApproved,
		SharedPrivateLinkResourceStatusRejected,
		SharedPrivateLinkResourceStatusDisconnected,
	}
}

// UnavailableNameReason - The reason why the name is not available. 'Invalid' indicates the name provided does not match
// the naming requirements (incorrect length, unsupported characters, etc.). 'AlreadyExists' indicates that
// the name is already in use and is therefore unavailable.
type UnavailableNameReason string

const (
	UnavailableNameReasonAlreadyExists UnavailableNameReason = "AlreadyExists"
	UnavailableNameReasonInvalid       UnavailableNameReason = "Invalid"
)

// PossibleUnavailableNameReasonValues returns the possible values for the UnavailableNameReason const type.
func PossibleUnavailableNameReasonValues() []UnavailableNameReason {
	return []UnavailableNameReason{
		UnavailableNameReasonAlreadyExists,
		UnavailableNameReasonInvalid,
	}
}
