//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatamigration

import "time"

// APIError - Error information.
type APIError struct {
	// Error information in OData format
	Error *ODataError `json:"error,omitempty"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`
}

// AvailableServiceSKU - Describes the available service SKU.
type AvailableServiceSKU struct {
	// A description of the scaling capacities of the SKU
	Capacity *AvailableServiceSKUCapacity `json:"capacity,omitempty"`

	// The resource type, including the provider namespace
	ResourceType *string `json:"resourceType,omitempty"`

	// SKU name, tier, etc.
	SKU *AvailableServiceSKUSKU `json:"sku,omitempty"`
}

// AvailableServiceSKUCapacity - A description of the scaling capacities of the SKU
type AvailableServiceSKUCapacity struct {
	// The default capacity
	Default *int32 `json:"default,omitempty"`

	// The maximum capacity
	Maximum *int32 `json:"maximum,omitempty"`

	// The minimum capacity, usually 0 or 1.
	Minimum *int32 `json:"minimum,omitempty"`

	// The scalability approach
	ScaleType *ServiceScalability `json:"scaleType,omitempty"`
}

// AvailableServiceSKUSKU - SKU name, tier, etc.
type AvailableServiceSKUSKU struct {
	// SKU family
	Family *string `json:"family,omitempty"`

	// The name of the SKU
	Name *string `json:"name,omitempty"`

	// SKU size
	Size *string `json:"size,omitempty"`

	// The tier of the SKU, such as "Basic", "General Purpose", or "Business Critical"
	Tier *string `json:"tier,omitempty"`
}

// AzureActiveDirectoryApp - Azure Active Directory Application
type AzureActiveDirectoryApp struct {
	// REQUIRED; Key used to authenticate to the Azure Active Directory Application
	AppKey *string `json:"appKey,omitempty"`

	// REQUIRED; Application ID of the Azure Active Directory Application
	ApplicationID *string `json:"applicationId,omitempty"`

	// REQUIRED; Tenant id of the customer
	TenantID *string `json:"tenantId,omitempty"`
}

// BackupFileInfo - Information of the backup file
type BackupFileInfo struct {
	// Sequence number of the backup file in the backup set
	FamilySequenceNumber *int32 `json:"familySequenceNumber,omitempty"`

	// Location of the backup file in shared folder
	FileLocation *string `json:"fileLocation,omitempty"`

	// Status of the backup file during migration
	Status *BackupFileStatus `json:"status,omitempty"`
}

// BackupSetInfo - Information of backup set
type BackupSetInfo struct {
	// Date and time that the backup operation finished
	BackupFinishedDate *time.Time `json:"backupFinishedDate,omitempty"`

	// Id for the set of backup files
	BackupSetID *string `json:"backupSetId,omitempty"`

	// Date and time that the backup operation began
	BackupStartDate *time.Time `json:"backupStartDate,omitempty"`

	// Enum of the different backup types
	BackupType *BackupType `json:"backupType,omitempty"`

	// Name of the database to which the backup set belongs
	DatabaseName *string `json:"databaseName,omitempty"`

	// First log sequence number of the backup file
	FirstLsn *string `json:"firstLsn,omitempty"`

	// Whether the backup set is restored or not
	IsBackupRestored *bool `json:"isBackupRestored,omitempty"`

	// Last log sequence number of the backup file
	LastLsn *string `json:"lastLsn,omitempty"`

	// Last modified time of the backup file in share location
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty"`

	// List of files in the backup set
	ListOfBackupFiles []*BackupFileInfo `json:"listOfBackupFiles,omitempty"`
}

// BlobShare - Blob container storage information.
type BlobShare struct {
	// REQUIRED; SAS URI of Azure Storage Account Container.
	SasURI *string `json:"sasUri,omitempty"`
}

// CheckOCIDriverTaskInput - Input for the service task to check for OCI drivers.
type CheckOCIDriverTaskInput struct {
	// Version of the source server to check against. Optional.
	ServerVersion *string `json:"serverVersion,omitempty"`
}

// CheckOCIDriverTaskOutput - Output for the service task to check for OCI drivers.
type CheckOCIDriverTaskOutput struct {
	// Information about the installed driver if found and valid.
	InstalledDriver *OracleOCIDriverInfo `json:"installedDriver,omitempty"`

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// CheckOCIDriverTaskProperties - Properties for the task that checks for OCI drivers.
type CheckOCIDriverTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Input for the service task to check for OCI drivers.
	Input *CheckOCIDriverTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*CheckOCIDriverTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type CheckOCIDriverTaskProperties.
func (c *CheckOCIDriverTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   c.TaskType,
		Errors:     c.Errors,
		State:      c.State,
		Commands:   c.Commands,
		ClientData: c.ClientData,
	}
}

// CommandPropertiesClassification provides polymorphic access to related types.
// Call the interface's GetCommandProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CommandProperties, *MigrateMISyncCompleteCommandProperties, *MigrateSyncCompleteCommandProperties, *MongoDbCancelCommand,
// - *MongoDbFinishCommand, *MongoDbRestartCommand
type CommandPropertiesClassification interface {
	// GetCommandProperties returns the CommandProperties content of the underlying type.
	GetCommandProperties() *CommandProperties
}

// CommandProperties - Base class for all types of DMS command properties. If command is not supported by current client,
// this object is returned.
type CommandProperties struct {
	// REQUIRED; Command type.
	CommandType *string `json:"commandType,omitempty"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; The state of the command. This is ignored if submitted.
	State *CommandState `json:"state,omitempty" azure:"ro"`
}

// GetCommandProperties implements the CommandPropertiesClassification interface for type CommandProperties.
func (c *CommandProperties) GetCommandProperties() *CommandProperties { return c }

// ConnectToMongoDbTaskProperties - Properties for the task that validates the connection to and provides information about
// a MongoDB server
type ConnectToMongoDbTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Describes a connection to a MongoDB data source
	Input *MongoDbConnectionInfo `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; An array containing a single MongoDbClusterInfo object
	Output []*MongoDbClusterInfo `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToMongoDbTaskProperties.
func (c *ConnectToMongoDbTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   c.TaskType,
		Errors:     c.Errors,
		State:      c.State,
		Commands:   c.Commands,
		ClientData: c.ClientData,
	}
}

// ConnectToSourceMySQLTaskInput - Input for the task that validates MySQL database connection
type ConnectToSourceMySQLTaskInput struct {
	// REQUIRED; Information for connecting to MySQL source
	SourceConnectionInfo *MySQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// Permission group for validations
	CheckPermissionsGroup *ServerLevelPermissionsGroup `json:"checkPermissionsGroup,omitempty"`

	// Flag for whether or not the migration is offline
	IsOfflineMigration *bool `json:"isOfflineMigration,omitempty"`

	// Target Platform for the migration
	TargetPlatform *MySQLTargetPlatformType `json:"targetPlatform,omitempty"`
}

// ConnectToSourceMySQLTaskProperties - Properties for the task that validates MySQL database connection
type ConnectToSourceMySQLTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *ConnectToSourceMySQLTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToSourceNonSQLTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToSourceMySQLTaskProperties.
func (c *ConnectToSourceMySQLTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   c.TaskType,
		Errors:     c.Errors,
		State:      c.State,
		Commands:   c.Commands,
		ClientData: c.ClientData,
	}
}

// ConnectToSourceNonSQLTaskOutput - Output for connect to MySQL type source
type ConnectToSourceNonSQLTaskOutput struct {
	// READ-ONLY; List of databases on the server
	Databases []*string `json:"databases,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Server properties
	ServerProperties *ServerProperties `json:"serverProperties,omitempty" azure:"ro"`

	// READ-ONLY; Server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors associated with the task
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// ConnectToSourceOracleSyncTaskInput - Input for the task that validates Oracle database connection
type ConnectToSourceOracleSyncTaskInput struct {
	// REQUIRED; Information for connecting to Oracle source
	SourceConnectionInfo *OracleConnectionInfo `json:"sourceConnectionInfo,omitempty"`
}

// ConnectToSourceOracleSyncTaskOutput - Output for the task that validates Oracle database connection
type ConnectToSourceOracleSyncTaskOutput struct {
	// READ-ONLY; List of schemas on source server
	Databases []*string `json:"databases,omitempty" azure:"ro"`

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Version of the source server
	SourceServerVersion *string `json:"sourceServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors associated with the task
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// ConnectToSourceOracleSyncTaskProperties - Properties for the task that validates Oracle database connection
type ConnectToSourceOracleSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *ConnectToSourceOracleSyncTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToSourceOracleSyncTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToSourceOracleSyncTaskProperties.
func (c *ConnectToSourceOracleSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   c.TaskType,
		Errors:     c.Errors,
		State:      c.State,
		Commands:   c.Commands,
		ClientData: c.ClientData,
	}
}

// ConnectToSourcePostgreSQLSyncTaskInput - Input for the task that validates connection to PostgreSQL and source server requirements
type ConnectToSourcePostgreSQLSyncTaskInput struct {
	// REQUIRED; Connection information for source PostgreSQL server
	SourceConnectionInfo *PostgreSQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
}

// ConnectToSourcePostgreSQLSyncTaskOutput - Output for the task that validates connection to PostgreSQL and source server
// requirements
type ConnectToSourcePostgreSQLSyncTaskOutput struct {
	// READ-ONLY; List of databases on source server
	Databases []*string `json:"databases,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Version of the source server
	SourceServerVersion *string `json:"sourceServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors associated with the task
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// ConnectToSourcePostgreSQLSyncTaskProperties - Properties for the task that validates connection to PostgreSQL server and
// source server requirements for online migration
type ConnectToSourcePostgreSQLSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *ConnectToSourcePostgreSQLSyncTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToSourcePostgreSQLSyncTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToSourcePostgreSQLSyncTaskProperties.
func (c *ConnectToSourcePostgreSQLSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   c.TaskType,
		Errors:     c.Errors,
		State:      c.State,
		Commands:   c.Commands,
		ClientData: c.ClientData,
	}
}

// ConnectToSourceSQLServerSyncTaskProperties - Properties for the task that validates connection to SQL Server and source
// server requirements for online migration
type ConnectToSourceSQLServerSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *ConnectToSourceSQLServerTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []ConnectToSourceSQLServerTaskOutputClassification `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToSourceSQLServerSyncTaskProperties.
func (c *ConnectToSourceSQLServerSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   c.TaskType,
		Errors:     c.Errors,
		State:      c.State,
		Commands:   c.Commands,
		ClientData: c.ClientData,
	}
}

// ConnectToSourceSQLServerTaskInput - Input for the task that validates connection to SQL Server and also validates source
// server requirements
type ConnectToSourceSQLServerTaskInput struct {
	// REQUIRED; Connection information for Source SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// Permission group for validations
	CheckPermissionsGroup *ServerLevelPermissionsGroup `json:"checkPermissionsGroup,omitempty"`

	// Flag for whether to collect agent jobs from source server.
	CollectAgentJobs *bool `json:"collectAgentJobs,omitempty"`

	// Flag for whether to collect databases from source server.
	CollectDatabases *bool `json:"collectDatabases,omitempty"`

	// Flag for whether to collect logins from source server.
	CollectLogins *bool `json:"collectLogins,omitempty"`

	// Flag for whether to collect TDE Certificate names from source server.
	CollectTdeCertificateInfo *bool `json:"collectTdeCertificateInfo,omitempty"`

	// Flag for whether to validate SSIS catalog is reachable on the source server.
	ValidateSsisCatalogOnly *bool `json:"validateSsisCatalogOnly,omitempty"`
}

// ConnectToSourceSQLServerTaskOutputClassification provides polymorphic access to related types.
// Call the interface's GetConnectToSourceSQLServerTaskOutput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ConnectToSourceSQLServerTaskOutput, *ConnectToSourceSQLServerTaskOutputAgentJobLevel, *ConnectToSourceSQLServerTaskOutputDatabaseLevel,
// - *ConnectToSourceSQLServerTaskOutputLoginLevel, *ConnectToSourceSQLServerTaskOutputTaskLevel
type ConnectToSourceSQLServerTaskOutputClassification interface {
	// GetConnectToSourceSQLServerTaskOutput returns the ConnectToSourceSQLServerTaskOutput content of the underlying type.
	GetConnectToSourceSQLServerTaskOutput() *ConnectToSourceSQLServerTaskOutput
}

// ConnectToSourceSQLServerTaskOutput - Output for the task that validates connection to SQL Server and also validates source
// server requirements
type ConnectToSourceSQLServerTaskOutput struct {
	// REQUIRED; Type of result - database level or task level
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetConnectToSourceSQLServerTaskOutput implements the ConnectToSourceSQLServerTaskOutputClassification interface for type
// ConnectToSourceSQLServerTaskOutput.
func (c *ConnectToSourceSQLServerTaskOutput) GetConnectToSourceSQLServerTaskOutput() *ConnectToSourceSQLServerTaskOutput {
	return c
}

// ConnectToSourceSQLServerTaskOutputAgentJobLevel - Agent Job level output for the task that validates connection to SQL
// Server and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputAgentJobLevel struct {
	// REQUIRED; Type of result - database level or task level
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The state of the original Agent Job.
	IsEnabled *bool `json:"isEnabled,omitempty" azure:"ro"`

	// READ-ONLY; The type of Agent Job.
	JobCategory *string `json:"jobCategory,omitempty" azure:"ro"`

	// READ-ONLY; The owner of the Agent Job
	JobOwner *string `json:"jobOwner,omitempty" azure:"ro"`

	// READ-ONLY; UTC Date and time when the Agent Job was last executed.
	LastExecutedOn *time.Time `json:"lastExecutedOn,omitempty" azure:"ro"`

	// READ-ONLY; Information about eligibility of agent job for migration.
	MigrationEligibility *MigrationEligibilityInfo `json:"migrationEligibility,omitempty" azure:"ro"`

	// READ-ONLY; Agent Job name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// GetConnectToSourceSQLServerTaskOutput implements the ConnectToSourceSQLServerTaskOutputClassification interface for type
// ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (c *ConnectToSourceSQLServerTaskOutputAgentJobLevel) GetConnectToSourceSQLServerTaskOutput() *ConnectToSourceSQLServerTaskOutput {
	return &ConnectToSourceSQLServerTaskOutput{
		ID:         c.ID,
		ResultType: c.ResultType,
	}
}

// ConnectToSourceSQLServerTaskOutputDatabaseLevel - Database level output for the task that validates connection to SQL Server
// and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputDatabaseLevel struct {
	// REQUIRED; Type of result - database level or task level
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; SQL Server compatibility level of database
	CompatibilityLevel *DatabaseCompatLevel `json:"compatibilityLevel,omitempty" azure:"ro"`

	// READ-ONLY; The list of database files
	DatabaseFiles []*DatabaseFileInfo `json:"databaseFiles,omitempty" azure:"ro"`

	// READ-ONLY; State of the database
	DatabaseState *DatabaseState `json:"databaseState,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Database name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Size of the file in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty" azure:"ro"`
}

// GetConnectToSourceSQLServerTaskOutput implements the ConnectToSourceSQLServerTaskOutputClassification interface for type
// ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (c *ConnectToSourceSQLServerTaskOutputDatabaseLevel) GetConnectToSourceSQLServerTaskOutput() *ConnectToSourceSQLServerTaskOutput {
	return &ConnectToSourceSQLServerTaskOutput{
		ID:         c.ID,
		ResultType: c.ResultType,
	}
}

// ConnectToSourceSQLServerTaskOutputLoginLevel - Login level output for the task that validates connection to SQL Server
// and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputLoginLevel struct {
	// REQUIRED; Type of result - database level or task level
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; The default database for the login.
	DefaultDatabase *string `json:"defaultDatabase,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The state of the login.
	IsEnabled *bool `json:"isEnabled,omitempty" azure:"ro"`

	// READ-ONLY; The type of login.
	LoginType *LoginType `json:"loginType,omitempty" azure:"ro"`

	// READ-ONLY; Information about eligibility of login for migration.
	MigrationEligibility *MigrationEligibilityInfo `json:"migrationEligibility,omitempty" azure:"ro"`

	// READ-ONLY; Login name.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// GetConnectToSourceSQLServerTaskOutput implements the ConnectToSourceSQLServerTaskOutputClassification interface for type
// ConnectToSourceSQLServerTaskOutputLoginLevel.
func (c *ConnectToSourceSQLServerTaskOutputLoginLevel) GetConnectToSourceSQLServerTaskOutput() *ConnectToSourceSQLServerTaskOutput {
	return &ConnectToSourceSQLServerTaskOutput{
		ID:         c.ID,
		ResultType: c.ResultType,
	}
}

// ConnectToSourceSQLServerTaskOutputTaskLevel - Task level output for the task that validates connection to SQL Server and
// also validates source server requirements
type ConnectToSourceSQLServerTaskOutputTaskLevel struct {
	// REQUIRED; Type of result - database level or task level
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Source agent jobs as a map from agent job name to id.
	AgentJobs *string `json:"agentJobs,omitempty" azure:"ro"`

	// READ-ONLY; Mapping from database name to TDE certificate name, if applicable
	DatabaseTdeCertificateMapping *string `json:"databaseTdeCertificateMapping,omitempty" azure:"ro"`

	// READ-ONLY; Source databases as a map from database name to database id
	Databases *string `json:"databases,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Source logins as a map from login name to login id.
	Logins *string `json:"logins,omitempty" azure:"ro"`

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// GetConnectToSourceSQLServerTaskOutput implements the ConnectToSourceSQLServerTaskOutputClassification interface for type
// ConnectToSourceSQLServerTaskOutputTaskLevel.
func (c *ConnectToSourceSQLServerTaskOutputTaskLevel) GetConnectToSourceSQLServerTaskOutput() *ConnectToSourceSQLServerTaskOutput {
	return &ConnectToSourceSQLServerTaskOutput{
		ID:         c.ID,
		ResultType: c.ResultType,
	}
}

// ConnectToSourceSQLServerTaskProperties - Properties for the task that validates connection to SQL Server and also validates
// source server requirements
type ConnectToSourceSQLServerTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *ConnectToSourceSQLServerTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []ConnectToSourceSQLServerTaskOutputClassification `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToSourceSQLServerTaskProperties.
func (c *ConnectToSourceSQLServerTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   c.TaskType,
		Errors:     c.Errors,
		State:      c.State,
		Commands:   c.Commands,
		ClientData: c.ClientData,
	}
}

// ConnectToTargetAzureDbForMySQLTaskInput - Input for the task that validates connection to Azure Database for MySQL and
// target server requirements
type ConnectToTargetAzureDbForMySQLTaskInput struct {
	// REQUIRED; Connection information for source MySQL server
	SourceConnectionInfo *MySQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Connection information for target Azure Database for MySQL server
	TargetConnectionInfo *MySQLConnectionInfo `json:"targetConnectionInfo,omitempty"`

	// Flag for whether or not the migration is offline
	IsOfflineMigration *bool `json:"isOfflineMigration,omitempty"`
}

// ConnectToTargetAzureDbForMySQLTaskOutput - Output for the task that validates connection to Azure Database for MySQL and
// target server requirements
type ConnectToTargetAzureDbForMySQLTaskOutput struct {
	// READ-ONLY; List of databases on target server
	Databases []*string `json:"databases,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Version of the target server
	ServerVersion *string `json:"serverVersion,omitempty" azure:"ro"`

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors associated with the task
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// ConnectToTargetAzureDbForMySQLTaskProperties - Properties for the task that validates connection to Azure Database for
// MySQL and target server requirements
type ConnectToTargetAzureDbForMySQLTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *ConnectToTargetAzureDbForMySQLTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToTargetAzureDbForMySQLTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToTargetAzureDbForMySQLTaskProperties.
func (c *ConnectToTargetAzureDbForMySQLTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   c.TaskType,
		Errors:     c.Errors,
		State:      c.State,
		Commands:   c.Commands,
		ClientData: c.ClientData,
	}
}

// ConnectToTargetAzureDbForPostgreSQLSyncTaskInput - Input for the task that validates connection to Azure Database for PostgreSQL
// and target server requirements
type ConnectToTargetAzureDbForPostgreSQLSyncTaskInput struct {
	// REQUIRED; Connection information for source PostgreSQL server
	SourceConnectionInfo *PostgreSQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Connection information for target Azure Database for PostgreSQL server
	TargetConnectionInfo *PostgreSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput - Output for the task that validates connection to Azure Database for
// PostgreSQL and target server requirements
type ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput struct {
	// READ-ONLY; List of databases on target server
	Databases []*string `json:"databases,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Version of the target server
	TargetServerVersion *string `json:"targetServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors associated with the task
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties - Properties for the task that validates connection to Azure Database
// For PostgreSQL server and target server requirements for online migration
type ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *ConnectToTargetAzureDbForPostgreSQLSyncTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (c *ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   c.TaskType,
		Errors:     c.Errors,
		State:      c.State,
		Commands:   c.Commands,
		ClientData: c.ClientData,
	}
}

// ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskInput - Input for the task that validates connection to Azure Database
// for PostgreSQL and target server requirements for Oracle source.
type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskInput struct {
	// REQUIRED; Connection information for target Azure Database for PostgreSQL server
	TargetConnectionInfo *PostgreSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutput - Output for the task that validates connection to Azure Database
// for PostgreSQL and target server requirements for Oracle source.
type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutput struct {
	// Mapping of schemas per database
	DatabaseSchemaMap []*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutputDatabaseSchemaMapItem `json:"databaseSchemaMap,omitempty"`

	// READ-ONLY; List of databases on target server
	Databases []*string `json:"databases,omitempty" azure:"ro"`

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Version of the target server
	TargetServerVersion *string `json:"targetServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors associated with the task
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutputDatabaseSchemaMapItem struct {
	Database *string   `json:"database,omitempty"`
	Schemas  []*string `json:"schemas,omitempty"`
}

// ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties - Properties for the task that validates connection to Azure
// Database For PostgreSQL server and target server requirements for online migration for Oracle source.
type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (c *ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   c.TaskType,
		Errors:     c.Errors,
		State:      c.State,
		Commands:   c.Commands,
		ClientData: c.ClientData,
	}
}

// ConnectToTargetSQLDbSyncTaskInput - Input for the task that validates connection to Azure SQL DB and target server requirements
type ConnectToTargetSQLDbSyncTaskInput struct {
	// REQUIRED; Connection information for source SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Connection information for target SQL DB
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetSQLDbSyncTaskProperties - Properties for the task that validates connection to SQL DB and target server
// requirements for online migration
type ConnectToTargetSQLDbSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *ConnectToTargetSQLDbSyncTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToTargetSQLDbTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToTargetSQLDbSyncTaskProperties.
func (c *ConnectToTargetSQLDbSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   c.TaskType,
		Errors:     c.Errors,
		State:      c.State,
		Commands:   c.Commands,
		ClientData: c.ClientData,
	}
}

// ConnectToTargetSQLDbTaskInput - Input for the task that validates connection to SQL DB and target server requirements
type ConnectToTargetSQLDbTaskInput struct {
	// REQUIRED; Connection information for target SQL DB
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetSQLDbTaskOutput - Output for the task that validates connection to SQL DB and target server requirements
type ConnectToTargetSQLDbTaskOutput struct {
	// READ-ONLY; Source databases as a map from database name to database id
	Databases *string `json:"databases,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Version of the target server
	TargetServerVersion *string `json:"targetServerVersion,omitempty" azure:"ro"`
}

// ConnectToTargetSQLDbTaskProperties - Properties for the task that validates connection to SQL DB and target server requirements
type ConnectToTargetSQLDbTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *ConnectToTargetSQLDbTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToTargetSQLDbTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToTargetSQLDbTaskProperties.
func (c *ConnectToTargetSQLDbTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   c.TaskType,
		Errors:     c.Errors,
		State:      c.State,
		Commands:   c.Commands,
		ClientData: c.ClientData,
	}
}

// ConnectToTargetSQLMISyncTaskInput - Input for the task that validates connection to Azure SQL Database Managed Instance
// online scenario.
type ConnectToTargetSQLMISyncTaskInput struct {
	// REQUIRED; Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database
	// Managed Instance and the Azure Storage Account
	AzureApp *AzureActiveDirectoryApp `json:"azureApp,omitempty"`

	// REQUIRED; Connection information for Azure SQL Database Managed Instance
	TargetConnectionInfo *MiSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetSQLMISyncTaskOutput - Output for the task that validates connection to Azure SQL Database Managed Instance.
type ConnectToTargetSQLMISyncTaskOutput struct {
	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// ConnectToTargetSQLMISyncTaskProperties - Properties for the task that validates connection to Azure SQL Database Managed
// Instance
type ConnectToTargetSQLMISyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *ConnectToTargetSQLMISyncTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToTargetSQLMISyncTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToTargetSQLMISyncTaskProperties.
func (c *ConnectToTargetSQLMISyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   c.TaskType,
		Errors:     c.Errors,
		State:      c.State,
		Commands:   c.Commands,
		ClientData: c.ClientData,
	}
}

// ConnectToTargetSQLMITaskInput - Input for the task that validates connection to Azure SQL Database Managed Instance.
type ConnectToTargetSQLMITaskInput struct {
	// REQUIRED; Connection information for target SQL Server
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`

	// Flag for whether to collect agent jobs from target SQL MI server.
	CollectAgentJobs *bool `json:"collectAgentJobs,omitempty"`

	// Flag for whether to collect logins from target SQL MI server.
	CollectLogins *bool `json:"collectLogins,omitempty"`

	// Flag for whether to validate SSIS catalog is reachable on the target SQL MI server.
	ValidateSsisCatalogOnly *bool `json:"validateSsisCatalogOnly,omitempty"`
}

// ConnectToTargetSQLMITaskOutput - Output for the task that validates connection to Azure SQL Database Managed Instance.
type ConnectToTargetSQLMITaskOutput struct {
	// READ-ONLY; List of agent jobs on the target server.
	AgentJobs []*string `json:"agentJobs,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; List of logins on the target server.
	Logins []*string `json:"logins,omitempty" azure:"ro"`

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// ConnectToTargetSQLMITaskProperties - Properties for the task that validates connection to Azure SQL Database Managed Instance
type ConnectToTargetSQLMITaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *ConnectToTargetSQLMITaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToTargetSQLMITaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToTargetSQLMITaskProperties.
func (c *ConnectToTargetSQLMITaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   c.TaskType,
		Errors:     c.Errors,
		State:      c.State,
		Commands:   c.Commands,
		ClientData: c.ClientData,
	}
}

// ConnectionInfoClassification provides polymorphic access to related types.
// Call the interface's GetConnectionInfo() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ConnectionInfo, *MiSQLConnectionInfo, *MongoDbConnectionInfo, *MySQLConnectionInfo, *OracleConnectionInfo, *PostgreSQLConnectionInfo,
// - *SQLConnectionInfo
type ConnectionInfoClassification interface {
	// GetConnectionInfo returns the ConnectionInfo content of the underlying type.
	GetConnectionInfo() *ConnectionInfo
}

// ConnectionInfo - Defines the connection properties of a server
type ConnectionInfo struct {
	// REQUIRED; Type of connection info
	Type *string `json:"type,omitempty"`

	// Password credential.
	Password *string `json:"password,omitempty"`

	// User name
	UserName *string `json:"userName,omitempty"`
}

// GetConnectionInfo implements the ConnectionInfoClassification interface for type ConnectionInfo.
func (c *ConnectionInfo) GetConnectionInfo() *ConnectionInfo { return c }

// DataIntegrityValidationResult - Results for checksum based Data Integrity validation results
type DataIntegrityValidationResult struct {
	// List of failed table names of source and target pair
	FailedObjects map[string]*string `json:"failedObjects,omitempty"`

	// List of errors that happened while performing data integrity validation
	ValidationErrors *ValidationError `json:"validationErrors,omitempty"`
}

// DataItemMigrationSummaryResult - Basic summary of a data item migration
type DataItemMigrationSummaryResult struct {
	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty" azure:"ro"`

	// READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64 `json:"itemsCompletedCount,omitempty" azure:"ro"`

	// READ-ONLY; Number of items
	ItemsCount *int64 `json:"itemsCount,omitempty" azure:"ro"`

	// READ-ONLY; Name of the item
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current state of migration
	State *MigrationState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty" azure:"ro"`
}

// Database - Information about a single database
type Database struct {
	// Collation name of the database
	Collation *string `json:"collation,omitempty"`

	// SQL Server compatibility level of database
	CompatibilityLevel *DatabaseCompatLevel `json:"compatibilityLevel,omitempty"`

	// State of the database
	DatabaseState *DatabaseState `json:"databaseState,omitempty"`

	// Fully qualified name
	Fqdn *string `json:"fqdn,omitempty"`

	// Unique identifier for the database
	ID *string `json:"id,omitempty"`

	// Install id of the database
	InstallID *string `json:"installId,omitempty"`

	// Name of the database
	Name *string `json:"name,omitempty"`

	// Number of cores on the server
	ServerCoreCount *int32 `json:"serverCoreCount,omitempty"`

	// Default path of the backup folder
	ServerDefaultBackupPath *string `json:"serverDefaultBackupPath,omitempty"`

	// Default path of the data files
	ServerDefaultDataPath *string `json:"serverDefaultDataPath,omitempty"`

	// Default path of the log files
	ServerDefaultLogPath *string `json:"serverDefaultLogPath,omitempty"`

	// Edition of the server
	ServerEdition *string `json:"serverEdition,omitempty"`

	// The unique Server Id
	ServerID *string `json:"serverId,omitempty"`

	// Product level of the server (RTM, SP, CTP).
	ServerLevel *string `json:"serverLevel,omitempty"`

	// Name of the server
	ServerName *string `json:"serverName,omitempty"`

	// Version of the server
	ServerVersion *string `json:"serverVersion,omitempty"`

	// Number of cores on the server that have VISIBLE ONLINE status
	ServerVisibleOnlineCoreCount *int32 `json:"serverVisibleOnlineCoreCount,omitempty"`
}

// DatabaseBackupInfo - Information about backup files when existing backup mode is used.
type DatabaseBackupInfo struct {
	// READ-ONLY; The list of backup files for the current database.
	BackupFiles []*string `json:"backupFiles,omitempty" azure:"ro"`

	// READ-ONLY; Date and time when the backup operation finished.
	BackupFinishDate *time.Time `json:"backupFinishDate,omitempty" azure:"ro"`

	// READ-ONLY; Backup Type.
	BackupType *BackupType `json:"backupType,omitempty" azure:"ro"`

	// READ-ONLY; Database name.
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; Number of files in the backup set.
	FamilyCount *int32 `json:"familyCount,omitempty" azure:"ro"`

	// READ-ONLY; Whether the backup set is compressed
	IsCompressed *bool `json:"isCompressed,omitempty" azure:"ro"`

	// READ-ONLY; Database was damaged when backed up, but the backup operation was requested to continue despite errors.
	IsDamaged *bool `json:"isDamaged,omitempty" azure:"ro"`

	// READ-ONLY; Position of current database backup in the file.
	Position *int32 `json:"position,omitempty" azure:"ro"`
}

// DatabaseFileInfo - Database file specific information
type DatabaseFileInfo struct {
	// Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`

	// Database file type
	FileType *DatabaseFileType `json:"fileType,omitempty"`

	// Unique identifier for database file
	ID *string `json:"id,omitempty"`

	// Logical name of the file
	LogicalName *string `json:"logicalName,omitempty"`

	// Operating-system full path of the file
	PhysicalFullName *string `json:"physicalFullName,omitempty"`

	// Suggested full path of the file for restoring
	RestoreFullName *string `json:"restoreFullName,omitempty"`

	// Size of the file in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty"`
}

// DatabaseFileInput - Database file specific information for input
type DatabaseFileInput struct {
	// Database file type
	FileType *DatabaseFileType `json:"fileType,omitempty"`

	// Unique identifier for database file
	ID *string `json:"id,omitempty"`

	// Logical name of the file
	LogicalName *string `json:"logicalName,omitempty"`

	// Operating-system full path of the file
	PhysicalFullName *string `json:"physicalFullName,omitempty"`

	// Suggested full path of the file for restoring
	RestoreFullName *string `json:"restoreFullName,omitempty"`
}

// DatabaseInfo - Project Database Details
type DatabaseInfo struct {
	// REQUIRED; Name of the database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
}

// DatabaseObjectName - A representation of the name of an object in a database
type DatabaseObjectName struct {
	// Type of the object in the database
	ObjectType *ObjectType `json:"objectType,omitempty"`

	// READ-ONLY; The unescaped name of the database containing the object
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; The unescaped name of the object
	ObjectName *string `json:"objectName,omitempty" azure:"ro"`

	// READ-ONLY; The unescaped name of the schema containing the object
	SchemaName *string `json:"schemaName,omitempty" azure:"ro"`
}

// DatabaseSummaryResult - Summary of database results in the migration
type DatabaseSummaryResult struct {
	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty" azure:"ro"`

	// READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64 `json:"itemsCompletedCount,omitempty" azure:"ro"`

	// READ-ONLY; Number of items
	ItemsCount *int64 `json:"itemsCount,omitempty" azure:"ro"`

	// READ-ONLY; Name of the item
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty" azure:"ro"`

	// READ-ONLY; Size of the database in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current state of migration
	State *MigrationState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty" azure:"ro"`
}

// DatabaseTable - Table properties
type DatabaseTable struct {
	// READ-ONLY; Indicates whether table is empty or not
	HasRows *bool `json:"hasRows,omitempty" azure:"ro"`

	// READ-ONLY; Schema-qualified name of the table
	Name *string `json:"name,omitempty" azure:"ro"`
}

// Error - Migration Task errors
type Error struct {
	// Error type
	Type *ErrorType `json:"type,omitempty"`

	// READ-ONLY; Error description
	Message *string `json:"message,omitempty" azure:"ro"`
}

// ExecutionStatistics - Description about the errors happen while performing migration validation
type ExecutionStatistics struct {
	// CPU Time in millisecond(s) for the query execution
	CPUTimeMs *float32 `json:"cpuTimeMs,omitempty"`

	// Time taken in millisecond(s) for executing the query
	ElapsedTimeMs *float32 `json:"elapsedTimeMs,omitempty"`

	// No. of query executions
	ExecutionCount *int64 `json:"executionCount,omitempty"`

	// Indicates whether the query resulted in an error
	HasErrors *bool `json:"hasErrors,omitempty"`

	// List of sql Errors
	SQLErrors []*string `json:"sqlErrors,omitempty"`

	// Dictionary of sql query execution wait types and the respective statistics
	WaitStats map[string]*WaitStatistics `json:"waitStats,omitempty"`
}

// FileList - OData page of files
type FileList struct {
	// URL to load the next page of files
	NextLink *string `json:"nextLink,omitempty"`

	// List of files
	Value []*ProjectFile `json:"value,omitempty"`
}

// FileShare - File share information with Path, Username, and Password.
type FileShare struct {
	// REQUIRED; The folder path for this share.
	Path *string `json:"path,omitempty"`

	// Password credential used to connect to the share location.
	Password *string `json:"password,omitempty"`

	// User name credential to connect to the share location
	UserName *string `json:"userName,omitempty"`
}

// FileStorageInfo - File storage information.
type FileStorageInfo struct {
	// Dictionary of
	Headers map[string]*string `json:"headers,omitempty"`

	// A URI that can be used to access the file content.
	URI *string `json:"uri,omitempty"`
}

// FilesClientCreateOrUpdateOptions contains the optional parameters for the FilesClient.CreateOrUpdate method.
type FilesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// FilesClientDeleteOptions contains the optional parameters for the FilesClient.Delete method.
type FilesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// FilesClientGetOptions contains the optional parameters for the FilesClient.Get method.
type FilesClientGetOptions struct {
	// placeholder for future optional parameters
}

// FilesClientListOptions contains the optional parameters for the FilesClient.List method.
type FilesClientListOptions struct {
	// placeholder for future optional parameters
}

// FilesClientReadOptions contains the optional parameters for the FilesClient.Read method.
type FilesClientReadOptions struct {
	// placeholder for future optional parameters
}

// FilesClientReadWriteOptions contains the optional parameters for the FilesClient.ReadWrite method.
type FilesClientReadWriteOptions struct {
	// placeholder for future optional parameters
}

// FilesClientUpdateOptions contains the optional parameters for the FilesClient.Update method.
type FilesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// GetProjectDetailsNonSQLTaskInput - Input for the task that reads configuration from project artifacts
type GetProjectDetailsNonSQLTaskInput struct {
	// REQUIRED; A URL that points to the location to access project artifacts
	ProjectLocation *string `json:"projectLocation,omitempty"`

	// REQUIRED; Name of the migration project
	ProjectName *string `json:"projectName,omitempty"`
}

// GetTdeCertificatesSQLTaskInput - Input for the task that gets TDE certificates in Base64 encoded format.
type GetTdeCertificatesSQLTaskInput struct {
	// REQUIRED; Backup file share information for file share to be used for temporarily storing files.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`

	// REQUIRED; Connection information for SQL Server
	ConnectionInfo *SQLConnectionInfo `json:"connectionInfo,omitempty"`

	// REQUIRED; List containing certificate names and corresponding password to use for encrypting the exported certificate.
	SelectedCertificates []*SelectedCertificateInput `json:"selectedCertificates,omitempty"`
}

// GetTdeCertificatesSQLTaskOutput - Output of the task that gets TDE certificates in Base64 encoded format.
type GetTdeCertificatesSQLTaskOutput struct {
	// READ-ONLY; Mapping from certificate name to base 64 encoded format.
	Base64EncodedCertificates *string `json:"base64EncodedCertificates,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// GetTdeCertificatesSQLTaskProperties - Properties for the task that gets TDE certificates in Base64 encoded format.
type GetTdeCertificatesSQLTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *GetTdeCertificatesSQLTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*GetTdeCertificatesSQLTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type GetTdeCertificatesSQLTaskProperties.
func (g *GetTdeCertificatesSQLTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   g.TaskType,
		Errors:     g.Errors,
		State:      g.State,
		Commands:   g.Commands,
		ClientData: g.ClientData,
	}
}

// GetUserTablesMySQLTaskInput - Input for the task that collects user tables for the given list of databases
type GetUserTablesMySQLTaskInput struct {
	// REQUIRED; Connection information for SQL Server
	ConnectionInfo *MySQLConnectionInfo `json:"connectionInfo,omitempty"`

	// REQUIRED; List of database names to collect tables for
	SelectedDatabases []*string `json:"selectedDatabases,omitempty"`
}

// GetUserTablesMySQLTaskOutput - Output of the task that collects user tables for the given list of databases
type GetUserTablesMySQLTaskOutput struct {
	// READ-ONLY; Mapping from database name to list of tables
	DatabasesToTables *string `json:"databasesToTables,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// GetUserTablesMySQLTaskProperties - Properties for the task that collects user tables for the given list of databases
type GetUserTablesMySQLTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *GetUserTablesMySQLTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*GetUserTablesMySQLTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type GetUserTablesMySQLTaskProperties.
func (g *GetUserTablesMySQLTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   g.TaskType,
		Errors:     g.Errors,
		State:      g.State,
		Commands:   g.Commands,
		ClientData: g.ClientData,
	}
}

// GetUserTablesOracleTaskInput - Input for the task that gets the list of tables contained within a provided list of Oracle
// schemas.
type GetUserTablesOracleTaskInput struct {
	// REQUIRED; Information for connecting to Oracle source
	ConnectionInfo *OracleConnectionInfo `json:"connectionInfo,omitempty"`

	// REQUIRED; List of Oracle schemas for which to collect tables
	SelectedSchemas []*string `json:"selectedSchemas,omitempty"`
}

// GetUserTablesOracleTaskOutput - Output for the task that gets the list of tables contained within a provided list of Oracle
// schemas.
type GetUserTablesOracleTaskOutput struct {
	// READ-ONLY; The schema this result is for
	SchemaName *string `json:"schemaName,omitempty" azure:"ro"`

	// READ-ONLY; List of valid tables found for this schema
	Tables []*DatabaseTable `json:"tables,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors associated with the task
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// GetUserTablesOracleTaskProperties - Properties for the task that collects user tables for the given list of Oracle schemas
type GetUserTablesOracleTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *GetUserTablesOracleTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*GetUserTablesOracleTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type GetUserTablesOracleTaskProperties.
func (g *GetUserTablesOracleTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   g.TaskType,
		Errors:     g.Errors,
		State:      g.State,
		Commands:   g.Commands,
		ClientData: g.ClientData,
	}
}

// GetUserTablesPostgreSQLTaskInput - Input for the task that gets the list of tables for a provided list of PostgreSQL databases.
type GetUserTablesPostgreSQLTaskInput struct {
	// REQUIRED; Information for connecting to PostgreSQL source
	ConnectionInfo *PostgreSQLConnectionInfo `json:"connectionInfo,omitempty"`

	// REQUIRED; List of PostgreSQL databases for which to collect tables
	SelectedDatabases []*string `json:"selectedDatabases,omitempty"`
}

// GetUserTablesPostgreSQLTaskOutput - Output for the task that gets the list of tables for a provided list of PostgreSQL
// databases.
type GetUserTablesPostgreSQLTaskOutput struct {
	// READ-ONLY; The database this result is for
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; List of valid tables found for this database
	Tables []*DatabaseTable `json:"tables,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors associated with the task
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// GetUserTablesPostgreSQLTaskProperties - Properties for the task that collects user tables for the given list of databases
type GetUserTablesPostgreSQLTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *GetUserTablesPostgreSQLTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*GetUserTablesPostgreSQLTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type GetUserTablesPostgreSQLTaskProperties.
func (g *GetUserTablesPostgreSQLTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   g.TaskType,
		Errors:     g.Errors,
		State:      g.State,
		Commands:   g.Commands,
		ClientData: g.ClientData,
	}
}

// GetUserTablesSQLSyncTaskInput - Input for the task that collects user tables for the given list of databases
type GetUserTablesSQLSyncTaskInput struct {
	// REQUIRED; List of source database names to collect tables for
	SelectedSourceDatabases []*string `json:"selectedSourceDatabases,omitempty"`

	// REQUIRED; List of target database names to collect tables for
	SelectedTargetDatabases []*string `json:"selectedTargetDatabases,omitempty"`

	// REQUIRED; Connection information for SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Connection information for SQL DB
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// GetUserTablesSQLSyncTaskOutput - Output of the task that collects user tables for the given list of databases
type GetUserTablesSQLSyncTaskOutput struct {
	// READ-ONLY; Mapping from database name to list of source tables
	DatabasesToSourceTables *string `json:"databasesToSourceTables,omitempty" azure:"ro"`

	// READ-ONLY; Mapping from database name to list of target tables
	DatabasesToTargetTables *string `json:"databasesToTargetTables,omitempty" azure:"ro"`

	// READ-ONLY; Mapping from database name to list of validation errors
	TableValidationErrors *string `json:"tableValidationErrors,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// GetUserTablesSQLSyncTaskProperties - Properties for the task that collects user tables for the given list of databases
type GetUserTablesSQLSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *GetUserTablesSQLSyncTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*GetUserTablesSQLSyncTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type GetUserTablesSQLSyncTaskProperties.
func (g *GetUserTablesSQLSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   g.TaskType,
		Errors:     g.Errors,
		State:      g.State,
		Commands:   g.Commands,
		ClientData: g.ClientData,
	}
}

// GetUserTablesSQLTaskInput - Input for the task that collects user tables for the given list of databases
type GetUserTablesSQLTaskInput struct {
	// REQUIRED; Connection information for SQL Server
	ConnectionInfo *SQLConnectionInfo `json:"connectionInfo,omitempty"`

	// REQUIRED; List of database names to collect tables for
	SelectedDatabases []*string `json:"selectedDatabases,omitempty"`
}

// GetUserTablesSQLTaskOutput - Output of the task that collects user tables for the given list of databases
type GetUserTablesSQLTaskOutput struct {
	// READ-ONLY; Mapping from database name to list of tables
	DatabasesToTables *string `json:"databasesToTables,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// GetUserTablesSQLTaskProperties - Properties for the task that collects user tables for the given list of databases
type GetUserTablesSQLTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *GetUserTablesSQLTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*GetUserTablesSQLTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type GetUserTablesSQLTaskProperties.
func (g *GetUserTablesSQLTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   g.TaskType,
		Errors:     g.Errors,
		State:      g.State,
		Commands:   g.Commands,
		ClientData: g.ClientData,
	}
}

// InstallOCIDriverTaskInput - Input for the service task to install an OCI driver.
type InstallOCIDriverTaskInput struct {
	// Name of the uploaded driver package to install.
	DriverPackageName *string `json:"driverPackageName,omitempty"`
}

// InstallOCIDriverTaskOutput - Output for the service task to install an OCI driver.
type InstallOCIDriverTaskOutput struct {
	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// InstallOCIDriverTaskProperties - Properties for the task that installs an OCI driver.
type InstallOCIDriverTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Input for the service task to install an OCI driver.
	Input *InstallOCIDriverTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*InstallOCIDriverTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type InstallOCIDriverTaskProperties.
func (i *InstallOCIDriverTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   i.TaskType,
		Errors:     i.Errors,
		State:      i.State,
		Commands:   i.Commands,
		ClientData: i.ClientData,
	}
}

// MiSQLConnectionInfo - Properties required to create a connection to Azure SQL database Managed instance
type MiSQLConnectionInfo struct {
	// REQUIRED; Resource id for Azure SQL database Managed instance
	ManagedInstanceResourceID *string `json:"managedInstanceResourceId,omitempty"`

	// REQUIRED; Type of connection info
	Type *string `json:"type,omitempty"`

	// Password credential.
	Password *string `json:"password,omitempty"`

	// User name
	UserName *string `json:"userName,omitempty"`
}

// GetConnectionInfo implements the ConnectionInfoClassification interface for type MiSQLConnectionInfo.
func (m *MiSQLConnectionInfo) GetConnectionInfo() *ConnectionInfo {
	return &ConnectionInfo{
		Type:     m.Type,
		UserName: m.UserName,
		Password: m.Password,
	}
}

// MigrateMISyncCompleteCommandInput - Input for command that completes online migration for an Azure SQL Database Managed
// Instance.
type MigrateMISyncCompleteCommandInput struct {
	// REQUIRED; Name of managed instance database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
}

// MigrateMISyncCompleteCommandOutput - Output for command that completes online migration for an Azure SQL Database Managed
// Instance.
type MigrateMISyncCompleteCommandOutput struct {
	// List of errors that happened during the command execution
	Errors []*ReportableException `json:"errors,omitempty"`
}

// MigrateMISyncCompleteCommandProperties - Properties for the command that completes online migration for an Azure SQL Database
// Managed Instance.
type MigrateMISyncCompleteCommandProperties struct {
	// REQUIRED; Command type.
	CommandType *string `json:"commandType,omitempty"`

	// Command input
	Input *MigrateMISyncCompleteCommandInput `json:"input,omitempty"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Command output. This is ignored if submitted.
	Output *MigrateMISyncCompleteCommandOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the command. This is ignored if submitted.
	State *CommandState `json:"state,omitempty" azure:"ro"`
}

// GetCommandProperties implements the CommandPropertiesClassification interface for type MigrateMISyncCompleteCommandProperties.
func (m *MigrateMISyncCompleteCommandProperties) GetCommandProperties() *CommandProperties {
	return &CommandProperties{
		CommandType: m.CommandType,
		Errors:      m.Errors,
		State:       m.State,
	}
}

// MigrateMongoDbTaskProperties - Properties for the task that migrates data between MongoDB data sources
type MigrateMongoDbTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Describes how a MongoDB data migration should be performed
	Input *MongoDbMigrationSettings `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY
	Output []MongoDbProgressClassification `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateMongoDbTaskProperties.
func (m *MigrateMongoDbTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   m.TaskType,
		Errors:     m.Errors,
		State:      m.State,
		Commands:   m.Commands,
		ClientData: m.ClientData,
	}
}

// MigrateMySQLAzureDbForMySQLOfflineDatabaseInput - Database specific information for offline MySQL to Azure Database for
// MySQL migration task inputs
type MigrateMySQLAzureDbForMySQLOfflineDatabaseInput struct {
	// Name of the database
	Name *string `json:"name,omitempty"`

	// Mapping of source to target tables
	TableMap map[string]*string `json:"tableMap,omitempty"`

	// Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
}

// MigrateMySQLAzureDbForMySQLOfflineTaskInput - Input for the task that migrates MySQL databases to Azure Database for MySQL
// for offline migrations
type MigrateMySQLAzureDbForMySQLOfflineTaskInput struct {
	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateMySQLAzureDbForMySQLOfflineDatabaseInput `json:"selectedDatabases,omitempty"`

	// REQUIRED; Connection information for source MySQL
	SourceConnectionInfo *MySQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Connection information for target Azure Database for MySQL
	TargetConnectionInfo *MySQLConnectionInfo `json:"targetConnectionInfo,omitempty"`

	// Setting to set the source server read only
	MakeSourceServerReadOnly *bool `json:"makeSourceServerReadOnly,omitempty"`

	// Optional parameters for fine tuning the data transfer rate during migration
	OptionalAgentSettings map[string]*string `json:"optionalAgentSettings,omitempty"`

	// Parameter to specify when the migration started
	StartedOn *time.Time `json:"startedOn,omitempty"`
}

// MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification provides polymorphic access to related types.
// Call the interface's GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *MigrateMySQLAzureDbForMySQLOfflineTaskOutput, *MigrateMySQLAzureDbForMySQLOfflineTaskOutputDatabaseLevel, *MigrateMySQLAzureDbForMySQLOfflineTaskOutputError,
// - *MigrateMySQLAzureDbForMySQLOfflineTaskOutputMigrationLevel, *MigrateMySQLAzureDbForMySQLOfflineTaskOutputTableLevel
type MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification interface {
	// GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput returns the MigrateMySQLAzureDbForMySQLOfflineTaskOutput content of the underlying type.
	GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput() *MigrateMySQLAzureDbForMySQLOfflineTaskOutput
}

// MigrateMySQLAzureDbForMySQLOfflineTaskOutput - Output for the task that migrates MySQL databases to Azure Database for
// MySQL for offline migrations
type MigrateMySQLAzureDbForMySQLOfflineTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput implements the MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification
// interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutput.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskOutput) GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput() *MigrateMySQLAzureDbForMySQLOfflineTaskOutput {
	return m
}

type MigrateMySQLAzureDbForMySQLOfflineTaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Number of database/object errors.
	ErrorCount *int64 `json:"errorCount,omitempty" azure:"ro"`

	// READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty" azure:"ro"`

	// READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings []*ReportableException `json:"exceptionsAndWarnings,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Last time the storage was updated
	LastStorageUpdate *time.Time `json:"lastStorageUpdate,omitempty" azure:"ro"`

	// READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Number of objects
	NumberOfObjects *int64 `json:"numberOfObjects,omitempty" azure:"ro"`

	// READ-ONLY; Number of successfully completed objects
	NumberOfObjectsCompleted *int64 `json:"numberOfObjectsCompleted,omitempty" azure:"ro"`

	// READ-ONLY; Summary of object results in the migration
	ObjectSummary *string `json:"objectSummary,omitempty" azure:"ro"`

	// READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty" azure:"ro"`

	// READ-ONLY; Migration stage that this database is in
	Stage *DatabaseMigrationStage `json:"stage,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current state of migration
	State *MigrationState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty" azure:"ro"`
}

// GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput implements the MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification
// interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutputDatabaseLevel.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskOutputDatabaseLevel) GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput() *MigrateMySQLAzureDbForMySQLOfflineTaskOutput {
	return &MigrateMySQLAzureDbForMySQLOfflineTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateMySQLAzureDbForMySQLOfflineTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput implements the MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification
// interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutputError.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskOutputError) GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput() *MigrateMySQLAzureDbForMySQLOfflineTaskOutput {
	return &MigrateMySQLAzureDbForMySQLOfflineTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateMySQLAzureDbForMySQLOfflineTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// Selected databases as a map from database name to database id
	Databases *string `json:"databases,omitempty"`

	// Migration Report Result, provides unique url for downloading your migration report.
	MigrationReportResult *MigrationReportResult `json:"migrationReportResult,omitempty"`

	// READ-ONLY; Summary of database results in the migration
	DatabaseSummary *string `json:"databaseSummary,omitempty" azure:"ro"`

	// READ-ONLY; Duration of task execution in seconds.
	DurationInSeconds *int64 `json:"durationInSeconds,omitempty" azure:"ro"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings []*ReportableException `json:"exceptionsAndWarnings,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Last time the storage was updated
	LastStorageUpdate *time.Time `json:"lastStorageUpdate,omitempty" azure:"ro"`

	// READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current status of migration
	Status *MigrationStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Migration status message
	StatusMessage *string `json:"statusMessage,omitempty" azure:"ro"`

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty" azure:"ro"`
}

// GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput implements the MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification
// interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutputMigrationLevel.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskOutputMigrationLevel) GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput() *MigrateMySQLAzureDbForMySQLOfflineTaskOutput {
	return &MigrateMySQLAzureDbForMySQLOfflineTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateMySQLAzureDbForMySQLOfflineTaskOutputTableLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64 `json:"itemsCompletedCount,omitempty" azure:"ro"`

	// READ-ONLY; Number of items
	ItemsCount *int64 `json:"itemsCount,omitempty" azure:"ro"`

	// READ-ONLY; Last time the storage was updated
	LastStorageUpdate *time.Time `json:"lastStorageUpdate,omitempty" azure:"ro"`

	// READ-ONLY; Name of the item
	ObjectName *string `json:"objectName,omitempty" azure:"ro"`

	// READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current state of migration
	State *MigrationState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty" azure:"ro"`
}

// GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput implements the MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification
// interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutputTableLevel.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskOutputTableLevel) GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput() *MigrateMySQLAzureDbForMySQLOfflineTaskOutput {
	return &MigrateMySQLAzureDbForMySQLOfflineTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateMySQLAzureDbForMySQLOfflineTaskProperties - Properties for the task that migrates MySQL databases to Azure Database
// for MySQL for offline migrations
type MigrateMySQLAzureDbForMySQLOfflineTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *MigrateMySQLAzureDbForMySQLOfflineTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateMySQLAzureDbForMySQLOfflineTaskProperties.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   m.TaskType,
		Errors:     m.Errors,
		State:      m.State,
		Commands:   m.Commands,
		ClientData: m.ClientData,
	}
}

// MigrateMySQLAzureDbForMySQLSyncDatabaseInput - Database specific information for MySQL to Azure Database for MySQL migration
// task inputs
type MigrateMySQLAzureDbForMySQLSyncDatabaseInput struct {
	// Migration settings which tune the migration behavior
	MigrationSetting map[string]*string `json:"migrationSetting,omitempty"`

	// Name of the database
	Name *string `json:"name,omitempty"`

	// Source settings to tune source endpoint migration behavior
	SourceSetting map[string]*string `json:"sourceSetting,omitempty"`

	// Mapping of source to target tables
	TableMap map[string]*string `json:"tableMap,omitempty"`

	// Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`

	// Target settings to tune target endpoint migration behavior
	TargetSetting map[string]*string `json:"targetSetting,omitempty"`
}

// MigrateMySQLAzureDbForMySQLSyncTaskInput - Input for the task that migrates MySQL databases to Azure Database for MySQL
// for online migrations
type MigrateMySQLAzureDbForMySQLSyncTaskInput struct {
	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateMySQLAzureDbForMySQLSyncDatabaseInput `json:"selectedDatabases,omitempty"`

	// REQUIRED; Connection information for source MySQL
	SourceConnectionInfo *MySQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Connection information for target Azure Database for MySQL
	TargetConnectionInfo *MySQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification provides polymorphic access to related types.
// Call the interface's GetMigrateMySQLAzureDbForMySQLSyncTaskOutput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *MigrateMySQLAzureDbForMySQLSyncTaskOutput, *MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError, *MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel,
// - *MigrateMySQLAzureDbForMySQLSyncTaskOutputError, *MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel, *MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel
type MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification interface {
	// GetMigrateMySQLAzureDbForMySQLSyncTaskOutput returns the MigrateMySQLAzureDbForMySQLSyncTaskOutput content of the underlying type.
	GetMigrateMySQLAzureDbForMySQLSyncTaskOutput() *MigrateMySQLAzureDbForMySQLSyncTaskOutput
}

// MigrateMySQLAzureDbForMySQLSyncTaskOutput - Output for the task that migrates MySQL databases to Azure Database for MySQL
// for online migrations
type MigrateMySQLAzureDbForMySQLSyncTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateMySQLAzureDbForMySQLSyncTaskOutput implements the MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification interface
// for type MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutput) GetMigrateMySQLAzureDbForMySQLSyncTaskOutput() *MigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return m
}

type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// Error message
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// List of error events.
	Events []*SyncMigrationDatabaseErrorEvent `json:"events,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateMySQLAzureDbForMySQLSyncTaskOutput implements the MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification interface
// for type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) GetMigrateMySQLAzureDbForMySQLSyncTaskOutput() *MigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return &MigrateMySQLAzureDbForMySQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Number of applied changes
	AppliedChanges *int64 `json:"appliedChanges,omitempty" azure:"ro"`

	// READ-ONLY; Number of cdc deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of cdc inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of cdc updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty" azure:"ro"`

	// READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Number of tables completed in full load
	FullLoadCompletedTables *int64 `json:"fullLoadCompletedTables,omitempty" azure:"ro"`

	// READ-ONLY; Number of tables errored in full load
	FullLoadErroredTables *int64 `json:"fullLoadErroredTables,omitempty" azure:"ro"`

	// READ-ONLY; Number of tables loading in full load
	FullLoadLoadingTables *int64 `json:"fullLoadLoadingTables,omitempty" azure:"ro"`

	// READ-ONLY; Number of tables queued in full load
	FullLoadQueuedTables *int64 `json:"fullLoadQueuedTables,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Number of incoming changes
	IncomingChanges *int64 `json:"incomingChanges,omitempty" azure:"ro"`

	// READ-ONLY; Indicates if initial load (full load) has been completed
	InitializationCompleted *bool `json:"initializationCompleted,omitempty" azure:"ro"`

	// READ-ONLY; CDC apply latency
	Latency *int64 `json:"latency,omitempty" azure:"ro"`

	// READ-ONLY; Migration state that this database is in
	MigrationState *SyncDatabaseMigrationReportingState `json:"migrationState,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`
}

// GetMigrateMySQLAzureDbForMySQLSyncTaskOutput implements the MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification interface
// for type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) GetMigrateMySQLAzureDbForMySQLSyncTaskOutput() *MigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return &MigrateMySQLAzureDbForMySQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateMySQLAzureDbForMySQLSyncTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateMySQLAzureDbForMySQLSyncTaskOutput implements the MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification interface
// for type MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutputError) GetMigrateMySQLAzureDbForMySQLSyncTaskOutput() *MigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return &MigrateMySQLAzureDbForMySQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Source server name
	SourceServer *string `json:"sourceServer,omitempty" azure:"ro"`

	// READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Target server name
	TargetServer *string `json:"targetServer,omitempty" azure:"ro"`

	// READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty" azure:"ro"`
}

// GetMigrateMySQLAzureDbForMySQLSyncTaskOutput implements the MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification interface
// for type MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) GetMigrateMySQLAzureDbForMySQLSyncTaskOutput() *MigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return &MigrateMySQLAzureDbForMySQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Number of applied deletes
	CdcDeleteCounter *string `json:"cdcDeleteCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of applied inserts
	CdcInsertCounter *string `json:"cdcInsertCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of applied updates
	CdcUpdateCounter *string `json:"cdcUpdateCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of data errors occurred
	DataErrorsCounter *int64 `json:"dataErrorsCounter,omitempty" azure:"ro"`

	// READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; Full load end time
	FullLoadEndedOn *time.Time `json:"fullLoadEndedOn,omitempty" azure:"ro"`

	// READ-ONLY; Estimate to finish full load
	FullLoadEstFinishTime *time.Time `json:"fullLoadEstFinishTime,omitempty" azure:"ro"`

	// READ-ONLY; Full load start time
	FullLoadStartedOn *time.Time `json:"fullLoadStartedOn,omitempty" azure:"ro"`

	// READ-ONLY; Number of rows applied in full load
	FullLoadTotalRows *int64 `json:"fullLoadTotalRows,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Last modified time on target
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Current state of the table migration
	State *SyncTableMigrationState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Name of the table
	TableName *string `json:"tableName,omitempty" azure:"ro"`

	// READ-ONLY; Total number of applied changes
	TotalChangesApplied *int64 `json:"totalChangesApplied,omitempty" azure:"ro"`
}

// GetMigrateMySQLAzureDbForMySQLSyncTaskOutput implements the MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification interface
// for type MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) GetMigrateMySQLAzureDbForMySQLSyncTaskOutput() *MigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return &MigrateMySQLAzureDbForMySQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateMySQLAzureDbForMySQLSyncTaskProperties - Properties for the task that migrates MySQL databases to Azure Database
// for MySQL for online migrations
type MigrateMySQLAzureDbForMySQLSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *MigrateMySQLAzureDbForMySQLSyncTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   m.TaskType,
		Errors:     m.Errors,
		State:      m.State,
		Commands:   m.Commands,
		ClientData: m.ClientData,
	}
}

// MigrateOracleAzureDbForPostgreSQLSyncTaskProperties - Properties for the task that migrates Oracle to Azure Database for
// PostgreSQL for online migrations
type MigrateOracleAzureDbForPostgreSQLSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *MigrateOracleAzureDbPostgreSQLSyncTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (m *MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   m.TaskType,
		Errors:     m.Errors,
		State:      m.State,
		Commands:   m.Commands,
		ClientData: m.ClientData,
	}
}

// MigrateOracleAzureDbPostgreSQLSyncDatabaseInput - Database specific information for Oracle to Azure Database for PostgreSQL
// migration task inputs
type MigrateOracleAzureDbPostgreSQLSyncDatabaseInput struct {
	// How to handle object name casing: either Preserve or ToLower
	CaseManipulation *string `json:"caseManipulation,omitempty"`

	// Migration settings which tune the migration behavior
	MigrationSetting map[string]*string `json:"migrationSetting,omitempty"`

	// Name of the migration pipeline
	Name *string `json:"name,omitempty"`

	// Name of the source schema
	SchemaName *string `json:"schemaName,omitempty"`

	// Source settings to tune source endpoint migration behavior
	SourceSetting map[string]*string `json:"sourceSetting,omitempty"`

	// Mapping of source to target tables
	TableMap map[string]*string `json:"tableMap,omitempty"`

	// Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`

	// Target settings to tune target endpoint migration behavior
	TargetSetting map[string]*string `json:"targetSetting,omitempty"`
}

// MigrateOracleAzureDbPostgreSQLSyncTaskInput - Input for the task that migrates Oracle databases to Azure Database for PostgreSQL
// for online migrations
type MigrateOracleAzureDbPostgreSQLSyncTaskInput struct {
	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateOracleAzureDbPostgreSQLSyncDatabaseInput `json:"selectedDatabases,omitempty"`

	// REQUIRED; Connection information for source Oracle
	SourceConnectionInfo *OracleConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Connection information for target Azure Database for PostgreSQL
	TargetConnectionInfo *PostgreSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification provides polymorphic access to related types.
// Call the interface's GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *MigrateOracleAzureDbPostgreSQLSyncTaskOutput, *MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError, *MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel,
// - *MigrateOracleAzureDbPostgreSQLSyncTaskOutputError, *MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel, *MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel
type MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification interface {
	// GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput returns the MigrateOracleAzureDbPostgreSQLSyncTaskOutput content of the underlying type.
	GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput() *MigrateOracleAzureDbPostgreSQLSyncTaskOutput
}

// MigrateOracleAzureDbPostgreSQLSyncTaskOutput - Output for the task that migrates Oracle databases to Azure Database for
// PostgreSQL for online migrations
type MigrateOracleAzureDbPostgreSQLSyncTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput implements the MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification
// interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutput.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutput) GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput() *MigrateOracleAzureDbPostgreSQLSyncTaskOutput {
	return m
}

type MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// Error message
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// List of error events.
	Events []*SyncMigrationDatabaseErrorEvent `json:"events,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput implements the MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification
// interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError) GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput() *MigrateOracleAzureDbPostgreSQLSyncTaskOutput {
	return &MigrateOracleAzureDbPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Number of applied changes
	AppliedChanges *int64 `json:"appliedChanges,omitempty" azure:"ro"`

	// READ-ONLY; Number of cdc deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of cdc inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of cdc updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty" azure:"ro"`

	// READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Number of tables completed in full load
	FullLoadCompletedTables *int64 `json:"fullLoadCompletedTables,omitempty" azure:"ro"`

	// READ-ONLY; Number of tables errored in full load
	FullLoadErroredTables *int64 `json:"fullLoadErroredTables,omitempty" azure:"ro"`

	// READ-ONLY; Number of tables loading in full load
	FullLoadLoadingTables *int64 `json:"fullLoadLoadingTables,omitempty" azure:"ro"`

	// READ-ONLY; Number of tables queued in full load
	FullLoadQueuedTables *int64 `json:"fullLoadQueuedTables,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Number of incoming changes
	IncomingChanges *int64 `json:"incomingChanges,omitempty" azure:"ro"`

	// READ-ONLY; Indicates if initial load (full load) has been completed
	InitializationCompleted *bool `json:"initializationCompleted,omitempty" azure:"ro"`

	// READ-ONLY; CDC apply latency
	Latency *int64 `json:"latency,omitempty" azure:"ro"`

	// READ-ONLY; Migration state that this database is in
	MigrationState *SyncDatabaseMigrationReportingState `json:"migrationState,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`
}

// GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput implements the MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification
// interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel) GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput() *MigrateOracleAzureDbPostgreSQLSyncTaskOutput {
	return &MigrateOracleAzureDbPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateOracleAzureDbPostgreSQLSyncTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput implements the MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification
// interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputError.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutputError) GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput() *MigrateOracleAzureDbPostgreSQLSyncTaskOutput {
	return &MigrateOracleAzureDbPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Source server name
	SourceServer *string `json:"sourceServer,omitempty" azure:"ro"`

	// READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Target server name
	TargetServer *string `json:"targetServer,omitempty" azure:"ro"`

	// READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty" azure:"ro"`
}

// GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput implements the MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification
// interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel) GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput() *MigrateOracleAzureDbPostgreSQLSyncTaskOutput {
	return &MigrateOracleAzureDbPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Number of applied deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of applied inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of applied updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of data errors occurred
	DataErrorsCounter *int64 `json:"dataErrorsCounter,omitempty" azure:"ro"`

	// READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; Full load end time
	FullLoadEndedOn *time.Time `json:"fullLoadEndedOn,omitempty" azure:"ro"`

	// READ-ONLY; Estimate to finish full load
	FullLoadEstFinishTime *time.Time `json:"fullLoadEstFinishTime,omitempty" azure:"ro"`

	// READ-ONLY; Full load start time
	FullLoadStartedOn *time.Time `json:"fullLoadStartedOn,omitempty" azure:"ro"`

	// READ-ONLY; Number of rows applied in full load
	FullLoadTotalRows *int64 `json:"fullLoadTotalRows,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Last modified time on target
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Current state of the table migration
	State *SyncTableMigrationState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Name of the table
	TableName *string `json:"tableName,omitempty" azure:"ro"`

	// READ-ONLY; Total number of applied changes
	TotalChangesApplied *int64 `json:"totalChangesApplied,omitempty" azure:"ro"`
}

// GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput implements the MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification
// interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel) GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput() *MigrateOracleAzureDbPostgreSQLSyncTaskOutput {
	return &MigrateOracleAzureDbPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput - Database specific information for PostgreSQL to Azure Database
// for PostgreSQL migration task inputs
type MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput struct {
	// Migration settings which tune the migration behavior
	MigrationSetting map[string]*string `json:"migrationSetting,omitempty"`

	// Name of the database
	Name *string `json:"name,omitempty"`

	// Tables selected for migration
	SelectedTables []*MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseTableInput `json:"selectedTables,omitempty"`

	// Source settings to tune source endpoint migration behavior
	SourceSetting map[string]*string `json:"sourceSetting,omitempty"`

	// Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`

	// Target settings to tune target endpoint migration behavior
	TargetSetting map[string]*string `json:"targetSetting,omitempty"`
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseTableInput - Selected tables for the migration
type MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseTableInput struct {
	// Name of the table to migrate
	Name *string `json:"name,omitempty"`
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput - Input for the task that migrates PostgreSQL databases to Azure Database
// for PostgreSQL for online migrations
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput struct {
	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput `json:"selectedDatabases,omitempty"`

	// REQUIRED; Connection information for source PostgreSQL
	SourceConnectionInfo *PostgreSQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Connection information for target Azure Database for PostgreSQL
	TargetConnectionInfo *PostgreSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification provides polymorphic access to related types.
// Call the interface's GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError,
// - *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel, *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError,
// - *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel, *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification interface {
	// GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput returns the MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput content of the underlying type.
	GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput - Output for the task that migrates PostgreSQL databases to Azure Database
// for PostgreSQL for online migrations
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implements the MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification
// interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput {
	return m
}

type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// Error message
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// List of error events.
	Events []*SyncMigrationDatabaseErrorEvent `json:"events,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implements the MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification
// interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput {
	return &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Number of applied changes
	AppliedChanges *int64 `json:"appliedChanges,omitempty" azure:"ro"`

	// READ-ONLY; Number of cdc deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of cdc inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of cdc updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty" azure:"ro"`

	// READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Number of tables completed in full load
	FullLoadCompletedTables *int64 `json:"fullLoadCompletedTables,omitempty" azure:"ro"`

	// READ-ONLY; Number of tables errored in full load
	FullLoadErroredTables *int64 `json:"fullLoadErroredTables,omitempty" azure:"ro"`

	// READ-ONLY; Number of tables loading in full load
	FullLoadLoadingTables *int64 `json:"fullLoadLoadingTables,omitempty" azure:"ro"`

	// READ-ONLY; Number of tables queued in full load
	FullLoadQueuedTables *int64 `json:"fullLoadQueuedTables,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Number of incoming changes
	IncomingChanges *int64 `json:"incomingChanges,omitempty" azure:"ro"`

	// READ-ONLY; Indicates if initial load (full load) has been completed
	InitializationCompleted *bool `json:"initializationCompleted,omitempty" azure:"ro"`

	// READ-ONLY; CDC apply latency
	Latency *int64 `json:"latency,omitempty" azure:"ro"`

	// READ-ONLY; Migration state that this database is in
	MigrationState *SyncDatabaseMigrationReportingState `json:"migrationState,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`
}

// GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implements the MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification
// interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput {
	return &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implements the MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification
// interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput {
	return &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Source server name
	SourceServer *string `json:"sourceServer,omitempty" azure:"ro"`

	// READ-ONLY; Source server type.
	SourceServerType *ScenarioSource `json:"sourceServerType,omitempty" azure:"ro"`

	// READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Migration status
	State *ReplicateMigrationState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Target server name
	TargetServer *string `json:"targetServer,omitempty" azure:"ro"`

	// READ-ONLY; Target server type.
	TargetServerType *ScenarioTarget `json:"targetServerType,omitempty" azure:"ro"`

	// READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty" azure:"ro"`
}

// GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implements the MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification
// interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput {
	return &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Number of applied deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of applied inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of applied updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of data errors occurred
	DataErrorsCounter *int64 `json:"dataErrorsCounter,omitempty" azure:"ro"`

	// READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; Full load end time
	FullLoadEndedOn *time.Time `json:"fullLoadEndedOn,omitempty" azure:"ro"`

	// READ-ONLY; Estimate to finish full load
	FullLoadEstFinishTime *time.Time `json:"fullLoadEstFinishTime,omitempty" azure:"ro"`

	// READ-ONLY; Full load start time
	FullLoadStartedOn *time.Time `json:"fullLoadStartedOn,omitempty" azure:"ro"`

	// READ-ONLY; Number of rows applied in full load
	FullLoadTotalRows *int64 `json:"fullLoadTotalRows,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Last modified time on target
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Current state of the table migration
	State *SyncTableMigrationState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Name of the table
	TableName *string `json:"tableName,omitempty" azure:"ro"`

	// READ-ONLY; Total number of applied changes
	TotalChangesApplied *int64 `json:"totalChangesApplied,omitempty" azure:"ro"`
}

// GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implements the MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification
// interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput {
	return &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties - Properties for the task that migrates PostgreSQL databases to
// Azure Database for PostgreSQL for online migrations
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   m.TaskType,
		Errors:     m.Errors,
		State:      m.State,
		Commands:   m.Commands,
		ClientData: m.ClientData,
	}
}

// MigrateSQLServerDatabaseInput - Database specific information for SQL to SQL migration task inputs
type MigrateSQLServerDatabaseInput struct {
	// The backup and restore folder
	BackupAndRestoreFolder *string `json:"backupAndRestoreFolder,omitempty"`

	// The list of database files
	DatabaseFiles []*DatabaseFileInput `json:"databaseFiles,omitempty"`

	// Name of the database
	Name *string `json:"name,omitempty"`

	// Name of the database at destination
	RestoreDatabaseName *string `json:"restoreDatabaseName,omitempty"`
}

// MigrateSQLServerSQLDbDatabaseInput - Database specific information for SQL to Azure SQL DB migration task inputs
type MigrateSQLServerSQLDbDatabaseInput struct {
	// Whether to set database read only before migration
	MakeSourceDbReadOnly *bool `json:"makeSourceDbReadOnly,omitempty"`

	// Name of the database
	Name *string `json:"name,omitempty"`

	// Mapping of source to target tables
	TableMap map[string]*string `json:"tableMap,omitempty"`

	// Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
}

// MigrateSQLServerSQLDbSyncDatabaseInput - Database specific information for SQL to Azure SQL DB sync migration task inputs
type MigrateSQLServerSQLDbSyncDatabaseInput struct {
	// Unique identifier for database
	ID *string `json:"id,omitempty"`

	// Migration settings which tune the migration behavior
	MigrationSetting map[string]*string `json:"migrationSetting,omitempty"`

	// Name of database
	Name *string `json:"name,omitempty"`

	// Schema name to be migrated
	SchemaName *string `json:"schemaName,omitempty"`

	// Source settings to tune source endpoint migration behavior
	SourceSetting map[string]*string `json:"sourceSetting,omitempty"`

	// Mapping of source to target tables
	TableMap map[string]*string `json:"tableMap,omitempty"`

	// Target database name
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`

	// Target settings to tune target endpoint migration behavior
	TargetSetting map[string]*string `json:"targetSetting,omitempty"`
}

// MigrateSQLServerSQLDbSyncTaskInput - Input for the task that migrates on-prem SQL Server databases to Azure SQL Database
// for online migrations
type MigrateSQLServerSQLDbSyncTaskInput struct {
	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSQLServerSQLDbSyncDatabaseInput `json:"selectedDatabases,omitempty"`

	// REQUIRED; Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`

	// Validation options
	ValidationOptions *MigrationValidationOptions `json:"validationOptions,omitempty"`
}

// MigrateSQLServerSQLDbSyncTaskOutputClassification provides polymorphic access to related types.
// Call the interface's GetMigrateSQLServerSQLDbSyncTaskOutput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *MigrateSQLServerSQLDbSyncTaskOutput, *MigrateSQLServerSQLDbSyncTaskOutputDatabaseError, *MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel,
// - *MigrateSQLServerSQLDbSyncTaskOutputError, *MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel, *MigrateSQLServerSQLDbSyncTaskOutputTableLevel
type MigrateSQLServerSQLDbSyncTaskOutputClassification interface {
	// GetMigrateSQLServerSQLDbSyncTaskOutput returns the MigrateSQLServerSQLDbSyncTaskOutput content of the underlying type.
	GetMigrateSQLServerSQLDbSyncTaskOutput() *MigrateSQLServerSQLDbSyncTaskOutput
}

// MigrateSQLServerSQLDbSyncTaskOutput - Output for the task that migrates on-prem SQL Server databases to Azure SQL Database
// for online migrations
type MigrateSQLServerSQLDbSyncTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLDbSyncTaskOutput implements the MigrateSQLServerSQLDbSyncTaskOutputClassification interface for type
// MigrateSQLServerSQLDbSyncTaskOutput.
func (m *MigrateSQLServerSQLDbSyncTaskOutput) GetMigrateSQLServerSQLDbSyncTaskOutput() *MigrateSQLServerSQLDbSyncTaskOutput {
	return m
}

type MigrateSQLServerSQLDbSyncTaskOutputDatabaseError struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// Error message
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// List of error events.
	Events []*SyncMigrationDatabaseErrorEvent `json:"events,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLDbSyncTaskOutput implements the MigrateSQLServerSQLDbSyncTaskOutputClassification interface for type
// MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (m *MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) GetMigrateSQLServerSQLDbSyncTaskOutput() *MigrateSQLServerSQLDbSyncTaskOutput {
	return &MigrateSQLServerSQLDbSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Number of applied changes
	AppliedChanges *int64 `json:"appliedChanges,omitempty" azure:"ro"`

	// READ-ONLY; Number of cdc deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of cdc inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of cdc updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty" azure:"ro"`

	// READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Number of tables completed in full load
	FullLoadCompletedTables *int64 `json:"fullLoadCompletedTables,omitempty" azure:"ro"`

	// READ-ONLY; Number of tables errored in full load
	FullLoadErroredTables *int64 `json:"fullLoadErroredTables,omitempty" azure:"ro"`

	// READ-ONLY; Number of tables loading in full load
	FullLoadLoadingTables *int64 `json:"fullLoadLoadingTables,omitempty" azure:"ro"`

	// READ-ONLY; Number of tables queued in full load
	FullLoadQueuedTables *int64 `json:"fullLoadQueuedTables,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Number of incoming changes
	IncomingChanges *int64 `json:"incomingChanges,omitempty" azure:"ro"`

	// READ-ONLY; Indicates if initial load (full load) has been completed
	InitializationCompleted *bool `json:"initializationCompleted,omitempty" azure:"ro"`

	// READ-ONLY; CDC apply latency
	Latency *int64 `json:"latency,omitempty" azure:"ro"`

	// READ-ONLY; Migration state that this database is in
	MigrationState *SyncDatabaseMigrationReportingState `json:"migrationState,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLDbSyncTaskOutput implements the MigrateSQLServerSQLDbSyncTaskOutputClassification interface for type
// MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (m *MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) GetMigrateSQLServerSQLDbSyncTaskOutput() *MigrateSQLServerSQLDbSyncTaskOutput {
	return &MigrateSQLServerSQLDbSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbSyncTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLDbSyncTaskOutput implements the MigrateSQLServerSQLDbSyncTaskOutputClassification interface for type
// MigrateSQLServerSQLDbSyncTaskOutputError.
func (m *MigrateSQLServerSQLDbSyncTaskOutputError) GetMigrateSQLServerSQLDbSyncTaskOutput() *MigrateSQLServerSQLDbSyncTaskOutput {
	return &MigrateSQLServerSQLDbSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Count of databases
	DatabaseCount *int32 `json:"databaseCount,omitempty" azure:"ro"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Source server name
	SourceServer *string `json:"sourceServer,omitempty" azure:"ro"`

	// READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Target server name
	TargetServer *string `json:"targetServer,omitempty" azure:"ro"`

	// READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLDbSyncTaskOutput implements the MigrateSQLServerSQLDbSyncTaskOutputClassification interface for type
// MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (m *MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) GetMigrateSQLServerSQLDbSyncTaskOutput() *MigrateSQLServerSQLDbSyncTaskOutput {
	return &MigrateSQLServerSQLDbSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbSyncTaskOutputTableLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Number of applied deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of applied inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of applied updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty" azure:"ro"`

	// READ-ONLY; Number of data errors occurred
	DataErrorsCounter *int64 `json:"dataErrorsCounter,omitempty" azure:"ro"`

	// READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; Full load end time
	FullLoadEndedOn *time.Time `json:"fullLoadEndedOn,omitempty" azure:"ro"`

	// READ-ONLY; Estimate to finish full load
	FullLoadEstFinishTime *time.Time `json:"fullLoadEstFinishTime,omitempty" azure:"ro"`

	// READ-ONLY; Full load start time
	FullLoadStartedOn *time.Time `json:"fullLoadStartedOn,omitempty" azure:"ro"`

	// READ-ONLY; Number of rows applied in full load
	FullLoadTotalRows *int64 `json:"fullLoadTotalRows,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Last modified time on target
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Current state of the table migration
	State *SyncTableMigrationState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Name of the table
	TableName *string `json:"tableName,omitempty" azure:"ro"`

	// READ-ONLY; Total number of applied changes
	TotalChangesApplied *int64 `json:"totalChangesApplied,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLDbSyncTaskOutput implements the MigrateSQLServerSQLDbSyncTaskOutputClassification interface for type
// MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (m *MigrateSQLServerSQLDbSyncTaskOutputTableLevel) GetMigrateSQLServerSQLDbSyncTaskOutput() *MigrateSQLServerSQLDbSyncTaskOutput {
	return &MigrateSQLServerSQLDbSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateSQLServerSQLDbSyncTaskProperties - Properties for the task that migrates on-prem SQL Server databases to Azure SQL
// Database for online migrations
type MigrateSQLServerSQLDbSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *MigrateSQLServerSQLDbSyncTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateSQLServerSQLDbSyncTaskOutputClassification `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateSQLServerSQLDbSyncTaskProperties.
func (m *MigrateSQLServerSQLDbSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   m.TaskType,
		Errors:     m.Errors,
		State:      m.State,
		Commands:   m.Commands,
		ClientData: m.ClientData,
	}
}

// MigrateSQLServerSQLDbTaskInput - Input for the task that migrates on-prem SQL Server databases to Azure SQL Database
type MigrateSQLServerSQLDbTaskInput struct {
	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSQLServerSQLDbDatabaseInput `json:"selectedDatabases,omitempty"`

	// REQUIRED; Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`

	// Options for enabling various post migration validations. Available options, 1.) Data Integrity Check: Performs a checksum
	// based comparison on source and target tables after the migration to ensure the
	// correctness of the data. 2.) Schema Validation: Performs a thorough schema comparison between the source and target tables
	// and provides a list of differences between the source and target database,
	// 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and
	// execute them and compares the execution time between the source and target
	// database.
	ValidationOptions *MigrationValidationOptions `json:"validationOptions,omitempty"`
}

// MigrateSQLServerSQLDbTaskOutputClassification provides polymorphic access to related types.
// Call the interface's GetMigrateSQLServerSQLDbTaskOutput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *MigrateSQLServerSQLDbTaskOutput, *MigrateSQLServerSQLDbTaskOutputDatabaseLevel, *MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult,
// - *MigrateSQLServerSQLDbTaskOutputError, *MigrateSQLServerSQLDbTaskOutputMigrationLevel, *MigrateSQLServerSQLDbTaskOutputTableLevel,
// - *MigrateSQLServerSQLDbTaskOutputValidationResult
type MigrateSQLServerSQLDbTaskOutputClassification interface {
	// GetMigrateSQLServerSQLDbTaskOutput returns the MigrateSQLServerSQLDbTaskOutput content of the underlying type.
	GetMigrateSQLServerSQLDbTaskOutput() *MigrateSQLServerSQLDbTaskOutput
}

// MigrateSQLServerSQLDbTaskOutput - Output for the task that migrates on-prem SQL Server databases to Azure SQL Database
type MigrateSQLServerSQLDbTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLDbTaskOutput implements the MigrateSQLServerSQLDbTaskOutputClassification interface for type MigrateSQLServerSQLDbTaskOutput.
func (m *MigrateSQLServerSQLDbTaskOutput) GetMigrateSQLServerSQLDbTaskOutput() *MigrateSQLServerSQLDbTaskOutput {
	return m
}

type MigrateSQLServerSQLDbTaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Name of the item
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Number of database/object errors.
	ErrorCount *int64 `json:"errorCount,omitempty" azure:"ro"`

	// READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty" azure:"ro"`

	// READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings []*ReportableException `json:"exceptionsAndWarnings,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Number of objects
	NumberOfObjects *int64 `json:"numberOfObjects,omitempty" azure:"ro"`

	// READ-ONLY; Number of successfully completed objects
	NumberOfObjectsCompleted *int64 `json:"numberOfObjectsCompleted,omitempty" azure:"ro"`

	// READ-ONLY; Summary of object results in the migration
	ObjectSummary *string `json:"objectSummary,omitempty" azure:"ro"`

	// READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty" azure:"ro"`

	// READ-ONLY; Migration stage that this database is in
	Stage *DatabaseMigrationStage `json:"stage,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current state of migration
	State *MigrationState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLDbTaskOutput implements the MigrateSQLServerSQLDbTaskOutputClassification interface for type MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (m *MigrateSQLServerSQLDbTaskOutputDatabaseLevel) GetMigrateSQLServerSQLDbTaskOutput() *MigrateSQLServerSQLDbTaskOutput {
	return &MigrateSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Provides data integrity validation result between the source and target tables that are migrated.
	DataIntegrityValidationResult *DataIntegrityValidationResult `json:"dataIntegrityValidationResult,omitempty" azure:"ro"`

	// READ-ONLY; Validation end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Migration Identifier
	MigrationID *string `json:"migrationId,omitempty" azure:"ro"`

	// READ-ONLY; Results of some of the query execution result between source and target database
	QueryAnalysisValidationResult *QueryAnalysisValidationResult `json:"queryAnalysisValidationResult,omitempty" azure:"ro"`

	// READ-ONLY; Provides schema comparison result between source and target database
	SchemaValidationResult *SchemaComparisonValidationResult `json:"schemaValidationResult,omitempty" azure:"ro"`

	// READ-ONLY; Name of the source database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty" azure:"ro"`

	// READ-ONLY; Validation start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current status of validation at the database level
	Status *ValidationStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Name of the target database
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLDbTaskOutput implements the MigrateSQLServerSQLDbTaskOutputClassification interface for type MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult.
func (m *MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult) GetMigrateSQLServerSQLDbTaskOutput() *MigrateSQLServerSQLDbTaskOutput {
	return &MigrateSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLDbTaskOutput implements the MigrateSQLServerSQLDbTaskOutputClassification interface for type MigrateSQLServerSQLDbTaskOutputError.
func (m *MigrateSQLServerSQLDbTaskOutputError) GetMigrateSQLServerSQLDbTaskOutput() *MigrateSQLServerSQLDbTaskOutput {
	return &MigrateSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// Migration Report Result, provides unique url for downloading your migration report.
	MigrationReportResult *MigrationReportResult `json:"migrationReportResult,omitempty"`

	// Migration Validation Results
	MigrationValidationResult *MigrationValidationResult `json:"migrationValidationResult,omitempty"`

	// READ-ONLY; Summary of database results in the migration
	DatabaseSummary *string `json:"databaseSummary,omitempty" azure:"ro"`

	// READ-ONLY; Selected databases as a map from database name to database id
	Databases *string `json:"databases,omitempty" azure:"ro"`

	// READ-ONLY; Duration of task execution in seconds.
	DurationInSeconds *int64 `json:"durationInSeconds,omitempty" azure:"ro"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings []*ReportableException `json:"exceptionsAndWarnings,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current status of migration
	Status *MigrationStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Migration status message
	StatusMessage *string `json:"statusMessage,omitempty" azure:"ro"`

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLDbTaskOutput implements the MigrateSQLServerSQLDbTaskOutputClassification interface for type MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (m *MigrateSQLServerSQLDbTaskOutputMigrationLevel) GetMigrateSQLServerSQLDbTaskOutput() *MigrateSQLServerSQLDbTaskOutput {
	return &MigrateSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbTaskOutputTableLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64 `json:"itemsCompletedCount,omitempty" azure:"ro"`

	// READ-ONLY; Number of items
	ItemsCount *int64 `json:"itemsCount,omitempty" azure:"ro"`

	// READ-ONLY; Name of the item
	ObjectName *string `json:"objectName,omitempty" azure:"ro"`

	// READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current state of migration
	State *MigrationState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLDbTaskOutput implements the MigrateSQLServerSQLDbTaskOutputClassification interface for type MigrateSQLServerSQLDbTaskOutputTableLevel.
func (m *MigrateSQLServerSQLDbTaskOutputTableLevel) GetMigrateSQLServerSQLDbTaskOutput() *MigrateSQLServerSQLDbTaskOutput {
	return &MigrateSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbTaskOutputValidationResult struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// Validation summary results for each database
	SummaryResults map[string]*MigrationValidationDatabaseSummaryResult `json:"summaryResults,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Migration Identifier
	MigrationID *string `json:"migrationId,omitempty" azure:"ro"`

	// READ-ONLY; Current status of validation at the migration level. Status from the database validation result status will
	// be aggregated here.
	Status *ValidationStatus `json:"status,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLDbTaskOutput implements the MigrateSQLServerSQLDbTaskOutputClassification interface for type MigrateSQLServerSQLDbTaskOutputValidationResult.
func (m *MigrateSQLServerSQLDbTaskOutputValidationResult) GetMigrateSQLServerSQLDbTaskOutput() *MigrateSQLServerSQLDbTaskOutput {
	return &MigrateSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateSQLServerSQLDbTaskProperties - Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database
type MigrateSQLServerSQLDbTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *MigrateSQLServerSQLDbTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateSQLServerSQLDbTaskOutputClassification `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateSQLServerSQLDbTaskProperties.
func (m *MigrateSQLServerSQLDbTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   m.TaskType,
		Errors:     m.Errors,
		State:      m.State,
		Commands:   m.Commands,
		ClientData: m.ClientData,
	}
}

// MigrateSQLServerSQLMIDatabaseInput - Database specific information for SQL to Azure SQL DB Managed Instance migration task
// inputs
type MigrateSQLServerSQLMIDatabaseInput struct {
	// REQUIRED; Name of the database
	Name *string `json:"name,omitempty"`

	// REQUIRED; Name of the database at destination
	RestoreDatabaseName *string `json:"restoreDatabaseName,omitempty"`

	// The list of backup files to be used in case of existing backups.
	BackupFilePaths []*string `json:"backupFilePaths,omitempty"`

	// Backup file share information for backing up this database.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
}

// MigrateSQLServerSQLMISyncTaskInput - Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance
// online scenario.
type MigrateSQLServerSQLMISyncTaskInput struct {
	// REQUIRED; Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database
	// Managed Instance and the Azure Storage Account
	AzureApp *AzureActiveDirectoryApp `json:"azureApp,omitempty"`

	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSQLServerSQLMIDatabaseInput `json:"selectedDatabases,omitempty"`

	// REQUIRED; Connection information for source SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Fully qualified resourceId of storage
	StorageResourceID *string `json:"storageResourceId,omitempty"`

	// REQUIRED; Connection information for Azure SQL Database Managed Instance
	TargetConnectionInfo *MiSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`

	// Backup file share information for all selected databases.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
}

// MigrateSQLServerSQLMISyncTaskOutputClassification provides polymorphic access to related types.
// Call the interface's GetMigrateSQLServerSQLMISyncTaskOutput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *MigrateSQLServerSQLMISyncTaskOutput, *MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel, *MigrateSQLServerSQLMISyncTaskOutputError,
// - *MigrateSQLServerSQLMISyncTaskOutputMigrationLevel
type MigrateSQLServerSQLMISyncTaskOutputClassification interface {
	// GetMigrateSQLServerSQLMISyncTaskOutput returns the MigrateSQLServerSQLMISyncTaskOutput content of the underlying type.
	GetMigrateSQLServerSQLMISyncTaskOutput() *MigrateSQLServerSQLMISyncTaskOutput
}

// MigrateSQLServerSQLMISyncTaskOutput - Output for task that migrates SQL Server databases to Azure SQL Database Managed
// Instance using Log Replay Service.
type MigrateSQLServerSQLMISyncTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLMISyncTaskOutput implements the MigrateSQLServerSQLMISyncTaskOutputClassification interface for type
// MigrateSQLServerSQLMISyncTaskOutput.
func (m *MigrateSQLServerSQLMISyncTaskOutput) GetMigrateSQLServerSQLMISyncTaskOutput() *MigrateSQLServerSQLMISyncTaskOutput {
	return m
}

type MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Backup sets that are currently active (Either being uploaded or getting restored)
	ActiveBackupSets []*BackupSetInfo `json:"activeBackupSets,omitempty" azure:"ro"`

	// READ-ONLY; Name of container created in the Azure Storage account where backups are copied to
	ContainerName *string `json:"containerName,omitempty" azure:"ro"`

	// READ-ONLY; Database migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; prefix string to use for querying errors for this database
	ErrorPrefix *string `json:"errorPrefix,omitempty" azure:"ro"`

	// READ-ONLY; Migration exceptions and warnings
	ExceptionsAndWarnings []*ReportableException `json:"exceptionsAndWarnings,omitempty" azure:"ro"`

	// READ-ONLY; Details of full backup set
	FullBackupSetInfo *BackupSetInfo `json:"fullBackupSetInfo,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Whether full backup has been applied to the target database or not
	IsFullBackupRestored *bool `json:"isFullBackupRestored,omitempty" azure:"ro"`

	// READ-ONLY; Last applied backup set information
	LastRestoredBackupSetInfo *BackupSetInfo `json:"lastRestoredBackupSetInfo,omitempty" azure:"ro"`

	// READ-ONLY; Current state of database
	MigrationState *DatabaseMigrationState `json:"migrationState,omitempty" azure:"ro"`

	// READ-ONLY; Name of the database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty" azure:"ro"`

	// READ-ONLY; Database migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLMISyncTaskOutput implements the MigrateSQLServerSQLMISyncTaskOutputClassification interface for type
// MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel.
func (m *MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel) GetMigrateSQLServerSQLMISyncTaskOutput() *MigrateSQLServerSQLMISyncTaskOutput {
	return &MigrateSQLServerSQLMISyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLMISyncTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLMISyncTaskOutput implements the MigrateSQLServerSQLMISyncTaskOutputClassification interface for type
// MigrateSQLServerSQLMISyncTaskOutputError.
func (m *MigrateSQLServerSQLMISyncTaskOutputError) GetMigrateSQLServerSQLMISyncTaskOutput() *MigrateSQLServerSQLMISyncTaskOutput {
	return &MigrateSQLServerSQLMISyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLMISyncTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Count of databases
	DatabaseCount *int32 `json:"databaseCount,omitempty" azure:"ro"`

	// READ-ONLY; Number of database level errors
	DatabaseErrorCount *int32 `json:"databaseErrorCount,omitempty" azure:"ro"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Source server name
	SourceServerName *string `json:"sourceServerName,omitempty" azure:"ro"`

	// READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current state of migration
	State *MigrationState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Target server name
	TargetServerName *string `json:"targetServerName,omitempty" azure:"ro"`

	// READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLMISyncTaskOutput implements the MigrateSQLServerSQLMISyncTaskOutputClassification interface for type
// MigrateSQLServerSQLMISyncTaskOutputMigrationLevel.
func (m *MigrateSQLServerSQLMISyncTaskOutputMigrationLevel) GetMigrateSQLServerSQLMISyncTaskOutput() *MigrateSQLServerSQLMISyncTaskOutput {
	return &MigrateSQLServerSQLMISyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateSQLServerSQLMISyncTaskProperties - Properties for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance sync scenario
type MigrateSQLServerSQLMISyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *MigrateSQLServerSQLMISyncTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateSQLServerSQLMISyncTaskOutputClassification `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateSQLServerSQLMISyncTaskProperties.
func (m *MigrateSQLServerSQLMISyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   m.TaskType,
		Errors:     m.Errors,
		State:      m.State,
		Commands:   m.Commands,
		ClientData: m.ClientData,
	}
}

// MigrateSQLServerSQLMITaskInput - Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance.
type MigrateSQLServerSQLMITaskInput struct {
	// REQUIRED; SAS URI of Azure Storage Account Container to be used for storing backup files.
	BackupBlobShare *BlobShare `json:"backupBlobShare,omitempty"`

	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSQLServerSQLMIDatabaseInput `json:"selectedDatabases,omitempty"`

	// REQUIRED; Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`

	// Azure Active Directory domain name in the format of 'contoso.com' for federated Azure AD or 'contoso.onmicrosoft.com' for
	// managed domain, required if and only if Windows logins are selected
	AADDomainName *string `json:"aadDomainName,omitempty"`

	// Backup file share information for all selected databases.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`

	// Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths
	// are required to be provided in selectedDatabases.
	BackupMode *BackupMode `json:"backupMode,omitempty"`

	// Agent Jobs to migrate.
	SelectedAgentJobs []*string `json:"selectedAgentJobs,omitempty"`

	// Logins to migrate.
	SelectedLogins []*string `json:"selectedLogins,omitempty"`
}

// MigrateSQLServerSQLMITaskOutputClassification provides polymorphic access to related types.
// Call the interface's GetMigrateSQLServerSQLMITaskOutput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *MigrateSQLServerSQLMITaskOutput, *MigrateSQLServerSQLMITaskOutputAgentJobLevel, *MigrateSQLServerSQLMITaskOutputDatabaseLevel,
// - *MigrateSQLServerSQLMITaskOutputError, *MigrateSQLServerSQLMITaskOutputLoginLevel, *MigrateSQLServerSQLMITaskOutputMigrationLevel
type MigrateSQLServerSQLMITaskOutputClassification interface {
	// GetMigrateSQLServerSQLMITaskOutput returns the MigrateSQLServerSQLMITaskOutput content of the underlying type.
	GetMigrateSQLServerSQLMITaskOutput() *MigrateSQLServerSQLMITaskOutput
}

// MigrateSQLServerSQLMITaskOutput - Output for task that migrates SQL Server databases to Azure SQL Database Managed Instance.
type MigrateSQLServerSQLMITaskOutput struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLMITaskOutput implements the MigrateSQLServerSQLMITaskOutputClassification interface for type MigrateSQLServerSQLMITaskOutput.
func (m *MigrateSQLServerSQLMITaskOutput) GetMigrateSQLServerSQLMITaskOutput() *MigrateSQLServerSQLMITaskOutput {
	return m
}

type MigrateSQLServerSQLMITaskOutputAgentJobLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Migration errors and warnings per job
	ExceptionsAndWarnings []*ReportableException `json:"exceptionsAndWarnings,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The state of the original Agent Job.
	IsEnabled *bool `json:"isEnabled,omitempty" azure:"ro"`

	// READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Agent Job name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current state of migration
	State *MigrationState `json:"state,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLMITaskOutput implements the MigrateSQLServerSQLMITaskOutputClassification interface for type MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (m *MigrateSQLServerSQLMITaskOutputAgentJobLevel) GetMigrateSQLServerSQLMITaskOutput() *MigrateSQLServerSQLMITaskOutput {
	return &MigrateSQLServerSQLMITaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLMITaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Migration exceptions and warnings
	ExceptionsAndWarnings []*ReportableException `json:"exceptionsAndWarnings,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Size of the database in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty" azure:"ro"`

	// READ-ONLY; Current stage of migration
	Stage *DatabaseMigrationStage `json:"stage,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current state of migration
	State *MigrationState `json:"state,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLMITaskOutput implements the MigrateSQLServerSQLMITaskOutputClassification interface for type MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (m *MigrateSQLServerSQLMITaskOutputDatabaseLevel) GetMigrateSQLServerSQLMITaskOutput() *MigrateSQLServerSQLMITaskOutput {
	return &MigrateSQLServerSQLMITaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLMITaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLMITaskOutput implements the MigrateSQLServerSQLMITaskOutputClassification interface for type MigrateSQLServerSQLMITaskOutputError.
func (m *MigrateSQLServerSQLMITaskOutputError) GetMigrateSQLServerSQLMITaskOutput() *MigrateSQLServerSQLMITaskOutput {
	return &MigrateSQLServerSQLMITaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLMITaskOutputLoginLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Login migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Login migration errors and warnings per login
	ExceptionsAndWarnings []*ReportableException `json:"exceptionsAndWarnings,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Login name.
	LoginName *string `json:"loginName,omitempty" azure:"ro"`

	// READ-ONLY; Login migration progress message
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Current stage of login
	Stage *LoginMigrationStage `json:"stage,omitempty" azure:"ro"`

	// READ-ONLY; Login migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current state of login
	State *MigrationState `json:"state,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLMITaskOutput implements the MigrateSQLServerSQLMITaskOutputClassification interface for type MigrateSQLServerSQLMITaskOutputLoginLevel.
func (m *MigrateSQLServerSQLMITaskOutputLoginLevel) GetMigrateSQLServerSQLMITaskOutput() *MigrateSQLServerSQLMITaskOutput {
	return &MigrateSQLServerSQLMITaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLMITaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Selected agent jobs as a map from name to id
	AgentJobs *string `json:"agentJobs,omitempty" azure:"ro"`

	// READ-ONLY; Selected databases as a map from database name to database id
	Databases *string `json:"databases,omitempty" azure:"ro"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings []*ReportableException `json:"exceptionsAndWarnings,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Selected logins as a map from name to id
	Logins *string `json:"logins,omitempty" azure:"ro"`

	// READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; List of orphaned users.
	OrphanedUsersInfo []*OrphanedUserInfo `json:"orphanedUsersInfo,omitempty" azure:"ro"`

	// READ-ONLY; Map of server role migration results.
	ServerRoleResults *string `json:"serverRoleResults,omitempty" azure:"ro"`

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current state of migration
	State *MigrationState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Current status of migration
	Status *MigrationStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty" azure:"ro"`
}

// GetMigrateSQLServerSQLMITaskOutput implements the MigrateSQLServerSQLMITaskOutputClassification interface for type MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (m *MigrateSQLServerSQLMITaskOutputMigrationLevel) GetMigrateSQLServerSQLMITaskOutput() *MigrateSQLServerSQLMITaskOutput {
	return &MigrateSQLServerSQLMITaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateSQLServerSQLMITaskProperties - Properties for task that migrates SQL Server databases to Azure SQL Database Managed
// Instance
type MigrateSQLServerSQLMITaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *MigrateSQLServerSQLMITaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateSQLServerSQLMITaskOutputClassification `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateSQLServerSQLMITaskProperties.
func (m *MigrateSQLServerSQLMITaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   m.TaskType,
		Errors:     m.Errors,
		State:      m.State,
		Commands:   m.Commands,
		ClientData: m.ClientData,
	}
}

// MigrateSchemaSQLServerSQLDbDatabaseInput - Database input for migrate schema Sql Server to Azure SQL Server scenario
type MigrateSchemaSQLServerSQLDbDatabaseInput struct {
	// Name of source database
	Name *string `json:"name,omitempty"`

	// Database schema migration settings
	SchemaSetting *SchemaMigrationSetting `json:"schemaSetting,omitempty"`

	// Name of target database
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
}

// MigrateSchemaSQLServerSQLDbTaskInput - Input for task that migrates Schema for SQL Server databases to Azure SQL databases
type MigrateSchemaSQLServerSQLDbTaskInput struct {
	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSchemaSQLServerSQLDbDatabaseInput `json:"selectedDatabases,omitempty"`

	// REQUIRED; Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// MigrateSchemaSQLServerSQLDbTaskOutputClassification provides polymorphic access to related types.
// Call the interface's GetMigrateSchemaSQLServerSQLDbTaskOutput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *MigrateSchemaSQLServerSQLDbTaskOutput, *MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel, *MigrateSchemaSQLServerSQLDbTaskOutputError,
// - *MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel, *MigrateSchemaSQLTaskOutputError
type MigrateSchemaSQLServerSQLDbTaskOutputClassification interface {
	// GetMigrateSchemaSQLServerSQLDbTaskOutput returns the MigrateSchemaSQLServerSQLDbTaskOutput content of the underlying type.
	GetMigrateSchemaSQLServerSQLDbTaskOutput() *MigrateSchemaSQLServerSQLDbTaskOutput
}

// MigrateSchemaSQLServerSQLDbTaskOutput - Output for the task that migrates Schema for SQL Server databases to Azure SQL
// databases
type MigrateSchemaSQLServerSQLDbTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateSchemaSQLServerSQLDbTaskOutput implements the MigrateSchemaSQLServerSQLDbTaskOutputClassification interface for
// type MigrateSchemaSQLServerSQLDbTaskOutput.
func (m *MigrateSchemaSQLServerSQLDbTaskOutput) GetMigrateSchemaSQLServerSQLDbTaskOutput() *MigrateSchemaSQLServerSQLDbTaskOutput {
	return m
}

type MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Prefix string to use for querying errors for this database
	DatabaseErrorResultPrefix *string `json:"databaseErrorResultPrefix,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Identifier for the file resource containing the schema of this database
	FileID *string `json:"fileId,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Number of failed operations for this database
	NumberOfFailedOperations *int64 `json:"numberOfFailedOperations,omitempty" azure:"ro"`

	// READ-ONLY; Number of successful operations for this database
	NumberOfSuccessfulOperations *int64 `json:"numberOfSuccessfulOperations,omitempty" azure:"ro"`

	// READ-ONLY; Prefix string to use for querying schema errors for this database
	SchemaErrorResultPrefix *string `json:"schemaErrorResultPrefix,omitempty" azure:"ro"`

	// READ-ONLY; Schema migration stage for this database
	Stage *SchemaMigrationStage `json:"stage,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; State of the schema migration for this database
	State *MigrationState `json:"state,omitempty" azure:"ro"`
}

// GetMigrateSchemaSQLServerSQLDbTaskOutput implements the MigrateSchemaSQLServerSQLDbTaskOutputClassification interface for
// type MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel.
func (m *MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel) GetMigrateSchemaSQLServerSQLDbTaskOutput() *MigrateSchemaSQLServerSQLDbTaskOutput {
	return &MigrateSchemaSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSchemaSQLServerSQLDbTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Schema command which failed
	CommandText *string `json:"commandText,omitempty" azure:"ro"`

	// READ-ONLY; Reason of failure
	ErrorText *string `json:"errorText,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateSchemaSQLServerSQLDbTaskOutput implements the MigrateSchemaSQLServerSQLDbTaskOutputClassification interface for
// type MigrateSchemaSQLServerSQLDbTaskOutputError.
func (m *MigrateSchemaSQLServerSQLDbTaskOutputError) GetMigrateSchemaSQLServerSQLDbTaskOutput() *MigrateSchemaSQLServerSQLDbTaskOutput {
	return &MigrateSchemaSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Overall state of the schema migration
	State *MigrationState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty" azure:"ro"`
}

// GetMigrateSchemaSQLServerSQLDbTaskOutput implements the MigrateSchemaSQLServerSQLDbTaskOutputClassification interface for
// type MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel.
func (m *MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel) GetMigrateSchemaSQLServerSQLDbTaskOutput() *MigrateSchemaSQLServerSQLDbTaskOutput {
	return &MigrateSchemaSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateSchemaSQLServerSQLDbTaskProperties - Properties for task that migrates Schema for SQL Server databases to Azure
// SQL databases
type MigrateSchemaSQLServerSQLDbTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *MigrateSchemaSQLServerSQLDbTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateSchemaSQLServerSQLDbTaskOutputClassification `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateSchemaSQLServerSQLDbTaskProperties.
func (m *MigrateSchemaSQLServerSQLDbTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   m.TaskType,
		Errors:     m.Errors,
		State:      m.State,
		Commands:   m.Commands,
		ClientData: m.ClientData,
	}
}

type MigrateSchemaSQLTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateSchemaSQLServerSQLDbTaskOutput implements the MigrateSchemaSQLServerSQLDbTaskOutputClassification interface for
// type MigrateSchemaSQLTaskOutputError.
func (m *MigrateSchemaSQLTaskOutputError) GetMigrateSchemaSQLServerSQLDbTaskOutput() *MigrateSchemaSQLServerSQLDbTaskOutput {
	return &MigrateSchemaSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateSsisTaskInput - Input for task that migrates SSIS packages from SQL Server to Azure SQL Database Managed Instance.
type MigrateSsisTaskInput struct {
	// REQUIRED; Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; SSIS package migration information.
	SsisMigrationInfo *SsisMigrationInfo `json:"ssisMigrationInfo,omitempty"`

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// MigrateSsisTaskOutputClassification provides polymorphic access to related types.
// Call the interface's GetMigrateSsisTaskOutput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *MigrateSsisTaskOutput, *MigrateSsisTaskOutputMigrationLevel, *MigrateSsisTaskOutputProjectLevel
type MigrateSsisTaskOutputClassification interface {
	// GetMigrateSsisTaskOutput returns the MigrateSsisTaskOutput content of the underlying type.
	GetMigrateSsisTaskOutput() *MigrateSsisTaskOutput
}

// MigrateSsisTaskOutput - Output for task that migrates SSIS packages from SQL Server to Azure SQL Database Managed Instance.
type MigrateSsisTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetMigrateSsisTaskOutput implements the MigrateSsisTaskOutputClassification interface for type MigrateSsisTaskOutput.
func (m *MigrateSsisTaskOutput) GetMigrateSsisTaskOutput() *MigrateSsisTaskOutput { return m }

type MigrateSsisTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings []*ReportableException `json:"exceptionsAndWarnings,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty" azure:"ro"`

	// READ-ONLY; Stage of SSIS migration.
	Stage *SsisMigrationStage `json:"stage,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current status of migration
	Status *MigrationStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty" azure:"ro"`

	// READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty" azure:"ro"`
}

// GetMigrateSsisTaskOutput implements the MigrateSsisTaskOutputClassification interface for type MigrateSsisTaskOutputMigrationLevel.
func (m *MigrateSsisTaskOutputMigrationLevel) GetMigrateSsisTaskOutput() *MigrateSsisTaskOutput {
	return &MigrateSsisTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSsisTaskOutputProjectLevel struct {
	// REQUIRED; Result type
	ResultType *string `json:"resultType,omitempty"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Migration exceptions and warnings
	ExceptionsAndWarnings []*ReportableException `json:"exceptionsAndWarnings,omitempty" azure:"ro"`

	// READ-ONLY; Name of the folder
	FolderName *string `json:"folderName,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Name of the project
	ProjectName *string `json:"projectName,omitempty" azure:"ro"`

	// READ-ONLY; Stage of SSIS migration.
	Stage *SsisMigrationStage `json:"stage,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current state of migration
	State *MigrationState `json:"state,omitempty" azure:"ro"`
}

// GetMigrateSsisTaskOutput implements the MigrateSsisTaskOutputClassification interface for type MigrateSsisTaskOutputProjectLevel.
func (m *MigrateSsisTaskOutputProjectLevel) GetMigrateSsisTaskOutput() *MigrateSsisTaskOutput {
	return &MigrateSsisTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateSsisTaskProperties - Properties for task that migrates SSIS packages from SQL Server databases to Azure SQL Database
// Managed Instance.
type MigrateSsisTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *MigrateSsisTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateSsisTaskOutputClassification `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateSsisTaskProperties.
func (m *MigrateSsisTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   m.TaskType,
		Errors:     m.Errors,
		State:      m.State,
		Commands:   m.Commands,
		ClientData: m.ClientData,
	}
}

// MigrateSyncCompleteCommandInput - Input for command that completes sync migration for a database.
type MigrateSyncCompleteCommandInput struct {
	// REQUIRED; Name of database
	DatabaseName *string `json:"databaseName,omitempty"`

	// Time stamp to complete
	CommitTimeStamp *time.Time `json:"commitTimeStamp,omitempty"`
}

// MigrateSyncCompleteCommandOutput - Output for command that completes sync migration for a database.
type MigrateSyncCompleteCommandOutput struct {
	// READ-ONLY; List of errors that happened during the command execution
	Errors []*ReportableException `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

// MigrateSyncCompleteCommandProperties - Properties for the command that completes sync migration for a database.
type MigrateSyncCompleteCommandProperties struct {
	// REQUIRED; Command type.
	CommandType *string `json:"commandType,omitempty"`

	// Command input
	Input *MigrateSyncCompleteCommandInput `json:"input,omitempty"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Command output. This is ignored if submitted.
	Output *MigrateSyncCompleteCommandOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the command. This is ignored if submitted.
	State *CommandState `json:"state,omitempty" azure:"ro"`
}

// GetCommandProperties implements the CommandPropertiesClassification interface for type MigrateSyncCompleteCommandProperties.
func (m *MigrateSyncCompleteCommandProperties) GetCommandProperties() *CommandProperties {
	return &CommandProperties{
		CommandType: m.CommandType,
		Errors:      m.Errors,
		State:       m.State,
	}
}

// MigrationEligibilityInfo - Information about migration eligibility of a server object
type MigrationEligibilityInfo struct {
	// READ-ONLY; Whether object is eligible for migration or not.
	IsEligibleForMigration *bool `json:"isEligibleForMigration,omitempty" azure:"ro"`

	// READ-ONLY; Information about eligibility failure for the server object.
	ValidationMessages []*string `json:"validationMessages,omitempty" azure:"ro"`
}

// MigrationReportResult - Migration validation report result, contains the url for downloading the generated report.
type MigrationReportResult struct {
	// Migration validation result identifier
	ID *string `json:"id,omitempty"`

	// The url of the report.
	ReportURL *string `json:"reportUrl,omitempty"`
}

// MigrationTableMetadata - Metadata for tables selected in migration project
type MigrationTableMetadata struct {
	// READ-ONLY; Source table name
	SourceTableName *string `json:"sourceTableName,omitempty" azure:"ro"`

	// READ-ONLY; Target table name
	TargetTableName *string `json:"targetTableName,omitempty" azure:"ro"`
}

// MigrationValidationDatabaseLevelResult - Database level validation results
type MigrationValidationDatabaseLevelResult struct {
	// READ-ONLY; Provides data integrity validation result between the source and target tables that are migrated.
	DataIntegrityValidationResult *DataIntegrityValidationResult `json:"dataIntegrityValidationResult,omitempty" azure:"ro"`

	// READ-ONLY; Validation end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Migration Identifier
	MigrationID *string `json:"migrationId,omitempty" azure:"ro"`

	// READ-ONLY; Results of some of the query execution result between source and target database
	QueryAnalysisValidationResult *QueryAnalysisValidationResult `json:"queryAnalysisValidationResult,omitempty" azure:"ro"`

	// READ-ONLY; Provides schema comparison result between source and target database
	SchemaValidationResult *SchemaComparisonValidationResult `json:"schemaValidationResult,omitempty" azure:"ro"`

	// READ-ONLY; Name of the source database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty" azure:"ro"`

	// READ-ONLY; Validation start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current status of validation at the database level
	Status *ValidationStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Name of the target database
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty" azure:"ro"`
}

// MigrationValidationDatabaseSummaryResult - Migration Validation Database level summary result
type MigrationValidationDatabaseSummaryResult struct {
	// READ-ONLY; Validation end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Migration Identifier
	MigrationID *string `json:"migrationId,omitempty" azure:"ro"`

	// READ-ONLY; Name of the source database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty" azure:"ro"`

	// READ-ONLY; Validation start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current status of validation at the database level
	Status *ValidationStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Name of the target database
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty" azure:"ro"`
}

// MigrationValidationOptions - Types of validations to run after the migration
type MigrationValidationOptions struct {
	// Allows to perform a checksum based data integrity validation between source and target for the selected database / tables
	// .
	EnableDataIntegrityValidation *bool `json:"enableDataIntegrityValidation,omitempty"`

	// Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them
	// in the target. The result will have execution statistics for executions in
	// source and target databases for the extracted queries.
	EnableQueryAnalysisValidation *bool `json:"enableQueryAnalysisValidation,omitempty"`

	// Allows to compare the schema information between source and target.
	EnableSchemaValidation *bool `json:"enableSchemaValidation,omitempty"`
}

// MigrationValidationResult - Migration Validation Result
type MigrationValidationResult struct {
	// Validation summary results for each database
	SummaryResults map[string]*MigrationValidationDatabaseSummaryResult `json:"summaryResults,omitempty"`

	// READ-ONLY; Migration validation result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Migration Identifier
	MigrationID *string `json:"migrationId,omitempty" azure:"ro"`

	// READ-ONLY; Current status of validation at the migration level. Status from the database validation result status will
	// be aggregated here.
	Status *ValidationStatus `json:"status,omitempty" azure:"ro"`
}

// MongoDbCancelCommand - Properties for the command that cancels a migration in whole or in part
type MongoDbCancelCommand struct {
	// REQUIRED; Command type.
	CommandType *string `json:"commandType,omitempty"`

	// Command input
	Input *MongoDbCommandInput `json:"input,omitempty"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; The state of the command. This is ignored if submitted.
	State *CommandState `json:"state,omitempty" azure:"ro"`
}

// GetCommandProperties implements the CommandPropertiesClassification interface for type MongoDbCancelCommand.
func (m *MongoDbCancelCommand) GetCommandProperties() *CommandProperties {
	return &CommandProperties{
		CommandType: m.CommandType,
		Errors:      m.Errors,
		State:       m.State,
	}
}

// MongoDbClusterInfo - Describes a MongoDB data source
type MongoDbClusterInfo struct {
	// REQUIRED; A list of non-system databases in the cluster
	Databases []*MongoDbDatabaseInfo `json:"databases,omitempty"`

	// REQUIRED; Whether the cluster supports sharded collections
	SupportsSharding *bool `json:"supportsSharding,omitempty"`

	// REQUIRED; The type of data source
	Type *MongoDbClusterType `json:"type,omitempty"`

	// REQUIRED; The version of the data source in the form x.y.z (e.g. 3.6.7). Not used if Type is BlobContainer.
	Version *string `json:"version,omitempty"`
}

// MongoDbCollectionInfo - Describes a supported collection within a MongoDB database
type MongoDbCollectionInfo struct {
	// REQUIRED; The average document size, or -1 if the average size is unknown
	AverageDocumentSize *int64 `json:"averageDocumentSize,omitempty"`

	// REQUIRED; The estimated total data size, in bytes, or -1 if the size is unknown.
	DataSize *int64 `json:"dataSize,omitempty"`

	// REQUIRED; The name of the database containing the collection
	DatabaseName *string `json:"databaseName,omitempty"`

	// REQUIRED; The estimated total number of documents, or -1 if the document count is unknown
	DocumentCount *int64 `json:"documentCount,omitempty"`

	// REQUIRED; Whether the collection is a capped collection (i.e. whether it has a fixed size and acts like a circular buffer)
	IsCapped *bool `json:"isCapped,omitempty"`

	// REQUIRED; Whether the collection is system collection
	IsSystemCollection *bool `json:"isSystemCollection,omitempty"`

	// REQUIRED; Whether the collection is a view of another collection
	IsView *bool `json:"isView,omitempty"`

	// REQUIRED; The unqualified name of the database or collection
	Name *string `json:"name,omitempty"`

	// REQUIRED; The qualified name of the database or collection. For a collection, this is the database-qualified name.
	QualifiedName *string `json:"qualifiedName,omitempty"`

	// REQUIRED; Whether the database has sharding enabled. Note that the migration task will enable sharding on the target if
	// necessary.
	SupportsSharding *bool `json:"supportsSharding,omitempty"`

	// The shard key on the collection, or null if the collection is not sharded
	ShardKey *MongoDbShardKeyInfo `json:"shardKey,omitempty"`

	// The name of the collection that this is a view of, if IsView is true
	ViewOf *string `json:"viewOf,omitempty"`
}

// MongoDbCollectionProgress - Describes the progress of a collection
type MongoDbCollectionProgress struct {
	// REQUIRED; The number of document bytes copied during the Copying stage
	BytesCopied *int64 `json:"bytesCopied,omitempty"`

	// REQUIRED; The number of documents copied during the Copying stage
	DocumentsCopied *int64 `json:"documentsCopied,omitempty"`

	// REQUIRED; The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format)
	ElapsedTime *string `json:"elapsedTime,omitempty"`

	// REQUIRED; The errors and warnings that have occurred for the current object. The keys are the error codes.
	Errors map[string]*MongoDbError `json:"errors,omitempty"`

	// REQUIRED; The number of oplog events awaiting replay
	EventsPending *int64 `json:"eventsPending,omitempty"`

	// REQUIRED; The number of oplog events replayed so far
	EventsReplayed *int64 `json:"eventsReplayed,omitempty"`

	// REQUIRED; The type of progress object
	ResultType *MongoDbProgressResultType `json:"resultType,omitempty"`

	// REQUIRED
	State *MongoDbMigrationState `json:"state,omitempty"`

	// REQUIRED; The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size
	// was unknown
	TotalBytes *int64 `json:"totalBytes,omitempty"`

	// REQUIRED; The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was
	// unknown
	TotalDocuments *int64 `json:"totalDocuments,omitempty"`

	// The timestamp of the last oplog event received, or null if no oplog event has been received yet
	LastEventTime *time.Time `json:"lastEventTime,omitempty"`

	// The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet
	LastReplayTime *time.Time `json:"lastReplayTime,omitempty"`

	// The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the
	// database name. For the overall migration, this is null.
	Name *string `json:"name,omitempty"`

	// The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this
	// is the database name. For the overall migration, this is null.
	QualifiedName *string `json:"qualifiedName,omitempty"`
}

// GetMongoDbProgress implements the MongoDbProgressClassification interface for type MongoDbCollectionProgress.
func (m *MongoDbCollectionProgress) GetMongoDbProgress() *MongoDbProgress {
	return &MongoDbProgress{
		BytesCopied:     m.BytesCopied,
		DocumentsCopied: m.DocumentsCopied,
		ElapsedTime:     m.ElapsedTime,
		Errors:          m.Errors,
		EventsPending:   m.EventsPending,
		EventsReplayed:  m.EventsReplayed,
		LastEventTime:   m.LastEventTime,
		LastReplayTime:  m.LastReplayTime,
		Name:            m.Name,
		QualifiedName:   m.QualifiedName,
		ResultType:      m.ResultType,
		State:           m.State,
		TotalBytes:      m.TotalBytes,
		TotalDocuments:  m.TotalDocuments,
	}
}

// MongoDbCollectionSettings - Describes how an individual MongoDB collection should be migrated
type MongoDbCollectionSettings struct {
	// Whether the migrator is allowed to drop the target collection in the course of performing a migration. The default is true.
	CanDelete *bool `json:"canDelete,omitempty"`

	// Describes a MongoDB shard key
	ShardKey *MongoDbShardKeySetting `json:"shardKey,omitempty"`

	// The RUs that should be configured on a CosmosDB target, or null to use the default. This has no effect on non-CosmosDB
	// targets.
	TargetRUs *int32 `json:"targetRUs,omitempty"`
}

// MongoDbCommandInput - Describes the input to the 'cancel' and 'restart' MongoDB migration commands
type MongoDbCommandInput struct {
	// The qualified name of a database or collection to act upon, or null to act upon the entire migration
	ObjectName *string `json:"objectName,omitempty"`
}

// MongoDbConnectionInfo - Describes a connection to a MongoDB data source
type MongoDbConnectionInfo struct {
	// REQUIRED; A MongoDB connection string or blob container URL. The user name and password can be specified here or in the
	// userName and password properties
	ConnectionString *string `json:"connectionString,omitempty"`

	// REQUIRED; Type of connection info
	Type *string `json:"type,omitempty"`

	// Password credential.
	Password *string `json:"password,omitempty"`

	// User name
	UserName *string `json:"userName,omitempty"`
}

// GetConnectionInfo implements the ConnectionInfoClassification interface for type MongoDbConnectionInfo.
func (m *MongoDbConnectionInfo) GetConnectionInfo() *ConnectionInfo {
	return &ConnectionInfo{
		Type:     m.Type,
		UserName: m.UserName,
		Password: m.Password,
	}
}

// MongoDbDatabaseInfo - Describes a database within a MongoDB data source
type MongoDbDatabaseInfo struct {
	// REQUIRED; The average document size, or -1 if the average size is unknown
	AverageDocumentSize *int64 `json:"averageDocumentSize,omitempty"`

	// REQUIRED; A list of supported collections in a MongoDB database
	Collections []*MongoDbCollectionInfo `json:"collections,omitempty"`

	// REQUIRED; The estimated total data size, in bytes, or -1 if the size is unknown.
	DataSize *int64 `json:"dataSize,omitempty"`

	// REQUIRED; The estimated total number of documents, or -1 if the document count is unknown
	DocumentCount *int64 `json:"documentCount,omitempty"`

	// REQUIRED; The unqualified name of the database or collection
	Name *string `json:"name,omitempty"`

	// REQUIRED; The qualified name of the database or collection. For a collection, this is the database-qualified name.
	QualifiedName *string `json:"qualifiedName,omitempty"`

	// REQUIRED; Whether the database has sharding enabled. Note that the migration task will enable sharding on the target if
	// necessary.
	SupportsSharding *bool `json:"supportsSharding,omitempty"`
}

// MongoDbDatabaseProgress - Describes the progress of a database
type MongoDbDatabaseProgress struct {
	// REQUIRED; The number of document bytes copied during the Copying stage
	BytesCopied *int64 `json:"bytesCopied,omitempty"`

	// REQUIRED; The number of documents copied during the Copying stage
	DocumentsCopied *int64 `json:"documentsCopied,omitempty"`

	// REQUIRED; The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format)
	ElapsedTime *string `json:"elapsedTime,omitempty"`

	// REQUIRED; The errors and warnings that have occurred for the current object. The keys are the error codes.
	Errors map[string]*MongoDbError `json:"errors,omitempty"`

	// REQUIRED; The number of oplog events awaiting replay
	EventsPending *int64 `json:"eventsPending,omitempty"`

	// REQUIRED; The number of oplog events replayed so far
	EventsReplayed *int64 `json:"eventsReplayed,omitempty"`

	// REQUIRED; The type of progress object
	ResultType *MongoDbProgressResultType `json:"resultType,omitempty"`

	// REQUIRED
	State *MongoDbMigrationState `json:"state,omitempty"`

	// REQUIRED; The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size
	// was unknown
	TotalBytes *int64 `json:"totalBytes,omitempty"`

	// REQUIRED; The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was
	// unknown
	TotalDocuments *int64 `json:"totalDocuments,omitempty"`

	// The progress of the collections in the database. The keys are the unqualified names of the collections
	Collections map[string]*MongoDbCollectionProgress `json:"collections,omitempty"`

	// The timestamp of the last oplog event received, or null if no oplog event has been received yet
	LastEventTime *time.Time `json:"lastEventTime,omitempty"`

	// The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet
	LastReplayTime *time.Time `json:"lastReplayTime,omitempty"`

	// The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the
	// database name. For the overall migration, this is null.
	Name *string `json:"name,omitempty"`

	// The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this
	// is the database name. For the overall migration, this is null.
	QualifiedName *string `json:"qualifiedName,omitempty"`
}

// GetMongoDbProgress implements the MongoDbProgressClassification interface for type MongoDbDatabaseProgress.
func (m *MongoDbDatabaseProgress) GetMongoDbProgress() *MongoDbProgress {
	return &MongoDbProgress{
		BytesCopied:     m.BytesCopied,
		DocumentsCopied: m.DocumentsCopied,
		ElapsedTime:     m.ElapsedTime,
		Errors:          m.Errors,
		EventsPending:   m.EventsPending,
		EventsReplayed:  m.EventsReplayed,
		LastEventTime:   m.LastEventTime,
		LastReplayTime:  m.LastReplayTime,
		Name:            m.Name,
		QualifiedName:   m.QualifiedName,
		ResultType:      m.ResultType,
		State:           m.State,
		TotalBytes:      m.TotalBytes,
		TotalDocuments:  m.TotalDocuments,
	}
}

// MongoDbDatabaseSettings - Describes how an individual MongoDB database should be migrated
type MongoDbDatabaseSettings struct {
	// REQUIRED; The collections on the source database to migrate to the target. The keys are the unqualified names of the collections.
	Collections map[string]*MongoDbCollectionSettings `json:"collections,omitempty"`

	// The RUs that should be configured on a CosmosDB target, or null to use the default, or 0 if throughput should not be provisioned
	// for the database. This has no effect on non-CosmosDB targets.
	TargetRUs *int32 `json:"targetRUs,omitempty"`
}

// MongoDbError - Describes an error or warning that occurred during a MongoDB migration
type MongoDbError struct {
	// The non-localized, machine-readable code that describes the error or warning
	Code *string `json:"code,omitempty"`

	// The number of times the error or warning has occurred
	Count *int32 `json:"count,omitempty"`

	// The localized, human-readable message that describes the error or warning
	Message *string `json:"message,omitempty"`

	// The type of error or warning
	Type *MongoDbErrorType `json:"type,omitempty"`
}

// MongoDbFinishCommand - Properties for the command that finishes a migration in whole or in part
type MongoDbFinishCommand struct {
	// REQUIRED; Command type.
	CommandType *string `json:"commandType,omitempty"`

	// Command input
	Input *MongoDbFinishCommandInput `json:"input,omitempty"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; The state of the command. This is ignored if submitted.
	State *CommandState `json:"state,omitempty" azure:"ro"`
}

// GetCommandProperties implements the CommandPropertiesClassification interface for type MongoDbFinishCommand.
func (m *MongoDbFinishCommand) GetCommandProperties() *CommandProperties {
	return &CommandProperties{
		CommandType: m.CommandType,
		Errors:      m.Errors,
		State:       m.State,
	}
}

// MongoDbFinishCommandInput - Describes the input to the 'finish' MongoDB migration command
type MongoDbFinishCommandInput struct {
	// REQUIRED; If true, replication for the affected objects will be stopped immediately. If false, the migrator will finish
	// replaying queued events before finishing the replication.
	Immediate *bool `json:"immediate,omitempty"`

	// The qualified name of a database or collection to act upon, or null to act upon the entire migration
	ObjectName *string `json:"objectName,omitempty"`
}

// MongoDbMigrationProgress - Describes the progress of the overall migration
type MongoDbMigrationProgress struct {
	// REQUIRED; The number of document bytes copied during the Copying stage
	BytesCopied *int64 `json:"bytesCopied,omitempty"`

	// REQUIRED; The number of documents copied during the Copying stage
	DocumentsCopied *int64 `json:"documentsCopied,omitempty"`

	// REQUIRED; The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format)
	ElapsedTime *string `json:"elapsedTime,omitempty"`

	// REQUIRED; The errors and warnings that have occurred for the current object. The keys are the error codes.
	Errors map[string]*MongoDbError `json:"errors,omitempty"`

	// REQUIRED; The number of oplog events awaiting replay
	EventsPending *int64 `json:"eventsPending,omitempty"`

	// REQUIRED; The number of oplog events replayed so far
	EventsReplayed *int64 `json:"eventsReplayed,omitempty"`

	// REQUIRED; The type of progress object
	ResultType *MongoDbProgressResultType `json:"resultType,omitempty"`

	// REQUIRED
	State *MongoDbMigrationState `json:"state,omitempty"`

	// REQUIRED; The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size
	// was unknown
	TotalBytes *int64 `json:"totalBytes,omitempty"`

	// REQUIRED; The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was
	// unknown
	TotalDocuments *int64 `json:"totalDocuments,omitempty"`

	// The progress of the databases in the migration. The keys are the names of the databases
	Databases map[string]*MongoDbDatabaseProgress `json:"databases,omitempty"`

	// The timestamp of the last oplog event received, or null if no oplog event has been received yet
	LastEventTime *time.Time `json:"lastEventTime,omitempty"`

	// The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet
	LastReplayTime *time.Time `json:"lastReplayTime,omitempty"`

	// The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the
	// database name. For the overall migration, this is null.
	Name *string `json:"name,omitempty"`

	// The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this
	// is the database name. For the overall migration, this is null.
	QualifiedName *string `json:"qualifiedName,omitempty"`
}

// GetMongoDbProgress implements the MongoDbProgressClassification interface for type MongoDbMigrationProgress.
func (m *MongoDbMigrationProgress) GetMongoDbProgress() *MongoDbProgress {
	return &MongoDbProgress{
		BytesCopied:     m.BytesCopied,
		DocumentsCopied: m.DocumentsCopied,
		ElapsedTime:     m.ElapsedTime,
		Errors:          m.Errors,
		EventsPending:   m.EventsPending,
		EventsReplayed:  m.EventsReplayed,
		LastEventTime:   m.LastEventTime,
		LastReplayTime:  m.LastReplayTime,
		Name:            m.Name,
		QualifiedName:   m.QualifiedName,
		ResultType:      m.ResultType,
		State:           m.State,
		TotalBytes:      m.TotalBytes,
		TotalDocuments:  m.TotalDocuments,
	}
}

// MongoDbMigrationSettings - Describes how a MongoDB data migration should be performed
type MongoDbMigrationSettings struct {
	// REQUIRED; The databases on the source cluster to migrate to the target. The keys are the names of the databases.
	Databases map[string]*MongoDbDatabaseSettings `json:"databases,omitempty"`

	// REQUIRED; Settings used to connect to the source cluster
	Source *MongoDbConnectionInfo `json:"source,omitempty"`

	// REQUIRED; Settings used to connect to the target cluster
	Target *MongoDbConnectionInfo `json:"target,omitempty"`

	// The RU limit on a CosmosDB target that collections will be temporarily increased to (if lower) during the initial copy
	// of a migration, from 10,000 to 1,000,000, or 0 to use the default boost (which is
	// generally the maximum), or null to not boost the RUs. This setting has no effect on non-CosmosDB targets.
	BoostRUs *int32 `json:"boostRUs,omitempty"`

	// Describes how changes will be replicated from the source to the target. The default is OneTime.
	Replication *MongoDbReplication `json:"replication,omitempty"`

	// Settings used to limit the resource usage of the migration
	Throttling *MongoDbThrottlingSettings `json:"throttling,omitempty"`
}

// MongoDbObjectInfo - Describes a database or collection within a MongoDB data source
type MongoDbObjectInfo struct {
	// REQUIRED; The average document size, or -1 if the average size is unknown
	AverageDocumentSize *int64 `json:"averageDocumentSize,omitempty"`

	// REQUIRED; The estimated total data size, in bytes, or -1 if the size is unknown.
	DataSize *int64 `json:"dataSize,omitempty"`

	// REQUIRED; The estimated total number of documents, or -1 if the document count is unknown
	DocumentCount *int64 `json:"documentCount,omitempty"`

	// REQUIRED; The unqualified name of the database or collection
	Name *string `json:"name,omitempty"`

	// REQUIRED; The qualified name of the database or collection. For a collection, this is the database-qualified name.
	QualifiedName *string `json:"qualifiedName,omitempty"`
}

// MongoDbProgressClassification provides polymorphic access to related types.
// Call the interface's GetMongoDbProgress() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *MongoDbCollectionProgress, *MongoDbDatabaseProgress, *MongoDbMigrationProgress, *MongoDbProgress
type MongoDbProgressClassification interface {
	// GetMongoDbProgress returns the MongoDbProgress content of the underlying type.
	GetMongoDbProgress() *MongoDbProgress
}

// MongoDbProgress - Base class for MongoDB migration outputs
type MongoDbProgress struct {
	// REQUIRED; The number of document bytes copied during the Copying stage
	BytesCopied *int64 `json:"bytesCopied,omitempty"`

	// REQUIRED; The number of documents copied during the Copying stage
	DocumentsCopied *int64 `json:"documentsCopied,omitempty"`

	// REQUIRED; The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format)
	ElapsedTime *string `json:"elapsedTime,omitempty"`

	// REQUIRED; The errors and warnings that have occurred for the current object. The keys are the error codes.
	Errors map[string]*MongoDbError `json:"errors,omitempty"`

	// REQUIRED; The number of oplog events awaiting replay
	EventsPending *int64 `json:"eventsPending,omitempty"`

	// REQUIRED; The number of oplog events replayed so far
	EventsReplayed *int64 `json:"eventsReplayed,omitempty"`

	// REQUIRED; The type of progress object
	ResultType *MongoDbProgressResultType `json:"resultType,omitempty"`

	// REQUIRED
	State *MongoDbMigrationState `json:"state,omitempty"`

	// REQUIRED; The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size
	// was unknown
	TotalBytes *int64 `json:"totalBytes,omitempty"`

	// REQUIRED; The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was
	// unknown
	TotalDocuments *int64 `json:"totalDocuments,omitempty"`

	// The timestamp of the last oplog event received, or null if no oplog event has been received yet
	LastEventTime *time.Time `json:"lastEventTime,omitempty"`

	// The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet
	LastReplayTime *time.Time `json:"lastReplayTime,omitempty"`

	// The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the
	// database name. For the overall migration, this is null.
	Name *string `json:"name,omitempty"`

	// The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this
	// is the database name. For the overall migration, this is null.
	QualifiedName *string `json:"qualifiedName,omitempty"`
}

// GetMongoDbProgress implements the MongoDbProgressClassification interface for type MongoDbProgress.
func (m *MongoDbProgress) GetMongoDbProgress() *MongoDbProgress { return m }

// MongoDbRestartCommand - Properties for the command that restarts a migration in whole or in part
type MongoDbRestartCommand struct {
	// REQUIRED; Command type.
	CommandType *string `json:"commandType,omitempty"`

	// Command input
	Input *MongoDbCommandInput `json:"input,omitempty"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; The state of the command. This is ignored if submitted.
	State *CommandState `json:"state,omitempty" azure:"ro"`
}

// GetCommandProperties implements the CommandPropertiesClassification interface for type MongoDbRestartCommand.
func (m *MongoDbRestartCommand) GetCommandProperties() *CommandProperties {
	return &CommandProperties{
		CommandType: m.CommandType,
		Errors:      m.Errors,
		State:       m.State,
	}
}

// MongoDbShardKeyField - Describes a field reference within a MongoDB shard key
type MongoDbShardKeyField struct {
	// REQUIRED; The name of the field
	Name *string `json:"name,omitempty"`

	// REQUIRED; The field ordering
	Order *MongoDbShardKeyOrder `json:"order,omitempty"`
}

// MongoDbShardKeyInfo - Describes a MongoDB shard key
type MongoDbShardKeyInfo struct {
	// REQUIRED; The fields within the shard key
	Fields []*MongoDbShardKeyField `json:"fields,omitempty"`

	// REQUIRED; Whether the shard key is unique
	IsUnique *bool `json:"isUnique,omitempty"`
}

// MongoDbShardKeySetting - Describes a MongoDB shard key
type MongoDbShardKeySetting struct {
	// REQUIRED; The fields within the shard key
	Fields []*MongoDbShardKeyField `json:"fields,omitempty"`

	// REQUIRED; Whether the shard key is unique
	IsUnique *bool `json:"isUnique,omitempty"`
}

// MongoDbThrottlingSettings - Specifies resource limits for the migration
type MongoDbThrottlingSettings struct {
	// The maximum number of work items (e.g. collection copies) that will be processed in parallel
	MaxParallelism *int32 `json:"maxParallelism,omitempty"`

	// The percentage of CPU time that the migrator will try to avoid using, from 0 to 100
	MinFreeCPU *int32 `json:"minFreeCpu,omitempty"`

	// The number of megabytes of RAM that the migrator will try to avoid using
	MinFreeMemoryMb *int32 `json:"minFreeMemoryMb,omitempty"`
}

// MySQLConnectionInfo - Information for connecting to MySQL server
type MySQLConnectionInfo struct {
	// REQUIRED; Port for Server
	Port *int32 `json:"port,omitempty"`

	// REQUIRED; Name of the server
	ServerName *string `json:"serverName,omitempty"`

	// REQUIRED; Type of connection info
	Type *string `json:"type,omitempty"`

	// Whether to encrypt the connection
	EncryptConnection *bool `json:"encryptConnection,omitempty"`

	// Password credential.
	Password *string `json:"password,omitempty"`

	// User name
	UserName *string `json:"userName,omitempty"`
}

// GetConnectionInfo implements the ConnectionInfoClassification interface for type MySQLConnectionInfo.
func (m *MySQLConnectionInfo) GetConnectionInfo() *ConnectionInfo {
	return &ConnectionInfo{
		Type:     m.Type,
		UserName: m.UserName,
		Password: m.Password,
	}
}

// NameAvailabilityRequest - A resource type and proposed name
type NameAvailabilityRequest struct {
	// The proposed resource name
	Name *string `json:"name,omitempty"`

	// The resource type chain (e.g. virtualMachines/extensions)
	Type *string `json:"type,omitempty"`
}

// NameAvailabilityResponse - Indicates whether a proposed resource name is available
type NameAvailabilityResponse struct {
	// The localized reason why the name is not available, if nameAvailable is false
	Message *string `json:"message,omitempty"`

	// If true, the name is valid and available. If false, 'reason' describes why not.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// The reason why the name is not available, if nameAvailable is false
	Reason *NameCheckFailureReason `json:"reason,omitempty"`
}

// NonSQLDataMigrationTable - Defines metadata for table to be migrated
type NonSQLDataMigrationTable struct {
	// Source table name
	SourceName *string `json:"sourceName,omitempty"`
}

// NonSQLDataMigrationTableResult - Object used to report the data migration results of a table
type NonSQLDataMigrationTableResult struct {
	// READ-ONLY; Time taken to migrate the data
	ElapsedTimeInMiliseconds *float64 `json:"elapsedTimeInMiliseconds,omitempty" azure:"ro"`

	// READ-ONLY; List of errors, if any, during migration
	Errors []*Error `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Result code of the data migration
	ResultCode *DataMigrationResultCode `json:"resultCode,omitempty" azure:"ro"`

	// READ-ONLY; Name of the source table
	SourceName *string `json:"sourceName,omitempty" azure:"ro"`

	// READ-ONLY; Number of rows in the source table
	SourceRowCount *int64 `json:"sourceRowCount,omitempty" azure:"ro"`

	// READ-ONLY; Name of the target table
	TargetName *string `json:"targetName,omitempty" azure:"ro"`

	// READ-ONLY; Number of rows in the target table
	TargetRowCount *int64 `json:"targetRowCount,omitempty" azure:"ro"`
}

// NonSQLMigrationTaskInput - Base class for non sql migration task input
type NonSQLMigrationTaskInput struct {
	// REQUIRED; A URL that points to the drop location to access project artifacts
	ProjectLocation *string `json:"projectLocation,omitempty"`

	// REQUIRED; Name of the migration project
	ProjectName *string `json:"projectName,omitempty"`

	// REQUIRED; Metadata of the tables selected for migration
	SelectedTables []*NonSQLDataMigrationTable `json:"selectedTables,omitempty"`

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`

	// REQUIRED; Target database name
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
}

// NonSQLMigrationTaskOutput - Base class for non sql migration task output
type NonSQLMigrationTaskOutput struct {
	// READ-ONLY; Results of the migration. The key contains the table name and the value the table result object
	DataMigrationTableResults *string `json:"dataMigrationTableResults,omitempty" azure:"ro"`

	// READ-ONLY; Migration end time
	EndedOn *time.Time `json:"endedOn,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Message about the progress of the migration
	ProgressMessage *string `json:"progressMessage,omitempty" azure:"ro"`

	// READ-ONLY; Name of source server
	SourceServerName *string `json:"sourceServerName,omitempty" azure:"ro"`

	// READ-ONLY; Migration start time
	StartedOn *time.Time `json:"startedOn,omitempty" azure:"ro"`

	// READ-ONLY; Current state of migration
	Status *MigrationStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Name of target server
	TargetServerName *string `json:"targetServerName,omitempty" azure:"ro"`
}

// ODataError - Error information in OData format.
type ODataError struct {
	// The machine-readable description of the error, such as 'InvalidRequest' or 'InternalServerError'
	Code *string `json:"code,omitempty"`

	// Inner errors that caused this error
	Details []*ODataError `json:"details,omitempty"`

	// The human-readable description of the error
	Message *string `json:"message,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OracleConnectionInfo - Information for connecting to Oracle server
type OracleConnectionInfo struct {
	// REQUIRED; EZConnect or TNSName connection string.
	DataSource *string `json:"dataSource,omitempty"`

	// REQUIRED; Type of connection info
	Type *string `json:"type,omitempty"`

	// Password credential.
	Password *string `json:"password,omitempty"`

	// User name
	UserName *string `json:"userName,omitempty"`
}

// GetConnectionInfo implements the ConnectionInfoClassification interface for type OracleConnectionInfo.
func (o *OracleConnectionInfo) GetConnectionInfo() *ConnectionInfo {
	return &ConnectionInfo{
		Type:     o.Type,
		UserName: o.UserName,
		Password: o.Password,
	}
}

// OracleOCIDriverInfo - Information about an Oracle OCI driver.
type OracleOCIDriverInfo struct {
	// READ-ONLY; The MD5 Base64 encoded checksum for the driver package.
	ArchiveChecksum *string `json:"archiveChecksum,omitempty" azure:"ro"`

	// READ-ONLY; Version listed in the OCI assembly 'oci.dll'
	AssemblyVersion *string `json:"assemblyVersion,omitempty" azure:"ro"`

	// READ-ONLY; The name of the driver package
	DriverName *string `json:"driverName,omitempty" azure:"ro"`

	// READ-ONLY; The size in bytes of the driver package
	DriverSize *string `json:"driverSize,omitempty" azure:"ro"`

	// READ-ONLY; The checksum for the driver package provided by Oracle.
	OracleChecksum *string `json:"oracleChecksum,omitempty" azure:"ro"`

	// READ-ONLY; List of Oracle database versions supported by this driver. Only major minor of the version is listed.
	SupportedOracleVersions []*string `json:"supportedOracleVersions,omitempty" azure:"ro"`
}

// OrphanedUserInfo - Information of orphaned users on the SQL server database.
type OrphanedUserInfo struct {
	// Parent database of the user
	DatabaseName *string `json:"databaseName,omitempty"`

	// Name of the orphaned user
	Name *string `json:"name,omitempty"`
}

// PostgreSQLConnectionInfo - Information for connecting to PostgreSQL server
type PostgreSQLConnectionInfo struct {
	// REQUIRED; Port for Server
	Port *int32 `json:"port,omitempty"`

	// REQUIRED; Name of the server
	ServerName *string `json:"serverName,omitempty"`

	// REQUIRED; Type of connection info
	Type *string `json:"type,omitempty"`

	// Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`

	// Whether to encrypt the connection
	EncryptConnection *bool `json:"encryptConnection,omitempty"`

	// Password credential.
	Password *string `json:"password,omitempty"`

	// Whether to trust the server certificate
	TrustServerCertificate *bool `json:"trustServerCertificate,omitempty"`

	// User name
	UserName *string `json:"userName,omitempty"`
}

// GetConnectionInfo implements the ConnectionInfoClassification interface for type PostgreSQLConnectionInfo.
func (p *PostgreSQLConnectionInfo) GetConnectionInfo() *ConnectionInfo {
	return &ConnectionInfo{
		Type:     p.Type,
		UserName: p.UserName,
		Password: p.Password,
	}
}

// Project - A project resource
type Project struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// Project properties
	Properties *ProjectProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProjectFile - A file resource
type ProjectFile struct {
	// HTTP strong entity tag value. This is ignored if submitted.
	Etag *string `json:"etag,omitempty"`

	// Custom file properties
	Properties *ProjectFileProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProjectFileProperties - Base class for file properties.
type ProjectFileProperties struct {
	// Optional File extension. If submitted it should not have a leading period and must match the extension from filePath.
	Extension *string `json:"extension,omitempty"`

	// Relative path of this file resource. This property can be set when creating or updating the file resource.
	FilePath *string `json:"filePath,omitempty"`

	// File content type. This property can be modified to reflect the file content type.
	MediaType *string `json:"mediaType,omitempty"`

	// READ-ONLY; Modification DateTime.
	LastModified *time.Time `json:"lastModified,omitempty" azure:"ro"`

	// READ-ONLY; File size.
	Size *int64 `json:"size,omitempty" azure:"ro"`
}

// ProjectList - OData page of project resources
type ProjectList struct {
	// URL to load the next page of projects
	NextLink *string `json:"nextLink,omitempty"`

	// List of projects
	Value []*Project `json:"value,omitempty"`
}

// ProjectMetadata - Common metadata for migration projects
type ProjectMetadata struct {
	// READ-ONLY; List of tables selected for migration
	SelectedMigrationTables []*MigrationTableMetadata `json:"selectedMigrationTables,omitempty" azure:"ro"`

	// READ-ONLY; Source server name
	SourceServerName *string `json:"sourceServerName,omitempty" azure:"ro"`

	// READ-ONLY; Source server port number
	SourceServerPort *string `json:"sourceServerPort,omitempty" azure:"ro"`

	// READ-ONLY; Source username
	SourceUsername *string `json:"sourceUsername,omitempty" azure:"ro"`

	// READ-ONLY; Target database name
	TargetDbName *string `json:"targetDbName,omitempty" azure:"ro"`

	// READ-ONLY; Target server name
	TargetServerName *string `json:"targetServerName,omitempty" azure:"ro"`

	// READ-ONLY; Target username
	TargetUsername *string `json:"targetUsername,omitempty" azure:"ro"`

	// READ-ONLY; Whether target connection is Windows authentication
	TargetUsingWinAuth *bool `json:"targetUsingWinAuth,omitempty" azure:"ro"`
}

// ProjectProperties - Project-specific properties
type ProjectProperties struct {
	// REQUIRED; Source platform for the project
	SourcePlatform *ProjectSourcePlatform `json:"sourcePlatform,omitempty"`

	// REQUIRED; Target platform for the project
	TargetPlatform *ProjectTargetPlatform `json:"targetPlatform,omitempty"`

	// List of DatabaseInfo
	DatabasesInfo []*DatabaseInfo `json:"databasesInfo,omitempty"`

	// Information for connecting to source
	SourceConnectionInfo ConnectionInfoClassification `json:"sourceConnectionInfo,omitempty"`

	// Information for connecting to target
	TargetConnectionInfo ConnectionInfoClassification `json:"targetConnectionInfo,omitempty"`

	// READ-ONLY; UTC Date and time when project was created
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; The project's provisioning state
	ProvisioningState *ProjectProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ProjectTask - A task resource
type ProjectTask struct {
	// HTTP strong entity tag value. This is ignored if submitted.
	Etag *string `json:"etag,omitempty"`

	// Custom task properties
	Properties ProjectTaskPropertiesClassification `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProjectTaskPropertiesClassification provides polymorphic access to related types.
// Call the interface's GetProjectTaskProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CheckOCIDriverTaskProperties, *ConnectToMongoDbTaskProperties, *ConnectToSourceMySQLTaskProperties, *ConnectToSourceOracleSyncTaskProperties,
// - *ConnectToSourcePostgreSQLSyncTaskProperties, *ConnectToSourceSQLServerSyncTaskProperties, *ConnectToSourceSQLServerTaskProperties,
// - *ConnectToTargetAzureDbForMySQLTaskProperties, *ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, *ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties,
// - *ConnectToTargetSQLDbSyncTaskProperties, *ConnectToTargetSQLDbTaskProperties, *ConnectToTargetSQLMISyncTaskProperties,
// - *ConnectToTargetSQLMITaskProperties, *GetTdeCertificatesSQLTaskProperties, *GetUserTablesMySQLTaskProperties, *GetUserTablesOracleTaskProperties,
// - *GetUserTablesPostgreSQLTaskProperties, *GetUserTablesSQLSyncTaskProperties, *GetUserTablesSQLTaskProperties, *InstallOCIDriverTaskProperties,
// - *MigrateMongoDbTaskProperties, *MigrateMySQLAzureDbForMySQLOfflineTaskProperties, *MigrateMySQLAzureDbForMySQLSyncTaskProperties,
// - *MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, *MigrateSQLServerSQLDbSyncTaskProperties,
// - *MigrateSQLServerSQLDbTaskProperties, *MigrateSQLServerSQLMISyncTaskProperties, *MigrateSQLServerSQLMITaskProperties,
// - *MigrateSchemaSQLServerSQLDbTaskProperties, *MigrateSsisTaskProperties, *ProjectTaskProperties, *UploadOCIDriverTaskProperties,
// - *ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, *ValidateMigrationInputSQLServerSQLMISyncTaskProperties, *ValidateMigrationInputSQLServerSQLMITaskProperties,
// - *ValidateMongoDbTaskProperties, *ValidateOracleAzureDbForPostgreSQLSyncTaskProperties
type ProjectTaskPropertiesClassification interface {
	// GetProjectTaskProperties returns the ProjectTaskProperties content of the underlying type.
	GetProjectTaskProperties() *ProjectTaskProperties
}

// ProjectTaskProperties - Base class for all types of DMS task properties. If task is not supported by current client, this
// object is returned.
type ProjectTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ProjectTaskProperties.
func (p *ProjectTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties { return p }

// ProjectsClientCreateOrUpdateOptions contains the optional parameters for the ProjectsClient.CreateOrUpdate method.
type ProjectsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProjectsClientDeleteOptions contains the optional parameters for the ProjectsClient.Delete method.
type ProjectsClientDeleteOptions struct {
	// Delete the resource even if it contains running tasks
	DeleteRunningTasks *bool
}

// ProjectsClientGetOptions contains the optional parameters for the ProjectsClient.Get method.
type ProjectsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProjectsClientListOptions contains the optional parameters for the ProjectsClient.List method.
type ProjectsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProjectsClientUpdateOptions contains the optional parameters for the ProjectsClient.Update method.
type ProjectsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// QueryAnalysisValidationResult - Results for query analysis comparison between the source and target
type QueryAnalysisValidationResult struct {
	// List of queries executed and it's execution results in source and target
	QueryResults *QueryExecutionResult `json:"queryResults,omitempty"`

	// Errors that are part of the execution
	ValidationErrors *ValidationError `json:"validationErrors,omitempty"`
}

// QueryExecutionResult - Describes query analysis results for execution in source and target
type QueryExecutionResult struct {
	// Query text retrieved from the source server
	QueryText *string `json:"queryText,omitempty"`

	// Query analysis result from the source
	SourceResult *ExecutionStatistics `json:"sourceResult,omitempty"`

	// Total no. of statements in the batch
	StatementsInBatch *int64 `json:"statementsInBatch,omitempty"`

	// Query analysis result from the target
	TargetResult *ExecutionStatistics `json:"targetResult,omitempty"`
}

// Quota - Describes a quota for or usage details about a resource
type Quota struct {
	// The current value of the quota. If null or missing, the current value cannot be determined in the context of the request.
	CurrentValue *float64 `json:"currentValue,omitempty"`

	// The resource ID of the quota object
	ID *string `json:"id,omitempty"`

	// The maximum value of the quota. If null or missing, the quota has no maximum, in which case it merely tracks usage.
	Limit *float64 `json:"limit,omitempty"`

	// The name of the quota
	Name *QuotaName `json:"name,omitempty"`

	// The unit for the quota, such as Count, Bytes, BytesPerSecond, etc.
	Unit *string `json:"unit,omitempty"`
}

// QuotaList - OData page of quota objects
type QuotaList struct {
	// URL to load the next page of quotas, or null or missing if this is the last page
	NextLink *string `json:"nextLink,omitempty"`

	// List of quotas
	Value []*Quota `json:"value,omitempty"`
}

// QuotaName - The name of the quota
type QuotaName struct {
	// The localized name of the quota
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// The unlocalized name (or ID) of the quota
	Value *string `json:"value,omitempty"`
}

// ReportableException - Exception object for all custom exceptions
type ReportableException struct {
	// Actionable steps for this exception
	ActionableMessage *string `json:"actionableMessage,omitempty"`

	// The path to the file where exception occurred
	FilePath *string `json:"filePath,omitempty"`

	// Coded numerical value that is assigned to a specific exception
	HResult *int32 `json:"hResult,omitempty"`

	// The line number where exception occurred
	LineNumber *string `json:"lineNumber,omitempty"`

	// Error message
	Message *string `json:"message,omitempty"`

	// Stack trace
	StackTrace *string `json:"stackTrace,omitempty"`
}

// Resource - ARM resource.
type Resource struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceSKU - Describes an available DMS SKU.
type ResourceSKU struct {
	// READ-ONLY; The api versions that support this SKU.
	APIVersions []*string `json:"apiVersions,omitempty" azure:"ro"`

	// READ-ONLY; A name value pair to describe the capability.
	Capabilities []*ResourceSKUCapabilities `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; Not used.
	Capacity *ResourceSKUCapacity `json:"capacity,omitempty" azure:"ro"`

	// READ-ONLY; Metadata for retrieving price info.
	Costs []*ResourceSKUCosts `json:"costs,omitempty" azure:"ro"`

	// READ-ONLY; The Family of this particular SKU.
	Family *string `json:"family,omitempty" azure:"ro"`

	// READ-ONLY; The Kind of resources that are supported in this SKU.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; The set of locations that the SKU is available.
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; The name of SKU.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions []*ResourceSKURestrictions `json:"restrictions,omitempty" azure:"ro"`

	// READ-ONLY; The Size of the SKU.
	Size *string `json:"size,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the tier of DMS in a scale set.
	Tier *string `json:"tier,omitempty" azure:"ro"`
}

// ResourceSKUCapabilities - Describes The SKU capabilities object.
type ResourceSKUCapabilities struct {
	// READ-ONLY; An invariant to describe the feature.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; An invariant if the feature is measured by quantity.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// ResourceSKUCapacity - Describes scaling information of a SKU.
type ResourceSKUCapacity struct {
	// READ-ONLY; The default capacity.
	Default *int64 `json:"default,omitempty" azure:"ro"`

	// READ-ONLY; The maximum capacity.
	Maximum *int64 `json:"maximum,omitempty" azure:"ro"`

	// READ-ONLY; The minimum capacity.
	Minimum *int64 `json:"minimum,omitempty" azure:"ro"`

	// READ-ONLY; The scale type applicable to the SKU.
	ScaleType *ResourceSKUCapacityScaleType `json:"scaleType,omitempty" azure:"ro"`
}

// ResourceSKUCosts - Describes metadata for retrieving price info.
type ResourceSKUCosts struct {
	// READ-ONLY; An invariant to show the extended unit.
	ExtendedUnit *string `json:"extendedUnit,omitempty" azure:"ro"`

	// READ-ONLY; Used for querying price from commerce.
	MeterID *string `json:"meterID,omitempty" azure:"ro"`

	// READ-ONLY; The multiplier is needed to extend the base metered cost.
	Quantity *int64 `json:"quantity,omitempty" azure:"ro"`
}

// ResourceSKURestrictions - Describes scaling information of a SKU.
type ResourceSKURestrictions struct {
	// READ-ONLY; The reason code for restriction.
	ReasonCode *ResourceSKURestrictionsReasonCode `json:"reasonCode,omitempty" azure:"ro"`

	// READ-ONLY; The type of restrictions.
	Type *ResourceSKURestrictionsType `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where
	// the SKU is restricted.
	Values []*string `json:"values,omitempty" azure:"ro"`
}

// ResourceSKUsClientListSKUsOptions contains the optional parameters for the ResourceSKUsClient.ListSKUs method.
type ResourceSKUsClientListSKUsOptions struct {
	// placeholder for future optional parameters
}

// ResourceSKUsResult - The DMS List SKUs operation response.
type ResourceSKUsResult struct {
	// REQUIRED; The list of SKUs available for the subscription.
	Value []*ResourceSKU `json:"value,omitempty"`

	// The uri to fetch the next page of DMS SKUs. Call ListNext() with this to fetch the next page of DMS SKUs.
	NextLink *string `json:"nextLink,omitempty"`
}

// SQLConnectionInfo - Information for connecting to SQL database server
type SQLConnectionInfo struct {
	// REQUIRED; Data source in the format Protocol:MachineName\SQLServerInstanceName,PortNumber
	DataSource *string `json:"dataSource,omitempty"`

	// REQUIRED; Type of connection info
	Type *string `json:"type,omitempty"`

	// Additional connection settings
	AdditionalSettings *string `json:"additionalSettings,omitempty"`

	// Authentication type to use for connection
	Authentication *AuthenticationType `json:"authentication,omitempty"`

	// Whether to encrypt the connection
	EncryptConnection *bool `json:"encryptConnection,omitempty"`

	// Password credential.
	Password *string `json:"password,omitempty"`

	// Server platform type for connection
	Platform *SQLSourcePlatform `json:"platform,omitempty"`

	// Whether to trust the server certificate
	TrustServerCertificate *bool `json:"trustServerCertificate,omitempty"`

	// User name
	UserName *string `json:"userName,omitempty"`
}

// GetConnectionInfo implements the ConnectionInfoClassification interface for type SQLConnectionInfo.
func (s *SQLConnectionInfo) GetConnectionInfo() *ConnectionInfo {
	return &ConnectionInfo{
		Type:     s.Type,
		UserName: s.UserName,
		Password: s.Password,
	}
}

// SQLMigrationTaskInput - Base class for migration task input
type SQLMigrationTaskInput struct {
	// REQUIRED; Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// SQLServerSQLMISyncTaskInput - Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance
// online scenario.
type SQLServerSQLMISyncTaskInput struct {
	// REQUIRED; Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database
	// Managed Instance and the Azure Storage Account
	AzureApp *AzureActiveDirectoryApp `json:"azureApp,omitempty"`

	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSQLServerSQLMIDatabaseInput `json:"selectedDatabases,omitempty"`

	// REQUIRED; Connection information for source SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Fully qualified resourceId of storage
	StorageResourceID *string `json:"storageResourceId,omitempty"`

	// REQUIRED; Connection information for Azure SQL Database Managed Instance
	TargetConnectionInfo *MiSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`

	// Backup file share information for all selected databases.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
}

// SchemaComparisonValidationResult - Results for schema comparison between the source and target
type SchemaComparisonValidationResult struct {
	// List of schema differences between the source and target databases
	SchemaDifferences *SchemaComparisonValidationResultType `json:"schemaDifferences,omitempty"`

	// Count of source database objects
	SourceDatabaseObjectCount map[string]*int64 `json:"sourceDatabaseObjectCount,omitempty"`

	// Count of target database objects
	TargetDatabaseObjectCount map[string]*int64 `json:"targetDatabaseObjectCount,omitempty"`

	// List of errors that happened while performing schema compare validation
	ValidationErrors *ValidationError `json:"validationErrors,omitempty"`
}

// SchemaComparisonValidationResultType - Description about the errors happen while performing migration validation
type SchemaComparisonValidationResultType struct {
	// Name of the object that has the difference
	ObjectName *string `json:"objectName,omitempty"`

	// Type of the object that has the difference. e.g (Table/View/StoredProcedure)
	ObjectType *ObjectType `json:"objectType,omitempty"`

	// Update action type with respect to target
	UpdateAction *UpdateActionType `json:"updateAction,omitempty"`
}

// SchemaMigrationSetting - Settings for migrating schema from source to target
type SchemaMigrationSetting struct {
	// Resource Identifier of a file resource containing the uploaded schema file
	FileID *string `json:"fileId,omitempty"`

	// Option on how to migrate the schema
	SchemaOption *SchemaMigrationOption `json:"schemaOption,omitempty"`
}

// SelectedCertificateInput - Info for certificate to be exported for TDE enabled databases.
type SelectedCertificateInput struct {
	// REQUIRED; Name of certificate to be exported.
	CertificateName *string `json:"certificateName,omitempty"`

	// REQUIRED; Password to use for encrypting the exported certificate.
	Password *string `json:"password,omitempty"`
}

// ServerProperties - Server properties for MySQL type source
type ServerProperties struct {
	// READ-ONLY; Number of databases in the server
	ServerDatabaseCount *int32 `json:"serverDatabaseCount,omitempty" azure:"ro"`

	// READ-ONLY; Edition of the database server
	ServerEdition *string `json:"serverEdition,omitempty" azure:"ro"`

	// READ-ONLY; Name of the server
	ServerName *string `json:"serverName,omitempty" azure:"ro"`

	// READ-ONLY; Version of the operating system
	ServerOperatingSystemVersion *string `json:"serverOperatingSystemVersion,omitempty" azure:"ro"`

	// READ-ONLY; Name of the server platform
	ServerPlatform *string `json:"serverPlatform,omitempty" azure:"ro"`

	// READ-ONLY; Version of the database server
	ServerVersion *string `json:"serverVersion,omitempty" azure:"ro"`
}

// Service - A Database Migration Service resource
type Service struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// HTTP strong entity tag value. Ignored if submitted
	Etag *string `json:"etag,omitempty"`

	// The resource kind. Only 'vm' (the default) is supported.
	Kind *string `json:"kind,omitempty"`

	// Custom service properties
	Properties *ServiceProperties `json:"properties,omitempty"`

	// Service SKU
	SKU *ServiceSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceList - OData page of service objects
type ServiceList struct {
	// URL to load the next page of services
	NextLink *string `json:"nextLink,omitempty"`

	// List of services
	Value []*Service `json:"value,omitempty"`
}

// ServiceOperation - Description of an action supported by the Database Migration Service
type ServiceOperation struct {
	// Localized display text
	Display *ServiceOperationDisplay `json:"display,omitempty"`

	// The fully qualified action name, e.g. Microsoft.DataMigration/services/read
	Name *string `json:"name,omitempty"`
}

// ServiceOperationDisplay - Localized display text
type ServiceOperationDisplay struct {
	// The localized operation description
	Description *string `json:"description,omitempty"`

	// The localized operation name
	Operation *string `json:"operation,omitempty"`

	// The localized resource provider name
	Provider *string `json:"provider,omitempty"`

	// The localized resource type name
	Resource *string `json:"resource,omitempty"`
}

// ServiceOperationList - OData page of action (operation) objects
type ServiceOperationList struct {
	// URL to load the next page of actions
	NextLink *string `json:"nextLink,omitempty"`

	// List of actions
	Value []*ServiceOperation `json:"value,omitempty"`
}

// ServiceProperties - Properties of the Database Migration Service instance
type ServiceProperties struct {
	// REQUIRED; The ID of the Microsoft.Network/virtualNetworks/subnets resource to which the service should be joined
	VirtualSubnetID *string `json:"virtualSubnetId,omitempty"`

	// The public key of the service, used to encrypt secrets sent to the service
	PublicKey *string `json:"publicKey,omitempty"`

	// The ID of the Microsoft.Network/networkInterfaces resource which the service have
	VirtualNicID *string `json:"virtualNicId,omitempty"`

	// READ-ONLY; The resource's provisioning state
	ProvisioningState *ServiceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ServiceSKU - An Azure SKU instance
type ServiceSKU struct {
	// The capacity of the SKU, if it supports scaling
	Capacity *int32 `json:"capacity,omitempty"`

	// The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual
	// machines
	Family *string `json:"family,omitempty"`

	// The unique name of the SKU, such as 'P3'
	Name *string `json:"name,omitempty"`

	// The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes
	// within a family, e.g. 'A1' for virtual machines
	Size *string `json:"size,omitempty"`

	// The tier of the SKU, such as 'Basic', 'General Purpose', or 'Business Critical'
	Tier *string `json:"tier,omitempty"`
}

// ServiceSKUList - OData page of available SKUs
type ServiceSKUList struct {
	// URL to load the next page of service SKUs
	NextLink *string `json:"nextLink,omitempty"`

	// List of service SKUs
	Value []*AvailableServiceSKU `json:"value,omitempty"`
}

// ServiceStatusResponse - Service health status
type ServiceStatusResponse struct {
	// The DMS instance agent version
	AgentVersion *string `json:"agentVersion,omitempty"`

	// The machine-readable status, such as 'Initializing', 'Offline', 'Online', 'Deploying', 'Deleting', 'Stopped', 'Stopping',
	// 'Starting', 'FailedToStart', 'FailedToStop' or 'Failed'
	Status *string `json:"status,omitempty"`

	// The list of supported task types
	SupportedTaskTypes []*string `json:"supportedTaskTypes,omitempty"`

	// The services virtual machine size, such as 'StandardD2v2'
	VMSize *string `json:"vmSize,omitempty"`
}

// ServiceTasksClientCancelOptions contains the optional parameters for the ServiceTasksClient.Cancel method.
type ServiceTasksClientCancelOptions struct {
	// placeholder for future optional parameters
}

// ServiceTasksClientCreateOrUpdateOptions contains the optional parameters for the ServiceTasksClient.CreateOrUpdate method.
type ServiceTasksClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServiceTasksClientDeleteOptions contains the optional parameters for the ServiceTasksClient.Delete method.
type ServiceTasksClientDeleteOptions struct {
	// Delete the resource even if it contains running tasks
	DeleteRunningTasks *bool
}

// ServiceTasksClientGetOptions contains the optional parameters for the ServiceTasksClient.Get method.
type ServiceTasksClientGetOptions struct {
	// Expand the response
	Expand *string
}

// ServiceTasksClientListOptions contains the optional parameters for the ServiceTasksClient.List method.
type ServiceTasksClientListOptions struct {
	// Filter tasks by task type
	TaskType *string
}

// ServiceTasksClientUpdateOptions contains the optional parameters for the ServiceTasksClient.Update method.
type ServiceTasksClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientBeginCreateOrUpdateOptions contains the optional parameters for the ServicesClient.BeginCreateOrUpdate method.
type ServicesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientBeginDeleteOptions contains the optional parameters for the ServicesClient.BeginDelete method.
type ServicesClientBeginDeleteOptions struct {
	// Delete the resource even if it contains running tasks
	DeleteRunningTasks *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientBeginStartOptions contains the optional parameters for the ServicesClient.BeginStart method.
type ServicesClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientBeginStopOptions contains the optional parameters for the ServicesClient.BeginStop method.
type ServicesClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientBeginUpdateOptions contains the optional parameters for the ServicesClient.BeginUpdate method.
type ServicesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientCheckChildrenNameAvailabilityOptions contains the optional parameters for the ServicesClient.CheckChildrenNameAvailability
// method.
type ServicesClientCheckChildrenNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientCheckNameAvailabilityOptions contains the optional parameters for the ServicesClient.CheckNameAvailability
// method.
type ServicesClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientCheckStatusOptions contains the optional parameters for the ServicesClient.CheckStatus method.
type ServicesClientCheckStatusOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientGetOptions contains the optional parameters for the ServicesClient.Get method.
type ServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListByResourceGroupOptions contains the optional parameters for the ServicesClient.ListByResourceGroup method.
type ServicesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListOptions contains the optional parameters for the ServicesClient.List method.
type ServicesClientListOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListSKUsOptions contains the optional parameters for the ServicesClient.ListSKUs method.
type ServicesClientListSKUsOptions struct {
	// placeholder for future optional parameters
}

// SsisMigrationInfo - SSIS migration info with SSIS store type, overwrite policy.
type SsisMigrationInfo struct {
	// The overwrite option for the SSIS environment migration
	EnvironmentOverwriteOption *SsisMigrationOverwriteOption `json:"environmentOverwriteOption,omitempty"`

	// The overwrite option for the SSIS project migration
	ProjectOverwriteOption *SsisMigrationOverwriteOption `json:"projectOverwriteOption,omitempty"`

	// The SSIS store type of source, only SSIS catalog is supported now in DMS
	SsisStoreType *SsisStoreType `json:"ssisStoreType,omitempty"`
}

// StartMigrationScenarioServerRoleResult - Server role migration result
type StartMigrationScenarioServerRoleResult struct {
	// READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings []*ReportableException `json:"exceptionsAndWarnings,omitempty" azure:"ro"`

	// READ-ONLY; Name of server role.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Current state of migration
	State *MigrationState `json:"state,omitempty" azure:"ro"`
}

// SyncMigrationDatabaseErrorEvent - Database migration errors for online migration
type SyncMigrationDatabaseErrorEvent struct {
	// READ-ONLY; Event text.
	EventText *string `json:"eventText,omitempty" azure:"ro"`

	// READ-ONLY; Event type.
	EventTypeString *string `json:"eventTypeString,omitempty" azure:"ro"`

	// READ-ONLY; String value of timestamp.
	TimestampString *string `json:"timestampString,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TaskList - OData page of tasks
type TaskList struct {
	// URL to load the next page of tasks
	NextLink *string `json:"nextLink,omitempty"`

	// List of tasks
	Value []*ProjectTask `json:"value,omitempty"`
}

// TasksClientCancelOptions contains the optional parameters for the TasksClient.Cancel method.
type TasksClientCancelOptions struct {
	// placeholder for future optional parameters
}

// TasksClientCommandOptions contains the optional parameters for the TasksClient.Command method.
type TasksClientCommandOptions struct {
	// placeholder for future optional parameters
}

// TasksClientCreateOrUpdateOptions contains the optional parameters for the TasksClient.CreateOrUpdate method.
type TasksClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// TasksClientDeleteOptions contains the optional parameters for the TasksClient.Delete method.
type TasksClientDeleteOptions struct {
	// Delete the resource even if it contains running tasks
	DeleteRunningTasks *bool
}

// TasksClientGetOptions contains the optional parameters for the TasksClient.Get method.
type TasksClientGetOptions struct {
	// Expand the response
	Expand *string
}

// TasksClientListOptions contains the optional parameters for the TasksClient.List method.
type TasksClientListOptions struct {
	// Filter tasks by task type
	TaskType *string
}

// TasksClientUpdateOptions contains the optional parameters for the TasksClient.Update method.
type TasksClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// TrackedResource - ARM tracked top level resource.
type TrackedResource struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UploadOCIDriverTaskInput - Input for the service task to upload an OCI driver.
type UploadOCIDriverTaskInput struct {
	// File share information for the OCI driver archive.
	DriverShare *FileShare `json:"driverShare,omitempty"`
}

// UploadOCIDriverTaskOutput - Output for the service task to upload an OCI driver.
type UploadOCIDriverTaskOutput struct {
	// READ-ONLY; The name of the driver package that was validated and uploaded.
	DriverPackageName *string `json:"driverPackageName,omitempty" azure:"ro"`

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// UploadOCIDriverTaskProperties - Properties for the task that uploads an OCI driver.
type UploadOCIDriverTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Input for the service task to upload an OCI driver.
	Input *UploadOCIDriverTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*UploadOCIDriverTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type UploadOCIDriverTaskProperties.
func (u *UploadOCIDriverTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   u.TaskType,
		Errors:     u.Errors,
		State:      u.State,
		Commands:   u.Commands,
		ClientData: u.ClientData,
	}
}

// UsagesClientListOptions contains the optional parameters for the UsagesClient.List method.
type UsagesClientListOptions struct {
	// placeholder for future optional parameters
}

// ValidateMigrationInputSQLServerSQLDbSyncTaskProperties - Properties for task that validates migration input for SQL to
// Azure SQL DB sync migrations
type ValidateMigrationInputSQLServerSQLDbSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *ValidateSyncMigrationInputSQLServerTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ValidateSyncMigrationInputSQLServerTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (v *ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   v.TaskType,
		Errors:     v.Errors,
		State:      v.State,
		Commands:   v.Commands,
		ClientData: v.ClientData,
	}
}

// ValidateMigrationInputSQLServerSQLMISyncTaskInput - Input for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance online scenario.
type ValidateMigrationInputSQLServerSQLMISyncTaskInput struct {
	// REQUIRED; Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database
	// Managed Instance and the Azure Storage Account
	AzureApp *AzureActiveDirectoryApp `json:"azureApp,omitempty"`

	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSQLServerSQLMIDatabaseInput `json:"selectedDatabases,omitempty"`

	// REQUIRED; Connection information for source SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Fully qualified resourceId of storage
	StorageResourceID *string `json:"storageResourceId,omitempty"`

	// REQUIRED; Connection information for Azure SQL Database Managed Instance
	TargetConnectionInfo *MiSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`

	// Backup file share information for all selected databases.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
}

// ValidateMigrationInputSQLServerSQLMISyncTaskOutput - Output for task that validates migration input for Azure SQL Database
// Managed Instance online migration
type ValidateMigrationInputSQLServerSQLMISyncTaskOutput struct {
	// READ-ONLY; Database identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of database
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Errors associated with a selected database object
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// ValidateMigrationInputSQLServerSQLMISyncTaskProperties - Properties for task that validates migration input for SQL to
// Azure SQL Database Managed Instance sync scenario
type ValidateMigrationInputSQLServerSQLMISyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *ValidateMigrationInputSQLServerSQLMISyncTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ValidateMigrationInputSQLServerSQLMISyncTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (v *ValidateMigrationInputSQLServerSQLMISyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   v.TaskType,
		Errors:     v.Errors,
		State:      v.State,
		Commands:   v.Commands,
		ClientData: v.ClientData,
	}
}

// ValidateMigrationInputSQLServerSQLMITaskInput - Input for task that validates migration input for SQL to Azure SQL Managed
// Instance
type ValidateMigrationInputSQLServerSQLMITaskInput struct {
	// REQUIRED; SAS URI of Azure Storage Account Container to be used for storing backup files.
	BackupBlobShare *BlobShare `json:"backupBlobShare,omitempty"`

	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSQLServerSQLMIDatabaseInput `json:"selectedDatabases,omitempty"`

	// REQUIRED; Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`

	// Backup file share information for all selected databases.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`

	// Backup Mode to specify whether to use existing backup or create new backup.
	BackupMode *BackupMode `json:"backupMode,omitempty"`

	// Logins to migrate
	SelectedLogins []*string `json:"selectedLogins,omitempty"`
}

// ValidateMigrationInputSQLServerSQLMITaskOutput - Output for task that validates migration input for SQL to Azure SQL Managed
// Instance migrations
type ValidateMigrationInputSQLServerSQLMITaskOutput struct {
	// Information about backup files when existing backup mode is used.
	DatabaseBackupInfo *DatabaseBackupInfo `json:"databaseBackupInfo,omitempty"`

	// READ-ONLY; Errors associated with the BackupFolder path
	BackupFolderErrors []*ReportableException `json:"backupFolderErrors,omitempty" azure:"ro"`

	// READ-ONLY; Errors associated with backup share user name and password credentials
	BackupShareCredentialsErrors []*ReportableException `json:"backupShareCredentialsErrors,omitempty" azure:"ro"`

	// READ-ONLY; Errors associated with the storage account provided.
	BackupStorageAccountErrors []*ReportableException `json:"backupStorageAccountErrors,omitempty" azure:"ro"`

	// READ-ONLY; Errors associated with existing backup files.
	ExistingBackupErrors []*ReportableException `json:"existingBackupErrors,omitempty" azure:"ro"`

	// READ-ONLY; Result identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of database
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Errors associated with the RestoreDatabaseName
	RestoreDatabaseNameErrors []*ReportableException `json:"restoreDatabaseNameErrors,omitempty" azure:"ro"`
}

// ValidateMigrationInputSQLServerSQLMITaskProperties - Properties for task that validates migration input for SQL to Azure
// SQL Database Managed Instance
type ValidateMigrationInputSQLServerSQLMITaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Task input
	Input *ValidateMigrationInputSQLServerSQLMITaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ValidateMigrationInputSQLServerSQLMITaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ValidateMigrationInputSQLServerSQLMITaskProperties.
func (v *ValidateMigrationInputSQLServerSQLMITaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   v.TaskType,
		Errors:     v.Errors,
		State:      v.State,
		Commands:   v.Commands,
		ClientData: v.ClientData,
	}
}

// ValidateMongoDbTaskProperties - Properties for the task that validates a migration between MongoDB data sources
type ValidateMongoDbTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Describes how a MongoDB data migration should be performed
	Input *MongoDbMigrationSettings `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; An array containing a single MongoDbMigrationProgress object
	Output []*MongoDbMigrationProgress `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ValidateMongoDbTaskProperties.
func (v *ValidateMongoDbTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   v.TaskType,
		Errors:     v.Errors,
		State:      v.State,
		Commands:   v.Commands,
		ClientData: v.ClientData,
	}
}

// ValidateOracleAzureDbForPostgreSQLSyncTaskProperties - Properties for the task that validates a migration for Oracle to
// Azure Database for PostgreSQL for online migrations
type ValidateOracleAzureDbForPostgreSQLSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string `json:"taskType,omitempty"`

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData,omitempty"`

	// Input for the task that migrates Oracle databases to Azure Database for PostgreSQL for online migrations
	Input *MigrateOracleAzureDbPostgreSQLSyncTaskInput `json:"input,omitempty"`

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification `json:"commands,omitempty" azure:"ro"`

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; An array containing a single validation error response object
	Output []*ValidateOracleAzureDbPostgreSQLSyncTaskOutput `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState `json:"state,omitempty" azure:"ro"`
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ValidateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (v *ValidateOracleAzureDbForPostgreSQLSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		TaskType:   v.TaskType,
		Errors:     v.Errors,
		State:      v.State,
		Commands:   v.Commands,
		ClientData: v.ClientData,
	}
}

// ValidateOracleAzureDbPostgreSQLSyncTaskOutput - Output for task that validates migration input for Oracle to Azure Database
// for PostgreSQL for online migrations
type ValidateOracleAzureDbPostgreSQLSyncTaskOutput struct {
	// READ-ONLY; Errors associated with a selected database object
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// ValidateSyncMigrationInputSQLServerTaskInput - Input for task that validates migration input for SQL sync migrations
type ValidateSyncMigrationInputSQLServerTaskInput struct {
	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSQLServerSQLDbSyncDatabaseInput `json:"selectedDatabases,omitempty"`

	// REQUIRED; Information for connecting to source SQL server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ValidateSyncMigrationInputSQLServerTaskOutput - Output for task that validates migration input for SQL sync migrations
type ValidateSyncMigrationInputSQLServerTaskOutput struct {
	// READ-ONLY; Database identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of database
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Errors associated with a selected database object
	ValidationErrors []*ReportableException `json:"validationErrors,omitempty" azure:"ro"`
}

// ValidationError - Description about the errors happen while performing migration validation
type ValidationError struct {
	// Severity of the error
	Severity *Severity `json:"severity,omitempty"`

	// Error Text
	Text *string `json:"text,omitempty"`
}

// WaitStatistics - Wait statistics gathered during query batch execution
type WaitStatistics struct {
	// Total no. of waits
	WaitCount *int64 `json:"waitCount,omitempty"`

	// Total wait time in millisecond(s)
	WaitTimeMs *float32 `json:"waitTimeMs,omitempty"`

	// Type of the Wait
	WaitType *string `json:"waitType,omitempty"`
}
