//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
	"time"
)

// DiagnosticsClient contains the methods for the Diagnostics group.
// Don't use this type directly, use NewDiagnosticsClient() instead.
type DiagnosticsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewDiagnosticsClient creates a new instance of DiagnosticsClient with the specified values.
// subscriptionID - Your Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewDiagnosticsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DiagnosticsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &DiagnosticsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// ExecuteSiteAnalysis - Description for Execute Analysis
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// diagnosticCategory - Category Name
// analysisName - Analysis Resource Name
// options - DiagnosticsClientExecuteSiteAnalysisOptions contains the optional parameters for the DiagnosticsClient.ExecuteSiteAnalysis
// method.
func (client *DiagnosticsClient) ExecuteSiteAnalysis(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, options *DiagnosticsClientExecuteSiteAnalysisOptions) (DiagnosticsClientExecuteSiteAnalysisResponse, error) {
	req, err := client.executeSiteAnalysisCreateRequest(ctx, resourceGroupName, siteName, diagnosticCategory, analysisName, options)
	if err != nil {
		return DiagnosticsClientExecuteSiteAnalysisResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DiagnosticsClientExecuteSiteAnalysisResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DiagnosticsClientExecuteSiteAnalysisResponse{}, runtime.NewResponseError(resp)
	}
	return client.executeSiteAnalysisHandleResponse(resp)
}

// executeSiteAnalysisCreateRequest creates the ExecuteSiteAnalysis request.
func (client *DiagnosticsClient) executeSiteAnalysisCreateRequest(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, options *DiagnosticsClientExecuteSiteAnalysisOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if diagnosticCategory == "" {
		return nil, errors.New("parameter diagnosticCategory cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticCategory}", url.PathEscape(diagnosticCategory))
	if analysisName == "" {
		return nil, errors.New("parameter analysisName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{analysisName}", url.PathEscape(analysisName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.StartTime != nil {
		reqQP.Set("startTime", options.StartTime.Format(time.RFC3339Nano))
	}
	if options != nil && options.EndTime != nil {
		reqQP.Set("endTime", options.EndTime.Format(time.RFC3339Nano))
	}
	if options != nil && options.TimeGrain != nil {
		reqQP.Set("timeGrain", *options.TimeGrain)
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// executeSiteAnalysisHandleResponse handles the ExecuteSiteAnalysis response.
func (client *DiagnosticsClient) executeSiteAnalysisHandleResponse(resp *http.Response) (DiagnosticsClientExecuteSiteAnalysisResponse, error) {
	result := DiagnosticsClientExecuteSiteAnalysisResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DiagnosticAnalysis); err != nil {
		return DiagnosticsClientExecuteSiteAnalysisResponse{}, err
	}
	return result, nil
}

// ExecuteSiteAnalysisSlot - Description for Execute Analysis
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// diagnosticCategory - Category Name
// analysisName - Analysis Resource Name
// slot - Slot Name
// options - DiagnosticsClientExecuteSiteAnalysisSlotOptions contains the optional parameters for the DiagnosticsClient.ExecuteSiteAnalysisSlot
// method.
func (client *DiagnosticsClient) ExecuteSiteAnalysisSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string, options *DiagnosticsClientExecuteSiteAnalysisSlotOptions) (DiagnosticsClientExecuteSiteAnalysisSlotResponse, error) {
	req, err := client.executeSiteAnalysisSlotCreateRequest(ctx, resourceGroupName, siteName, diagnosticCategory, analysisName, slot, options)
	if err != nil {
		return DiagnosticsClientExecuteSiteAnalysisSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DiagnosticsClientExecuteSiteAnalysisSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DiagnosticsClientExecuteSiteAnalysisSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.executeSiteAnalysisSlotHandleResponse(resp)
}

// executeSiteAnalysisSlotCreateRequest creates the ExecuteSiteAnalysisSlot request.
func (client *DiagnosticsClient) executeSiteAnalysisSlotCreateRequest(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string, options *DiagnosticsClientExecuteSiteAnalysisSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if diagnosticCategory == "" {
		return nil, errors.New("parameter diagnosticCategory cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticCategory}", url.PathEscape(diagnosticCategory))
	if analysisName == "" {
		return nil, errors.New("parameter analysisName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{analysisName}", url.PathEscape(analysisName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.StartTime != nil {
		reqQP.Set("startTime", options.StartTime.Format(time.RFC3339Nano))
	}
	if options != nil && options.EndTime != nil {
		reqQP.Set("endTime", options.EndTime.Format(time.RFC3339Nano))
	}
	if options != nil && options.TimeGrain != nil {
		reqQP.Set("timeGrain", *options.TimeGrain)
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// executeSiteAnalysisSlotHandleResponse handles the ExecuteSiteAnalysisSlot response.
func (client *DiagnosticsClient) executeSiteAnalysisSlotHandleResponse(resp *http.Response) (DiagnosticsClientExecuteSiteAnalysisSlotResponse, error) {
	result := DiagnosticsClientExecuteSiteAnalysisSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DiagnosticAnalysis); err != nil {
		return DiagnosticsClientExecuteSiteAnalysisSlotResponse{}, err
	}
	return result, nil
}

// ExecuteSiteDetector - Description for Execute Detector
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// detectorName - Detector Resource Name
// diagnosticCategory - Category Name
// options - DiagnosticsClientExecuteSiteDetectorOptions contains the optional parameters for the DiagnosticsClient.ExecuteSiteDetector
// method.
func (client *DiagnosticsClient) ExecuteSiteDetector(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, options *DiagnosticsClientExecuteSiteDetectorOptions) (DiagnosticsClientExecuteSiteDetectorResponse, error) {
	req, err := client.executeSiteDetectorCreateRequest(ctx, resourceGroupName, siteName, detectorName, diagnosticCategory, options)
	if err != nil {
		return DiagnosticsClientExecuteSiteDetectorResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DiagnosticsClientExecuteSiteDetectorResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DiagnosticsClientExecuteSiteDetectorResponse{}, runtime.NewResponseError(resp)
	}
	return client.executeSiteDetectorHandleResponse(resp)
}

// executeSiteDetectorCreateRequest creates the ExecuteSiteDetector request.
func (client *DiagnosticsClient) executeSiteDetectorCreateRequest(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, options *DiagnosticsClientExecuteSiteDetectorOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if detectorName == "" {
		return nil, errors.New("parameter detectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{detectorName}", url.PathEscape(detectorName))
	if diagnosticCategory == "" {
		return nil, errors.New("parameter diagnosticCategory cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticCategory}", url.PathEscape(diagnosticCategory))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.StartTime != nil {
		reqQP.Set("startTime", options.StartTime.Format(time.RFC3339Nano))
	}
	if options != nil && options.EndTime != nil {
		reqQP.Set("endTime", options.EndTime.Format(time.RFC3339Nano))
	}
	if options != nil && options.TimeGrain != nil {
		reqQP.Set("timeGrain", *options.TimeGrain)
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// executeSiteDetectorHandleResponse handles the ExecuteSiteDetector response.
func (client *DiagnosticsClient) executeSiteDetectorHandleResponse(resp *http.Response) (DiagnosticsClientExecuteSiteDetectorResponse, error) {
	result := DiagnosticsClientExecuteSiteDetectorResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DiagnosticDetectorResponse); err != nil {
		return DiagnosticsClientExecuteSiteDetectorResponse{}, err
	}
	return result, nil
}

// ExecuteSiteDetectorSlot - Description for Execute Detector
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// detectorName - Detector Resource Name
// diagnosticCategory - Category Name
// slot - Slot Name
// options - DiagnosticsClientExecuteSiteDetectorSlotOptions contains the optional parameters for the DiagnosticsClient.ExecuteSiteDetectorSlot
// method.
func (client *DiagnosticsClient) ExecuteSiteDetectorSlot(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, slot string, options *DiagnosticsClientExecuteSiteDetectorSlotOptions) (DiagnosticsClientExecuteSiteDetectorSlotResponse, error) {
	req, err := client.executeSiteDetectorSlotCreateRequest(ctx, resourceGroupName, siteName, detectorName, diagnosticCategory, slot, options)
	if err != nil {
		return DiagnosticsClientExecuteSiteDetectorSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DiagnosticsClientExecuteSiteDetectorSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DiagnosticsClientExecuteSiteDetectorSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.executeSiteDetectorSlotHandleResponse(resp)
}

// executeSiteDetectorSlotCreateRequest creates the ExecuteSiteDetectorSlot request.
func (client *DiagnosticsClient) executeSiteDetectorSlotCreateRequest(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, slot string, options *DiagnosticsClientExecuteSiteDetectorSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if detectorName == "" {
		return nil, errors.New("parameter detectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{detectorName}", url.PathEscape(detectorName))
	if diagnosticCategory == "" {
		return nil, errors.New("parameter diagnosticCategory cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticCategory}", url.PathEscape(diagnosticCategory))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.StartTime != nil {
		reqQP.Set("startTime", options.StartTime.Format(time.RFC3339Nano))
	}
	if options != nil && options.EndTime != nil {
		reqQP.Set("endTime", options.EndTime.Format(time.RFC3339Nano))
	}
	if options != nil && options.TimeGrain != nil {
		reqQP.Set("timeGrain", *options.TimeGrain)
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// executeSiteDetectorSlotHandleResponse handles the ExecuteSiteDetectorSlot response.
func (client *DiagnosticsClient) executeSiteDetectorSlotHandleResponse(resp *http.Response) (DiagnosticsClientExecuteSiteDetectorSlotResponse, error) {
	result := DiagnosticsClientExecuteSiteDetectorSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DiagnosticDetectorResponse); err != nil {
		return DiagnosticsClientExecuteSiteDetectorSlotResponse{}, err
	}
	return result, nil
}

// GetHostingEnvironmentDetectorResponse - Description for Get Hosting Environment Detector Response
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - App Service Environment Name
// detectorName - Detector Resource Name
// options - DiagnosticsClientGetHostingEnvironmentDetectorResponseOptions contains the optional parameters for the DiagnosticsClient.GetHostingEnvironmentDetectorResponse
// method.
func (client *DiagnosticsClient) GetHostingEnvironmentDetectorResponse(ctx context.Context, resourceGroupName string, name string, detectorName string, options *DiagnosticsClientGetHostingEnvironmentDetectorResponseOptions) (DiagnosticsClientGetHostingEnvironmentDetectorResponseResponse, error) {
	req, err := client.getHostingEnvironmentDetectorResponseCreateRequest(ctx, resourceGroupName, name, detectorName, options)
	if err != nil {
		return DiagnosticsClientGetHostingEnvironmentDetectorResponseResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DiagnosticsClientGetHostingEnvironmentDetectorResponseResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DiagnosticsClientGetHostingEnvironmentDetectorResponseResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHostingEnvironmentDetectorResponseHandleResponse(resp)
}

// getHostingEnvironmentDetectorResponseCreateRequest creates the GetHostingEnvironmentDetectorResponse request.
func (client *DiagnosticsClient) getHostingEnvironmentDetectorResponseCreateRequest(ctx context.Context, resourceGroupName string, name string, detectorName string, options *DiagnosticsClientGetHostingEnvironmentDetectorResponseOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/detectors/{detectorName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if detectorName == "" {
		return nil, errors.New("parameter detectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{detectorName}", url.PathEscape(detectorName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.StartTime != nil {
		reqQP.Set("startTime", options.StartTime.Format(time.RFC3339Nano))
	}
	if options != nil && options.EndTime != nil {
		reqQP.Set("endTime", options.EndTime.Format(time.RFC3339Nano))
	}
	if options != nil && options.TimeGrain != nil {
		reqQP.Set("timeGrain", *options.TimeGrain)
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHostingEnvironmentDetectorResponseHandleResponse handles the GetHostingEnvironmentDetectorResponse response.
func (client *DiagnosticsClient) getHostingEnvironmentDetectorResponseHandleResponse(resp *http.Response) (DiagnosticsClientGetHostingEnvironmentDetectorResponseResponse, error) {
	result := DiagnosticsClientGetHostingEnvironmentDetectorResponseResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DetectorResponse); err != nil {
		return DiagnosticsClientGetHostingEnvironmentDetectorResponseResponse{}, err
	}
	return result, nil
}

// GetSiteAnalysis - Description for Get Site Analysis
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// diagnosticCategory - Diagnostic Category
// analysisName - Analysis Name
// options - DiagnosticsClientGetSiteAnalysisOptions contains the optional parameters for the DiagnosticsClient.GetSiteAnalysis
// method.
func (client *DiagnosticsClient) GetSiteAnalysis(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, options *DiagnosticsClientGetSiteAnalysisOptions) (DiagnosticsClientGetSiteAnalysisResponse, error) {
	req, err := client.getSiteAnalysisCreateRequest(ctx, resourceGroupName, siteName, diagnosticCategory, analysisName, options)
	if err != nil {
		return DiagnosticsClientGetSiteAnalysisResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DiagnosticsClientGetSiteAnalysisResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DiagnosticsClientGetSiteAnalysisResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSiteAnalysisHandleResponse(resp)
}

// getSiteAnalysisCreateRequest creates the GetSiteAnalysis request.
func (client *DiagnosticsClient) getSiteAnalysisCreateRequest(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, options *DiagnosticsClientGetSiteAnalysisOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if diagnosticCategory == "" {
		return nil, errors.New("parameter diagnosticCategory cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticCategory}", url.PathEscape(diagnosticCategory))
	if analysisName == "" {
		return nil, errors.New("parameter analysisName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{analysisName}", url.PathEscape(analysisName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSiteAnalysisHandleResponse handles the GetSiteAnalysis response.
func (client *DiagnosticsClient) getSiteAnalysisHandleResponse(resp *http.Response) (DiagnosticsClientGetSiteAnalysisResponse, error) {
	result := DiagnosticsClientGetSiteAnalysisResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AnalysisDefinition); err != nil {
		return DiagnosticsClientGetSiteAnalysisResponse{}, err
	}
	return result, nil
}

// GetSiteAnalysisSlot - Description for Get Site Analysis
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// diagnosticCategory - Diagnostic Category
// analysisName - Analysis Name
// slot - Slot - optional
// options - DiagnosticsClientGetSiteAnalysisSlotOptions contains the optional parameters for the DiagnosticsClient.GetSiteAnalysisSlot
// method.
func (client *DiagnosticsClient) GetSiteAnalysisSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string, options *DiagnosticsClientGetSiteAnalysisSlotOptions) (DiagnosticsClientGetSiteAnalysisSlotResponse, error) {
	req, err := client.getSiteAnalysisSlotCreateRequest(ctx, resourceGroupName, siteName, diagnosticCategory, analysisName, slot, options)
	if err != nil {
		return DiagnosticsClientGetSiteAnalysisSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DiagnosticsClientGetSiteAnalysisSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DiagnosticsClientGetSiteAnalysisSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSiteAnalysisSlotHandleResponse(resp)
}

// getSiteAnalysisSlotCreateRequest creates the GetSiteAnalysisSlot request.
func (client *DiagnosticsClient) getSiteAnalysisSlotCreateRequest(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string, options *DiagnosticsClientGetSiteAnalysisSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if diagnosticCategory == "" {
		return nil, errors.New("parameter diagnosticCategory cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticCategory}", url.PathEscape(diagnosticCategory))
	if analysisName == "" {
		return nil, errors.New("parameter analysisName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{analysisName}", url.PathEscape(analysisName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSiteAnalysisSlotHandleResponse handles the GetSiteAnalysisSlot response.
func (client *DiagnosticsClient) getSiteAnalysisSlotHandleResponse(resp *http.Response) (DiagnosticsClientGetSiteAnalysisSlotResponse, error) {
	result := DiagnosticsClientGetSiteAnalysisSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AnalysisDefinition); err != nil {
		return DiagnosticsClientGetSiteAnalysisSlotResponse{}, err
	}
	return result, nil
}

// GetSiteDetector - Description for Get Detector
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// diagnosticCategory - Diagnostic Category
// detectorName - Detector Name
// options - DiagnosticsClientGetSiteDetectorOptions contains the optional parameters for the DiagnosticsClient.GetSiteDetector
// method.
func (client *DiagnosticsClient) GetSiteDetector(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string, options *DiagnosticsClientGetSiteDetectorOptions) (DiagnosticsClientGetSiteDetectorResponse, error) {
	req, err := client.getSiteDetectorCreateRequest(ctx, resourceGroupName, siteName, diagnosticCategory, detectorName, options)
	if err != nil {
		return DiagnosticsClientGetSiteDetectorResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DiagnosticsClientGetSiteDetectorResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DiagnosticsClientGetSiteDetectorResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSiteDetectorHandleResponse(resp)
}

// getSiteDetectorCreateRequest creates the GetSiteDetector request.
func (client *DiagnosticsClient) getSiteDetectorCreateRequest(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string, options *DiagnosticsClientGetSiteDetectorOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if diagnosticCategory == "" {
		return nil, errors.New("parameter diagnosticCategory cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticCategory}", url.PathEscape(diagnosticCategory))
	if detectorName == "" {
		return nil, errors.New("parameter detectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{detectorName}", url.PathEscape(detectorName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSiteDetectorHandleResponse handles the GetSiteDetector response.
func (client *DiagnosticsClient) getSiteDetectorHandleResponse(resp *http.Response) (DiagnosticsClientGetSiteDetectorResponse, error) {
	result := DiagnosticsClientGetSiteDetectorResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DetectorDefinitionResource); err != nil {
		return DiagnosticsClientGetSiteDetectorResponse{}, err
	}
	return result, nil
}

// GetSiteDetectorResponse - Description for Get site detector response
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// detectorName - Detector Resource Name
// options - DiagnosticsClientGetSiteDetectorResponseOptions contains the optional parameters for the DiagnosticsClient.GetSiteDetectorResponse
// method.
func (client *DiagnosticsClient) GetSiteDetectorResponse(ctx context.Context, resourceGroupName string, siteName string, detectorName string, options *DiagnosticsClientGetSiteDetectorResponseOptions) (DiagnosticsClientGetSiteDetectorResponseResponse, error) {
	req, err := client.getSiteDetectorResponseCreateRequest(ctx, resourceGroupName, siteName, detectorName, options)
	if err != nil {
		return DiagnosticsClientGetSiteDetectorResponseResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DiagnosticsClientGetSiteDetectorResponseResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DiagnosticsClientGetSiteDetectorResponseResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSiteDetectorResponseHandleResponse(resp)
}

// getSiteDetectorResponseCreateRequest creates the GetSiteDetectorResponse request.
func (client *DiagnosticsClient) getSiteDetectorResponseCreateRequest(ctx context.Context, resourceGroupName string, siteName string, detectorName string, options *DiagnosticsClientGetSiteDetectorResponseOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/detectors/{detectorName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if detectorName == "" {
		return nil, errors.New("parameter detectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{detectorName}", url.PathEscape(detectorName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.StartTime != nil {
		reqQP.Set("startTime", options.StartTime.Format(time.RFC3339Nano))
	}
	if options != nil && options.EndTime != nil {
		reqQP.Set("endTime", options.EndTime.Format(time.RFC3339Nano))
	}
	if options != nil && options.TimeGrain != nil {
		reqQP.Set("timeGrain", *options.TimeGrain)
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSiteDetectorResponseHandleResponse handles the GetSiteDetectorResponse response.
func (client *DiagnosticsClient) getSiteDetectorResponseHandleResponse(resp *http.Response) (DiagnosticsClientGetSiteDetectorResponseResponse, error) {
	result := DiagnosticsClientGetSiteDetectorResponseResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DetectorResponse); err != nil {
		return DiagnosticsClientGetSiteDetectorResponseResponse{}, err
	}
	return result, nil
}

// GetSiteDetectorResponseSlot - Description for Get site detector response
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// detectorName - Detector Resource Name
// slot - Slot Name
// options - DiagnosticsClientGetSiteDetectorResponseSlotOptions contains the optional parameters for the DiagnosticsClient.GetSiteDetectorResponseSlot
// method.
func (client *DiagnosticsClient) GetSiteDetectorResponseSlot(ctx context.Context, resourceGroupName string, siteName string, detectorName string, slot string, options *DiagnosticsClientGetSiteDetectorResponseSlotOptions) (DiagnosticsClientGetSiteDetectorResponseSlotResponse, error) {
	req, err := client.getSiteDetectorResponseSlotCreateRequest(ctx, resourceGroupName, siteName, detectorName, slot, options)
	if err != nil {
		return DiagnosticsClientGetSiteDetectorResponseSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DiagnosticsClientGetSiteDetectorResponseSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DiagnosticsClientGetSiteDetectorResponseSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSiteDetectorResponseSlotHandleResponse(resp)
}

// getSiteDetectorResponseSlotCreateRequest creates the GetSiteDetectorResponseSlot request.
func (client *DiagnosticsClient) getSiteDetectorResponseSlotCreateRequest(ctx context.Context, resourceGroupName string, siteName string, detectorName string, slot string, options *DiagnosticsClientGetSiteDetectorResponseSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/detectors/{detectorName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if detectorName == "" {
		return nil, errors.New("parameter detectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{detectorName}", url.PathEscape(detectorName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.StartTime != nil {
		reqQP.Set("startTime", options.StartTime.Format(time.RFC3339Nano))
	}
	if options != nil && options.EndTime != nil {
		reqQP.Set("endTime", options.EndTime.Format(time.RFC3339Nano))
	}
	if options != nil && options.TimeGrain != nil {
		reqQP.Set("timeGrain", *options.TimeGrain)
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSiteDetectorResponseSlotHandleResponse handles the GetSiteDetectorResponseSlot response.
func (client *DiagnosticsClient) getSiteDetectorResponseSlotHandleResponse(resp *http.Response) (DiagnosticsClientGetSiteDetectorResponseSlotResponse, error) {
	result := DiagnosticsClientGetSiteDetectorResponseSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DetectorResponse); err != nil {
		return DiagnosticsClientGetSiteDetectorResponseSlotResponse{}, err
	}
	return result, nil
}

// GetSiteDetectorSlot - Description for Get Detector
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// diagnosticCategory - Diagnostic Category
// detectorName - Detector Name
// slot - Slot Name
// options - DiagnosticsClientGetSiteDetectorSlotOptions contains the optional parameters for the DiagnosticsClient.GetSiteDetectorSlot
// method.
func (client *DiagnosticsClient) GetSiteDetectorSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string, slot string, options *DiagnosticsClientGetSiteDetectorSlotOptions) (DiagnosticsClientGetSiteDetectorSlotResponse, error) {
	req, err := client.getSiteDetectorSlotCreateRequest(ctx, resourceGroupName, siteName, diagnosticCategory, detectorName, slot, options)
	if err != nil {
		return DiagnosticsClientGetSiteDetectorSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DiagnosticsClientGetSiteDetectorSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DiagnosticsClientGetSiteDetectorSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSiteDetectorSlotHandleResponse(resp)
}

// getSiteDetectorSlotCreateRequest creates the GetSiteDetectorSlot request.
func (client *DiagnosticsClient) getSiteDetectorSlotCreateRequest(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string, slot string, options *DiagnosticsClientGetSiteDetectorSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if diagnosticCategory == "" {
		return nil, errors.New("parameter diagnosticCategory cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticCategory}", url.PathEscape(diagnosticCategory))
	if detectorName == "" {
		return nil, errors.New("parameter detectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{detectorName}", url.PathEscape(detectorName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSiteDetectorSlotHandleResponse handles the GetSiteDetectorSlot response.
func (client *DiagnosticsClient) getSiteDetectorSlotHandleResponse(resp *http.Response) (DiagnosticsClientGetSiteDetectorSlotResponse, error) {
	result := DiagnosticsClientGetSiteDetectorSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DetectorDefinitionResource); err != nil {
		return DiagnosticsClientGetSiteDetectorSlotResponse{}, err
	}
	return result, nil
}

// GetSiteDiagnosticCategory - Description for Get Diagnostics Category
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// diagnosticCategory - Diagnostic Category
// options - DiagnosticsClientGetSiteDiagnosticCategoryOptions contains the optional parameters for the DiagnosticsClient.GetSiteDiagnosticCategory
// method.
func (client *DiagnosticsClient) GetSiteDiagnosticCategory(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, options *DiagnosticsClientGetSiteDiagnosticCategoryOptions) (DiagnosticsClientGetSiteDiagnosticCategoryResponse, error) {
	req, err := client.getSiteDiagnosticCategoryCreateRequest(ctx, resourceGroupName, siteName, diagnosticCategory, options)
	if err != nil {
		return DiagnosticsClientGetSiteDiagnosticCategoryResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DiagnosticsClientGetSiteDiagnosticCategoryResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DiagnosticsClientGetSiteDiagnosticCategoryResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSiteDiagnosticCategoryHandleResponse(resp)
}

// getSiteDiagnosticCategoryCreateRequest creates the GetSiteDiagnosticCategory request.
func (client *DiagnosticsClient) getSiteDiagnosticCategoryCreateRequest(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, options *DiagnosticsClientGetSiteDiagnosticCategoryOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if diagnosticCategory == "" {
		return nil, errors.New("parameter diagnosticCategory cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticCategory}", url.PathEscape(diagnosticCategory))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSiteDiagnosticCategoryHandleResponse handles the GetSiteDiagnosticCategory response.
func (client *DiagnosticsClient) getSiteDiagnosticCategoryHandleResponse(resp *http.Response) (DiagnosticsClientGetSiteDiagnosticCategoryResponse, error) {
	result := DiagnosticsClientGetSiteDiagnosticCategoryResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DiagnosticCategory); err != nil {
		return DiagnosticsClientGetSiteDiagnosticCategoryResponse{}, err
	}
	return result, nil
}

// GetSiteDiagnosticCategorySlot - Description for Get Diagnostics Category
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// diagnosticCategory - Diagnostic Category
// slot - Slot Name
// options - DiagnosticsClientGetSiteDiagnosticCategorySlotOptions contains the optional parameters for the DiagnosticsClient.GetSiteDiagnosticCategorySlot
// method.
func (client *DiagnosticsClient) GetSiteDiagnosticCategorySlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string, options *DiagnosticsClientGetSiteDiagnosticCategorySlotOptions) (DiagnosticsClientGetSiteDiagnosticCategorySlotResponse, error) {
	req, err := client.getSiteDiagnosticCategorySlotCreateRequest(ctx, resourceGroupName, siteName, diagnosticCategory, slot, options)
	if err != nil {
		return DiagnosticsClientGetSiteDiagnosticCategorySlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DiagnosticsClientGetSiteDiagnosticCategorySlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DiagnosticsClientGetSiteDiagnosticCategorySlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSiteDiagnosticCategorySlotHandleResponse(resp)
}

// getSiteDiagnosticCategorySlotCreateRequest creates the GetSiteDiagnosticCategorySlot request.
func (client *DiagnosticsClient) getSiteDiagnosticCategorySlotCreateRequest(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string, options *DiagnosticsClientGetSiteDiagnosticCategorySlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if diagnosticCategory == "" {
		return nil, errors.New("parameter diagnosticCategory cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticCategory}", url.PathEscape(diagnosticCategory))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSiteDiagnosticCategorySlotHandleResponse handles the GetSiteDiagnosticCategorySlot response.
func (client *DiagnosticsClient) getSiteDiagnosticCategorySlotHandleResponse(resp *http.Response) (DiagnosticsClientGetSiteDiagnosticCategorySlotResponse, error) {
	result := DiagnosticsClientGetSiteDiagnosticCategorySlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DiagnosticCategory); err != nil {
		return DiagnosticsClientGetSiteDiagnosticCategorySlotResponse{}, err
	}
	return result, nil
}

// NewListHostingEnvironmentDetectorResponsesPager - Description for List Hosting Environment Detector Responses
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site Name
// options - DiagnosticsClientListHostingEnvironmentDetectorResponsesOptions contains the optional parameters for the DiagnosticsClient.ListHostingEnvironmentDetectorResponses
// method.
func (client *DiagnosticsClient) NewListHostingEnvironmentDetectorResponsesPager(resourceGroupName string, name string, options *DiagnosticsClientListHostingEnvironmentDetectorResponsesOptions) *runtime.Pager[DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse] {
	return runtime.NewPager(runtime.PagingHandler[DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse]{
		More: func(page DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse) (DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listHostingEnvironmentDetectorResponsesCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHostingEnvironmentDetectorResponsesHandleResponse(resp)
		},
	})
}

// listHostingEnvironmentDetectorResponsesCreateRequest creates the ListHostingEnvironmentDetectorResponses request.
func (client *DiagnosticsClient) listHostingEnvironmentDetectorResponsesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *DiagnosticsClientListHostingEnvironmentDetectorResponsesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/detectors"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHostingEnvironmentDetectorResponsesHandleResponse handles the ListHostingEnvironmentDetectorResponses response.
func (client *DiagnosticsClient) listHostingEnvironmentDetectorResponsesHandleResponse(resp *http.Response) (DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse, error) {
	result := DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DetectorResponseCollection); err != nil {
		return DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse{}, err
	}
	return result, nil
}

// NewListSiteAnalysesPager - Description for Get Site Analyses
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// diagnosticCategory - Diagnostic Category
// options - DiagnosticsClientListSiteAnalysesOptions contains the optional parameters for the DiagnosticsClient.ListSiteAnalyses
// method.
func (client *DiagnosticsClient) NewListSiteAnalysesPager(resourceGroupName string, siteName string, diagnosticCategory string, options *DiagnosticsClientListSiteAnalysesOptions) *runtime.Pager[DiagnosticsClientListSiteAnalysesResponse] {
	return runtime.NewPager(runtime.PagingHandler[DiagnosticsClientListSiteAnalysesResponse]{
		More: func(page DiagnosticsClientListSiteAnalysesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DiagnosticsClientListSiteAnalysesResponse) (DiagnosticsClientListSiteAnalysesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSiteAnalysesCreateRequest(ctx, resourceGroupName, siteName, diagnosticCategory, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return DiagnosticsClientListSiteAnalysesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DiagnosticsClientListSiteAnalysesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DiagnosticsClientListSiteAnalysesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSiteAnalysesHandleResponse(resp)
		},
	})
}

// listSiteAnalysesCreateRequest creates the ListSiteAnalyses request.
func (client *DiagnosticsClient) listSiteAnalysesCreateRequest(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, options *DiagnosticsClientListSiteAnalysesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if diagnosticCategory == "" {
		return nil, errors.New("parameter diagnosticCategory cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticCategory}", url.PathEscape(diagnosticCategory))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSiteAnalysesHandleResponse handles the ListSiteAnalyses response.
func (client *DiagnosticsClient) listSiteAnalysesHandleResponse(resp *http.Response) (DiagnosticsClientListSiteAnalysesResponse, error) {
	result := DiagnosticsClientListSiteAnalysesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DiagnosticAnalysisCollection); err != nil {
		return DiagnosticsClientListSiteAnalysesResponse{}, err
	}
	return result, nil
}

// NewListSiteAnalysesSlotPager - Description for Get Site Analyses
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// diagnosticCategory - Diagnostic Category
// slot - Slot Name
// options - DiagnosticsClientListSiteAnalysesSlotOptions contains the optional parameters for the DiagnosticsClient.ListSiteAnalysesSlot
// method.
func (client *DiagnosticsClient) NewListSiteAnalysesSlotPager(resourceGroupName string, siteName string, diagnosticCategory string, slot string, options *DiagnosticsClientListSiteAnalysesSlotOptions) *runtime.Pager[DiagnosticsClientListSiteAnalysesSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[DiagnosticsClientListSiteAnalysesSlotResponse]{
		More: func(page DiagnosticsClientListSiteAnalysesSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DiagnosticsClientListSiteAnalysesSlotResponse) (DiagnosticsClientListSiteAnalysesSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSiteAnalysesSlotCreateRequest(ctx, resourceGroupName, siteName, diagnosticCategory, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return DiagnosticsClientListSiteAnalysesSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DiagnosticsClientListSiteAnalysesSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DiagnosticsClientListSiteAnalysesSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSiteAnalysesSlotHandleResponse(resp)
		},
	})
}

// listSiteAnalysesSlotCreateRequest creates the ListSiteAnalysesSlot request.
func (client *DiagnosticsClient) listSiteAnalysesSlotCreateRequest(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string, options *DiagnosticsClientListSiteAnalysesSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if diagnosticCategory == "" {
		return nil, errors.New("parameter diagnosticCategory cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticCategory}", url.PathEscape(diagnosticCategory))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSiteAnalysesSlotHandleResponse handles the ListSiteAnalysesSlot response.
func (client *DiagnosticsClient) listSiteAnalysesSlotHandleResponse(resp *http.Response) (DiagnosticsClientListSiteAnalysesSlotResponse, error) {
	result := DiagnosticsClientListSiteAnalysesSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DiagnosticAnalysisCollection); err != nil {
		return DiagnosticsClientListSiteAnalysesSlotResponse{}, err
	}
	return result, nil
}

// NewListSiteDetectorResponsesPager - Description for List Site Detector Responses
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// options - DiagnosticsClientListSiteDetectorResponsesOptions contains the optional parameters for the DiagnosticsClient.ListSiteDetectorResponses
// method.
func (client *DiagnosticsClient) NewListSiteDetectorResponsesPager(resourceGroupName string, siteName string, options *DiagnosticsClientListSiteDetectorResponsesOptions) *runtime.Pager[DiagnosticsClientListSiteDetectorResponsesResponse] {
	return runtime.NewPager(runtime.PagingHandler[DiagnosticsClientListSiteDetectorResponsesResponse]{
		More: func(page DiagnosticsClientListSiteDetectorResponsesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DiagnosticsClientListSiteDetectorResponsesResponse) (DiagnosticsClientListSiteDetectorResponsesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSiteDetectorResponsesCreateRequest(ctx, resourceGroupName, siteName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return DiagnosticsClientListSiteDetectorResponsesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DiagnosticsClientListSiteDetectorResponsesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DiagnosticsClientListSiteDetectorResponsesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSiteDetectorResponsesHandleResponse(resp)
		},
	})
}

// listSiteDetectorResponsesCreateRequest creates the ListSiteDetectorResponses request.
func (client *DiagnosticsClient) listSiteDetectorResponsesCreateRequest(ctx context.Context, resourceGroupName string, siteName string, options *DiagnosticsClientListSiteDetectorResponsesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/detectors"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSiteDetectorResponsesHandleResponse handles the ListSiteDetectorResponses response.
func (client *DiagnosticsClient) listSiteDetectorResponsesHandleResponse(resp *http.Response) (DiagnosticsClientListSiteDetectorResponsesResponse, error) {
	result := DiagnosticsClientListSiteDetectorResponsesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DetectorResponseCollection); err != nil {
		return DiagnosticsClientListSiteDetectorResponsesResponse{}, err
	}
	return result, nil
}

// NewListSiteDetectorResponsesSlotPager - Description for List Site Detector Responses
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// slot - Slot Name
// options - DiagnosticsClientListSiteDetectorResponsesSlotOptions contains the optional parameters for the DiagnosticsClient.ListSiteDetectorResponsesSlot
// method.
func (client *DiagnosticsClient) NewListSiteDetectorResponsesSlotPager(resourceGroupName string, siteName string, slot string, options *DiagnosticsClientListSiteDetectorResponsesSlotOptions) *runtime.Pager[DiagnosticsClientListSiteDetectorResponsesSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[DiagnosticsClientListSiteDetectorResponsesSlotResponse]{
		More: func(page DiagnosticsClientListSiteDetectorResponsesSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DiagnosticsClientListSiteDetectorResponsesSlotResponse) (DiagnosticsClientListSiteDetectorResponsesSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSiteDetectorResponsesSlotCreateRequest(ctx, resourceGroupName, siteName, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return DiagnosticsClientListSiteDetectorResponsesSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DiagnosticsClientListSiteDetectorResponsesSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DiagnosticsClientListSiteDetectorResponsesSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSiteDetectorResponsesSlotHandleResponse(resp)
		},
	})
}

// listSiteDetectorResponsesSlotCreateRequest creates the ListSiteDetectorResponsesSlot request.
func (client *DiagnosticsClient) listSiteDetectorResponsesSlotCreateRequest(ctx context.Context, resourceGroupName string, siteName string, slot string, options *DiagnosticsClientListSiteDetectorResponsesSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/detectors"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSiteDetectorResponsesSlotHandleResponse handles the ListSiteDetectorResponsesSlot response.
func (client *DiagnosticsClient) listSiteDetectorResponsesSlotHandleResponse(resp *http.Response) (DiagnosticsClientListSiteDetectorResponsesSlotResponse, error) {
	result := DiagnosticsClientListSiteDetectorResponsesSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DetectorResponseCollection); err != nil {
		return DiagnosticsClientListSiteDetectorResponsesSlotResponse{}, err
	}
	return result, nil
}

// NewListSiteDetectorsPager - Description for Get Detectors
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// diagnosticCategory - Diagnostic Category
// options - DiagnosticsClientListSiteDetectorsOptions contains the optional parameters for the DiagnosticsClient.ListSiteDetectors
// method.
func (client *DiagnosticsClient) NewListSiteDetectorsPager(resourceGroupName string, siteName string, diagnosticCategory string, options *DiagnosticsClientListSiteDetectorsOptions) *runtime.Pager[DiagnosticsClientListSiteDetectorsResponse] {
	return runtime.NewPager(runtime.PagingHandler[DiagnosticsClientListSiteDetectorsResponse]{
		More: func(page DiagnosticsClientListSiteDetectorsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DiagnosticsClientListSiteDetectorsResponse) (DiagnosticsClientListSiteDetectorsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSiteDetectorsCreateRequest(ctx, resourceGroupName, siteName, diagnosticCategory, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return DiagnosticsClientListSiteDetectorsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DiagnosticsClientListSiteDetectorsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DiagnosticsClientListSiteDetectorsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSiteDetectorsHandleResponse(resp)
		},
	})
}

// listSiteDetectorsCreateRequest creates the ListSiteDetectors request.
func (client *DiagnosticsClient) listSiteDetectorsCreateRequest(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, options *DiagnosticsClientListSiteDetectorsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if diagnosticCategory == "" {
		return nil, errors.New("parameter diagnosticCategory cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticCategory}", url.PathEscape(diagnosticCategory))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSiteDetectorsHandleResponse handles the ListSiteDetectors response.
func (client *DiagnosticsClient) listSiteDetectorsHandleResponse(resp *http.Response) (DiagnosticsClientListSiteDetectorsResponse, error) {
	result := DiagnosticsClientListSiteDetectorsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DiagnosticDetectorCollection); err != nil {
		return DiagnosticsClientListSiteDetectorsResponse{}, err
	}
	return result, nil
}

// NewListSiteDetectorsSlotPager - Description for Get Detectors
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// diagnosticCategory - Diagnostic Category
// slot - Slot Name
// options - DiagnosticsClientListSiteDetectorsSlotOptions contains the optional parameters for the DiagnosticsClient.ListSiteDetectorsSlot
// method.
func (client *DiagnosticsClient) NewListSiteDetectorsSlotPager(resourceGroupName string, siteName string, diagnosticCategory string, slot string, options *DiagnosticsClientListSiteDetectorsSlotOptions) *runtime.Pager[DiagnosticsClientListSiteDetectorsSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[DiagnosticsClientListSiteDetectorsSlotResponse]{
		More: func(page DiagnosticsClientListSiteDetectorsSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DiagnosticsClientListSiteDetectorsSlotResponse) (DiagnosticsClientListSiteDetectorsSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSiteDetectorsSlotCreateRequest(ctx, resourceGroupName, siteName, diagnosticCategory, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return DiagnosticsClientListSiteDetectorsSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DiagnosticsClientListSiteDetectorsSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DiagnosticsClientListSiteDetectorsSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSiteDetectorsSlotHandleResponse(resp)
		},
	})
}

// listSiteDetectorsSlotCreateRequest creates the ListSiteDetectorsSlot request.
func (client *DiagnosticsClient) listSiteDetectorsSlotCreateRequest(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string, options *DiagnosticsClientListSiteDetectorsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if diagnosticCategory == "" {
		return nil, errors.New("parameter diagnosticCategory cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticCategory}", url.PathEscape(diagnosticCategory))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSiteDetectorsSlotHandleResponse handles the ListSiteDetectorsSlot response.
func (client *DiagnosticsClient) listSiteDetectorsSlotHandleResponse(resp *http.Response) (DiagnosticsClientListSiteDetectorsSlotResponse, error) {
	result := DiagnosticsClientListSiteDetectorsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DiagnosticDetectorCollection); err != nil {
		return DiagnosticsClientListSiteDetectorsSlotResponse{}, err
	}
	return result, nil
}

// NewListSiteDiagnosticCategoriesPager - Description for Get Diagnostics Categories
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// options - DiagnosticsClientListSiteDiagnosticCategoriesOptions contains the optional parameters for the DiagnosticsClient.ListSiteDiagnosticCategories
// method.
func (client *DiagnosticsClient) NewListSiteDiagnosticCategoriesPager(resourceGroupName string, siteName string, options *DiagnosticsClientListSiteDiagnosticCategoriesOptions) *runtime.Pager[DiagnosticsClientListSiteDiagnosticCategoriesResponse] {
	return runtime.NewPager(runtime.PagingHandler[DiagnosticsClientListSiteDiagnosticCategoriesResponse]{
		More: func(page DiagnosticsClientListSiteDiagnosticCategoriesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DiagnosticsClientListSiteDiagnosticCategoriesResponse) (DiagnosticsClientListSiteDiagnosticCategoriesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSiteDiagnosticCategoriesCreateRequest(ctx, resourceGroupName, siteName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return DiagnosticsClientListSiteDiagnosticCategoriesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DiagnosticsClientListSiteDiagnosticCategoriesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DiagnosticsClientListSiteDiagnosticCategoriesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSiteDiagnosticCategoriesHandleResponse(resp)
		},
	})
}

// listSiteDiagnosticCategoriesCreateRequest creates the ListSiteDiagnosticCategories request.
func (client *DiagnosticsClient) listSiteDiagnosticCategoriesCreateRequest(ctx context.Context, resourceGroupName string, siteName string, options *DiagnosticsClientListSiteDiagnosticCategoriesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSiteDiagnosticCategoriesHandleResponse handles the ListSiteDiagnosticCategories response.
func (client *DiagnosticsClient) listSiteDiagnosticCategoriesHandleResponse(resp *http.Response) (DiagnosticsClientListSiteDiagnosticCategoriesResponse, error) {
	result := DiagnosticsClientListSiteDiagnosticCategoriesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DiagnosticCategoryCollection); err != nil {
		return DiagnosticsClientListSiteDiagnosticCategoriesResponse{}, err
	}
	return result, nil
}

// NewListSiteDiagnosticCategoriesSlotPager - Description for Get Diagnostics Categories
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site Name
// slot - Slot Name
// options - DiagnosticsClientListSiteDiagnosticCategoriesSlotOptions contains the optional parameters for the DiagnosticsClient.ListSiteDiagnosticCategoriesSlot
// method.
func (client *DiagnosticsClient) NewListSiteDiagnosticCategoriesSlotPager(resourceGroupName string, siteName string, slot string, options *DiagnosticsClientListSiteDiagnosticCategoriesSlotOptions) *runtime.Pager[DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse]{
		More: func(page DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse) (DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSiteDiagnosticCategoriesSlotCreateRequest(ctx, resourceGroupName, siteName, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSiteDiagnosticCategoriesSlotHandleResponse(resp)
		},
	})
}

// listSiteDiagnosticCategoriesSlotCreateRequest creates the ListSiteDiagnosticCategoriesSlot request.
func (client *DiagnosticsClient) listSiteDiagnosticCategoriesSlotCreateRequest(ctx context.Context, resourceGroupName string, siteName string, slot string, options *DiagnosticsClientListSiteDiagnosticCategoriesSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSiteDiagnosticCategoriesSlotHandleResponse handles the ListSiteDiagnosticCategoriesSlot response.
func (client *DiagnosticsClient) listSiteDiagnosticCategoriesSlotHandleResponse(resp *http.Response) (DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse, error) {
	result := DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DiagnosticCategoryCollection); err != nil {
		return DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse{}, err
	}
	return result, nil
}
