#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Musical Story
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250707.3

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='a-musical-story'
GAME_NAME='A Musical Story'

ARCHIVE_BASE_0_NAME='a_musical_story_1_0_5_53408.sh'
ARCHIVE_BASE_0_MD5='028d274ff2f597d5fb5ed0116bee990a'
ARCHIVE_BASE_0_SIZE='2400000'
ARCHIVE_BASE_0_VERSION='1.0.5-gog53408'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/'

UNITY3D_NAME='MusicalStory'
UNITY3D_PLUGINS='
libAkSoundEngine.so
libEOSSDK-Linux-Shipping.so'
## Without the Steam library, the game menu
## is never displayed after the introduction logos.
UNITY3D_PLUGINS="$UNITY3D_PLUGINS
libsteam_api.so"

CONTENT_PATH_DEFAULT='data/noarch/game'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libstdc++.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Work around the game engine PulseAudio requirement.
game_exec_line() {
	local application
	application="$1"

	local application_options
	application_options=$(application_options "$application")
	cat <<- EOF
	# Work around the game engine PulseAudio requirement.
	if
	    ! command -v pulseaudio >/dev/null 2>&1 &&
	    command -v apulse >/dev/null 2>&1
	then
	    apulse ./MusicalStory.x86_64 $application_options "\$@"
	else
	    ./MusicalStory.x86_64 $application_options "\$@"
	fi
	EOF
}

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
