!--
!----------------------------------------------------------------------
!     Copyright (c) 2002-2009 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  lumatrix :  LU ʬˤϢΩβ
!
!      spml/lumatrix ⥸塼, LU ʬˡˤϢΩ 1 򤯤
!      Fortran90 ؿ󶡤. 
!
!      ¾Υڥȥ׻ѥ⥸塼о줹붭򤯤
!      ѤƤ. 
!
!      ׻ռ, ƱʣĤϢΩ1  
!
!          A[ij]^(n) X [j]^(n) = B[i]^(n) 
!
!      βƱʣĤαե٥ȥ B[i]^(n)b ФƵ뤳Ȥ
!      Ǥ褦ˤʤäƤ.
!
!
!  2002/01/20  ݹ
!      2002/06/10  ݹ  ٥ȥĹΤ lusol2 
!      2005/01/10  ݹ  msgdmp -> MessageNotify ѹ
!      2006/03/04  ݹ  Ȥ RDoc Ѥ˽
!      2009/01/29  ʿ  Ȥ RDoc Ѥ˽
!      2009/08/06  ݹ    ludecomp21 ѥ롼 OMP ѹ
!      2010/03/17  ݹ    Lapack Ǻ
!
! * ɥȤϸȾ module ˵
!++
subroutine ludecomp21(alu,kp)
  !
  ! ALU(NDIM,NDIM), KP(NDIM)
  ! NDIM x NDIM ι LU ʬ.
  ! ̣չ Ϲ˾񤭤.
  !
  use dc_message
  
  real(8), intent(inout) :: alu(:,:)                  ! ϡ̣չ
  integer, intent(out)   :: kp(size(alu,2))           ! ԥܥå
  integer  :: icon
  integer  :: kk, nn
  
  kk = size(alu,1) ;  nn = size(alu,2)

  if ( kk /= nn ) then
     call MessageNotify('E','ludecomp21',&
          'The first dimension differs from the second')
  endif
  
  !" Σ̣ʬ
  call dgetrf( nn, nn, alu, nn, kp, icon )
  if ( icon /= 0 ) &
       call MessageNotify('E','ludecomp21','LU decompostion not succeeded.')

end subroutine ludecomp21

subroutine ludecomp32(alu,kp)
  !
  ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM)
  ! NDIM x NDIM ι JDIM Ĥ٤ LU ʬ.
  ! ̣չ Ϲ˾񤭤.
  !
  use dc_message
  
  real(8), intent(inout) :: alu(:,:,:)                  ! ϡ̣չ
  integer, intent(out)   :: kp(size(alu,1),size(alu,3)) ! ԥܥå

  integer :: icon
  integer :: jj, kk, nn
  integer :: j
  
  jj = size(alu,1) ; kk = size(alu,2) ;  nn = size(alu,3)
  
  if ( kk /= nn ) then
     call MessageNotify('E','ludecomp32',&
          'The second dimension differs from the third')
  endif
 
 !" Σ̣ʬʥ饦ˡ
!$omp parallel do private(icon)
  do j=1,jj
     call dgetrf( nn, nn, alu(j,:,:), nn, kp(j,:), icon )
     if ( icon /= 0 ) &
          call MessageNotify('E','ludecomp32','LU decompostion not succeeded.')
  end do
!$omp end parallel do
  
end subroutine ludecomp32

function lusolve211(alu,kp,b)
  !
  ! ALU(NDIM,NDIM), KP(NDIM), B(NDIM)
  ! NDIM x NDIM ϢΩ
  ! A X = B  1 Ĥ B ФƷ׻. 
  !
  use dc_message
  
  real(8), intent(in)  :: alu(:,:)              ! ϡ̣չ
  integer, intent(in)  :: kp(:)                 ! ԥܥå
  real(8), intent(in)  :: b(:)                  ! ե٥ȥ
  
  real(8) :: lusolve211(size(b))                ! 
  integer :: kk, nn

  kk = size(alu,1) ;  nn = size(alu,2)

  if ( kk /= nn ) then
     call MessageNotify('E','ludsolve211',&
          'The first dimension is greater than the second')
  elseif ( nn /= size(b)) then
     call MessageNotify('E','lusolve211', &
          'The input vector length differs from the second dimension of the matrix')
  endif

  lusolve211 = b
  call dgetrs( 'N', nn, 1, alu, nn, kp, lusolve211, nn, icon )
  if ( icon /= 0 ) &
       call MessageNotify('E','lusplve211','LU decompostion not succeeded.')

end function lusolve211

function lusolve212(alu,kp,b)
  !
  ! ALU(NDIM,NDIM), KP(NDIM), B(JDIM,NDIM)
  ! NDIM x NDIM ϢΩ
  ! A X = B  JDIM Ĥ B ФƷ׻. 
  !
  use dc_message
  
  real(8), intent(in)  :: alu(:,:)              ! ϡ̣չ
  integer, intent(in)  :: kp(:)                 ! ԥܥå
  real(8), intent(in)  :: b(:,:)                ! ե٥ȥ
  
  real(8) :: lusolve212(size(b,1),size(b,2))       ! 

  integer :: kk, nn
  integer :: j
  
  kk = size(alu,1) ;  nn = size(alu,2)

  if ( kk /= nn ) then
     call MessageNotify('E','ludsolve212',&
          'The first dimension differs from the second')
  elseif ( nn /= size(b,2)) then
     call MessageNotify('E','lusolvep212', &
          'The vector length differs from the second dimension of the matrix')
  endif

  lusolve212 = b

!$omp parallel do private(icon)
  do j=1,size(b,1)
     call dgetrs( 'N', nn, 1, alu, nn, kp, lusolve212(j,:), nn, icon )
     if ( icon /= 0 ) &
          call MessageNotify('E','lusplve212','LU decompostion not succeeded.')
  enddo

end function lusolve212

function lusolve322(alu,kp,b)
  !
  ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM), B(JDIM,NDIM)
  ! NDIM x NDIM  JDIM ¤٤ϢΩ
  ! A X = B ҤȤĤ B ¤ӤФƷ׻. 
  !
  use dc_message
  
  real(8), intent(in)  :: alu(:,:,:)                   ! ϡ̣չ
  integer, intent(in)  :: kp(:,:)                      ! ԥܥå
  real(8), intent(in)  :: b(:,:)                       ! ե٥ȥ
  
  real(8) :: lusolve322(size(b,1),size(b,2))             ! 

  integer  :: jj, kk, nn
  integer  :: j

  jj = size(alu,1) ; kk = size(alu,2) ;  nn = size(alu,3)
  
  if ( kk /= nn ) then
     call MessageNotify('E','ludsolve322',&
          'The second dimension differs from the third')
  elseif ( nn /= size(b,2)) then
     call MessageNotify('E','lusolvep322', &
          'The vector length differs from the second dimension of the matrix')
  endif

  lusolve322 = b
 
!$omp parallel do private(icon)
  do j=1,jj
     call dgetrs( 'N', nn, 1, alu(j,:,:), nn, kp(j,:), lusolve322(j,:), nn, icon )
     if ( icon /= 0 ) &
          call MessageNotify('E','lusplve322','LU decompostion not succeeded.')
  end do
!$omp end parallel do
  
end function lusolve322

function lusolve323(alu,kp,b)
  !
  ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM), B(IDIM,JDIM,NDIM)
  ! NDIM x NDIM  JDIM ¤٤ϢΩ
  ! A X = B  IDIM Ĥ B ФƷ׻. 
  !
  use dc_message
  
  real(8), intent(in)  :: alu(:,:,:)                   ! ϡ̣չ
  integer, intent(in)  :: kp(:,:)                      ! ԥܥå
  real(8), intent(in)  :: b(:,:,:)                     ! ե٥ȥ
  
  real(8) :: lusolve323(size(b,1),size(b,2),size(b,3)) ! 

  integer  :: jj, kk, nn
  integer  :: i, j

  jj = size(alu,1) ; kk = size(alu,2) ;  nn = size(alu,3)
  

  if ( kk /= nn ) then
     call MessageNotify('E','ludsolve323',&
          'The first dimension differs from the second')
  elseif ( nn /= size(b,3)) then
     call MessageNotify('E','lusolvep323', &
          'The vector length differs from the second dimension of the matrix')
  endif

  lusolve323 = b

!$omp parallel do private(icon)
  do i=1,size(b,1)
     do j=1,jj
        call dgetrs( 'N', nn, 1, alu(j,:,:), nn, kp(j,:), lusolve323(i,j,:), nn, icon )
     if ( icon /= 0 ) &
          call MessageNotify('E','lusplve323','LU decompostion not succeeded.')
     enddo
  enddo
!$omp end parallel do
  
end function lusolve323

module lumatrix
  !
  != lumatrix
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: lumatrix_lapack.f90,v 1.2 2010-03-19 22:30:36 takepiro Exp $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/lumatrix ⥸塼, LU ʬˡˤϢΩ 1 򤯤
  ! Fortran90 ؿ󶡤. 
  !
  ! ¾Υڥȥ׻ѥ⥸塼о줹붭򤯤
  ! ѤƤ. 
  !
  ! ٥ȥ׻ռ, ƱʣĤϢΩ1  
  !
  !     A[ij]^(n) X [j]^(n) = B[i]^(n) 
  !
  ! βƱʣĤαե٥ȥ B[i]^(n)b ФƵ뤳Ȥ
  ! Ǥ褦ˤʤäƤ.
  !
  !== ѿ³
  !
  ! LUDecomp    ::  LU ʬԤ
  ! LUSolve     :: ϢΩ 1 β
  !
  private 
  public LUDecomp, LUSolve

  interface LUDecomp
     !
     !=== Ϳ줿 LU ʬԤ, ԥܥåȤǼ.
     !
     ! * LU ʬ򤵤줿̤ Alu ˾񤭤. 
     !   ΥԥܥåȾ kp ˳Ǽ.
     !
     ! * LUSolve ѤˤΥ֥롼Ƥ Alu  kp 
     !   ׻Ƥ.
     !
     ! * Ϥȥԥܥåμˤäǥ֥롼
     !   ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !   롼Ǥ ludecomp21, ludecomp32 ƤɬפϤʤ.
     !
     !=== ȷ̤η
     !
     ! * Alu  2 (Ϳ뷸 1 )ξ
     !
     !     ! ALU(NDIM,NDIM), KP(NDIM)
     !     ! NDIM x NDIM ι LU ʬ.
     !     ! ̣չ Ϲ˾񤭤.
     !
     !     real(8), intent(inout) :: alu(:,: )         ! ϡ̣չ
     !     integer, intent(out)   :: kp(size(alu,1))   ! ԥܥå
     !
     !
     ! * Alu  3 (Ϳ뷸ʣ)ξ
     !
     !     ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM)
     !     ! NDIM x NDIM ι JDIM Ĥ٤ LU ʬ.
     !     ! ̣չ Ϲ˾񤭤.
     !
     !     real(8), intent(inout) :: alu(:,:,:)      ! ϡ̣չ
     !     integer, intent(out)   :: kp(size(alu,1),size(alu,2)) ! ԥܥå
     !
     !
     subroutine ludecomp21(alu,kp)
       !
       ! ALU(NDIM,NDIM), KP(NDIM)
       ! NDIM x NDIM ι LU ʬ.
       ! ̣չ Ϲ˾񤭤.
       !
       real(8), intent(inout) :: alu(:,: )                 ! ϡ̣չ
       integer, intent(out)   :: kp(size(alu,1))           ! ԥܥå
     end subroutine ludecomp21

     subroutine ludecomp32(alu,kp)
       !
       ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM)
       ! NDIM x NDIM ι JDIM Ĥ٤ LU ʬ.
       ! ̣չ Ϲ˾񤭤.
       !
       real(8), intent(inout) :: alu(:,:,:)                  ! ϡ̣չ
       integer, intent(out)   :: kp(size(alu,1),size(alu,2)) ! ԥܥå
     end subroutine ludecomp32
  end interface

  interface LUSolve
     !
     ! ϢΩ 1 β
     !
     !  * LUSolve Ѥ LUDecompƤ Alu  LU ʬ, 
     !    ԥܥåȾ kp ׻ƤͤФʤʤ.
     !
     !  * Ϥȥԥܥåμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼Ǥ lusolve??? ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  *  Alu  2 (Ϳ뷸 1 ), 
     !     b  1 (Ϳ뱦ե٥ȥ뤬 1 )ξ
     !
     !     ! ALU(NDIM,NDIM), KP(NDIM), B(NDIM)
     !     ! NDIM x NDIM ϢΩ
     !     ! A X = B  1 Ĥ B ФƷ׻.
     !
     !     real(8), intent(in)  :: alu(:,:)              ! ϡ̣չ
     !     integer, intent(in)  :: kp(:)                 ! ԥܥå
     !     real(8), intent(in)  :: b(:)                  ! ե٥ȥ
     !
     !     real(8) :: lusolve(size(b))                   ! 
     !
     !  * Alu  2 (Ϳ뷸 1 ), 
     !    b  2 (Ϳ뱦ե٥ȥ뤬ʣ)ξ
     !
     !     ! ALU(NDIM,NDIM), KP(NDIM), B(JDIM,NDIM)
     !     ! NDIM x NDIM ϢΩ
     !     ! A X = B  JDIM Ĥ B ФƷ׻.
     !
     !     real(8), intent(in)  :: alu(:,:)              ! ϡ̣չ
     !     integer, intent(in)  :: kp(:)                 ! ԥܥå
     !     real(8), intent(in)  :: b(:,:)                ! ե٥ȥ
     !
     !     real(8) :: lusolve(size(b,1),size(b,2))       ! 
     !
     !
     !  * Alu  3 (Ϳ뷸ʣ), 
     !    b  2 (Ϳ뱦ե٥ȥ뤬 1 )ξ
     !
     !     ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM), B(JDIM,NDIM)
     !     ! NDIM x NDIM  JDIM ¤٤ϢΩ
     !     ! A X = B ҤȤĤ B ¤ӤФƷ׻.
     !
     !     real(8), intent(in)  :: alu(:,:,:)            ! ϡ̣չ
     !     integer, intent(in)  :: kp(:,:)               ! ԥܥå
     !     real(8), intent(in)  :: b(:,:)                ! ե٥ȥ
     !
     !     real(8) :: lusolve(size(b,1),size(b,2))             ! 
     !
     !
     !  * Alu  3 (Ϳ뷸ʣ), 
     !    b  3 (Ϳ뱦ե٥ȥ뤬ʣ)ξ
     !
     !     ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM), B(IDIM,JDIM,NDIM)
     !     ! NDIM x NDIM  JDIM ¤٤ϢΩ
     !     ! A X = B  IDIM Ĥ B ФƷ׻.
     !
     !     real(8), intent(in)  :: alu(:,:,:)                ! ϡ̣չ
     !     integer, intent(in)  :: kp(:,:)                   ! ԥܥå
     !     real(8), intent(in)  :: b(:,:,:)                  ! ե٥ȥ
     !
     !     real(8) :: lusolve(size(b,1),size(b,2),size(b,3)) ! 
     !
     !
     function lusolve211(alu,kp,b)
       !
       ! ALU(NDIM,NDIM), KP(NDIM), B(NDIM)
       ! NDIM x NDIM ϢΩ
       ! A X = B  IDIM Ĥ B ФƷ׻. 
       ! ϱդϥ٥ȥ˾񤭤
       !
       real(8), intent(in)  :: alu(:,:)              ! ϡ̣չ
       integer, intent(in)  :: kp(:)                 ! ԥܥå
       real(8), intent(in)  :: b(:)                  ! ե٥ȥ
       real(8) :: lusolve211(size(b))                 ! 
     end function lusolve211

     function lusolve212(alu,kp,b)
       !
       ! ALU(NDIM,NDIM), KP(NDIM), B(JDIM,NDIM)
       ! NDIM x NDIM ϢΩ
       ! A X = B  IDIM Ĥ B ФƷ׻. 
       !
       real(8), intent(in)  :: alu(:,:)              ! ϡ̣չ
       integer, intent(in)  :: kp(:)                 ! ԥܥå
       real(8), intent(in)  :: b(:,:)                ! ե٥ȥ

       real(8) :: lusolve212(size(b,1),size(b,2))       ! 

     end function lusolve212

     function lusolve322(alu,kp,b)
       !
       ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM), B(JDIM,NDIM)
       ! NDIM x NDIM  JDIM ¤٤ϢΩ
       ! A X = B  B ФƷ׻. 
       !
       real(8), intent(in)  :: alu(:,:,:)                   ! ϡ̣չ
       integer, intent(in)  :: kp(:,:)                      ! ԥܥå
       real(8), intent(in)  :: b(:,:)                       ! ե٥ȥ

       real(8) :: lusolve322(size(b,1),size(b,2))             ! 
     end function lusolve322

     function lusolve323(alu,kp,b)
       !
       ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM), B(IDIM,JDIM,NDIM)
       ! NDIM x NDIM  JDIM ¤٤ϢΩ
       ! A X = B  IDIM Ĥ B ФƷ׻. 
       !
       real(8), intent(in)  :: alu(:,:,:)                   ! ϡ̣չ
       integer, intent(in)  :: kp(:,:)                      ! ԥܥå
       real(8), intent(in)  :: b(:,:,:)                     ! ե٥ȥ

       real(8) :: lusolve323(size(b,1),size(b,2),size(b,3)) ! 

     end function lusolve323
  end interface

end module lumatrix
