!--
!----------------------------------------------------------------------
! Copyright (c) 2008-2009 SPMODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  eee_mpi_module
!
!      spml/eee_module ⥸塼ϼβǤ 3 ΰ
!      ήαư򥹥ڥȥˡˤͷ׻뤿 Fortran90 ؿ
!      󶡤. 
!
!       ISPACK/P3PACK, P3PACK-MPI  Fortran77 ֥롼ƤǤ.
!      ڥȥǡӳʻǡγǼˡˤĤƤ
!      ISPACK/P3PACK Υޥ˥奢򻲾Ȥ줿. 
!
!  2008/05/21  ݹ  eee_module ¤
!      2008/06/03  ݹ  ee2f_ZetaFromVor_eef_eef_eef bug fix
!      2008/06/03  ݹ  ESpectralFromZeta bug fix
!      2009/02/23  ʿ  RDoc ѤΥɥȤ
!      2010/01/07  ʿ  include 'mpif.h' -> use mpi
!
!++
module eee_mpi_module
  !
  != eee_mpi_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: eee_mpi_module.f90,v 1.5 2010-02-18 15:28:23 uwabami Exp $
  ! Copyright&License:: See COPYRIGHT[link:../../COPYRIGHT]
  !
  !== 
  !
  ! spml/eee_module ⥸塼ϼβǤ 3 ΰ
  ! ήαư򥹥ڥȥˡˤͷ׻뤿 Fortran90 ؿ
  ! 󶡤.
  !
  !  ISPACK/P3PACK  Fortran77 ֥롼ƤǤ.
  ! ڥȥǡӳʻǡγǼˡˤĤƤ
  ! ISPACK/P3PACK Υޥ˥奢򻲾Ȥ줿.
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !
  ! * ؿ̾Ƭ (eef_, zxv_, x_, v_, z_) , ֤ͤη򼨤Ƥ.
  !   eef_ :: ڥȥǡ
  !           ( 1,2 3 줾 Z,Y,X ȿ(X ˤĤʬ))
  !   ee2f :: 2 ĤΥڥȥǡ¤
  !   zxv_ :: 3 ʻǡ
  !           ( 1,2 3 줾 Z,X,Y γʻ(Y ˤĤʬ)
  !   xv_  :: XY  2 ʻǡ, zv_ : YZ  2 ʻǡ
  !   zx_  :: XZ  2 ʻǡ
  !   x_   :: X  1 ʻǡ, v_ : Y  1 ʻǡ
  !   z_   :: Z  1 ʻǡ
  !
  ! * ؿ̾δ֤ʸ(Dx, Dy, Dz, Lapla, LaplaInv),
  !   δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (_eee_eee,_eee,_zyx, _x, _v) , ѿη
  !   ڥȥǡӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !    _eef     :: ڥȥǡ
  !    _eef_eef :: 2 ĤΥڥȥǡ
  !    _ee2f    :: 2 ĤΥڥȥǡ¤
  !    _zxv     :: 3 ʻǡ
  !    _x       :: X  1 ʻǡ
  !    _v       :: Y  1 ʻǡ.
  !
  !=== ƥǡμ
  !
  ! * zxv : 2 ʻǡ.
  !   * ѿμȼ real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)). 
  !   * im, km Ϥ줾 X, Z ɸγʻǤ, ֥롼 
  !     eee_mpi_initial ˤƤ餫ꤷƤ.
  !   * eee_mpi_Initial ˤäƥץ Y 
  !     ʬ֤ꤵ, ξ public ѿ js,je,jc ꤵ. 
  !   * js ʬ֤κǾʻ, je ʻ, jc ʻǤ. 
  !   *  1  Z ɸγʻֹ, 
  !      2  X ɸγʻֹ, 
  !      3  Y ɸǤ뤳Ȥ(X, Y, ZνǤϤʤ).
  !
  ! * eee : ڥȥǡ.
  !   * ѿμȼ real(8), dimension(-nm:nm,-mm:mm,2*lc). 
  !   * mm, nm Ϥ줾 Y, ZκȿǤ, ֥롼 
  !     eee_initial ˤƤ餫ꤷƤ
  !     (X, Y, Z ȿνǤϤʤ)Ȥ. 
  !   * eee_mpi_Initial ˤäƥץ X ȿ
  !     ʬ֤ꤵ, ξ public ѿ ls,le,lc ꤵ. 
  !   * ls ʬ֤κǾȿ, le ȿ, jc ȿοǤ. 
  !     ºݤγǼΤ ls, ls+1,...,le,-le,-le+1,...,-ls νǤ.
  !     ISPACK/P3PACK-MPI ޥ˥奢뻲ȤΤ.
  !
  ! * ee2f : 2 ĤΥڥȥǡΤʤ. 
  !   * ѿμȼ real(8), dimension(-nm:nm,-mm:mm,2,2*lc). 
  !
  ! * x, v, z : X, Y, Z  1 ʻǡ.
  !   * ѿμȼϤ줾 real(8), dimension(0:im-1),
  !     real(8), dimension(js(ip):je(ip))  real(8), dimension(0:km-1).
  !
  ! * eee_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * zxv_ ǻϤޤؿ֤ͤ 3 ʻǡƱ.
  !
  ! * x_, v_ z_ ǻϤޤؿ֤ͤ 1 ʻǡƱ.
  !
  ! * ڥȥǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡ򥹥ڥȥѴΤȤǤ.
  !
  !== ѿ³
  !
  !==== 
  !
  ! eee_Initial :: ڥȥѴγʻ, ȿ
  ! eee_ChangeResolution :: ѹ
  ! lf_l        :: X ȿΰ־
  !
  !==== ɸѿ
  !
  ! x_X, v_Y, z_Z    ::  ʻɸ(X,Yɸ)Ǽ 1 
  ! x_X_Weight, v_Y_Weight,  z_Z_Weight ::  ŤߺɸǼ 1 
  ! zxv_X, zxv_Y, zxv_Z  :: ʻǡ XYZ ɸ(X,Y,Z)
  !                         (ʻǡ 3 )
  !
  !==== Ѵ
  !
  ! zxv_eef   :: ڥȥǡʻҥǡؤѴ
  ! eef_zxv   :: ʻҥǡ饹ڥȥǡؤѴ
  ! xyz_zxv   :: ʬʻǡν
  ! eee2_ee2f :: ʬڥȥǡν
  ! ee2f_eee2 :: ѥڥȥǡʬ
  !
  !==== ʬ
  !
  ! eef_Lapla_eef       :: ڥȥǡ˥ץ饷Ѥ
  ! eef_LaplaInv_eef    :: ڥȥǡ˥ץ饷εѴѤ
  ! eef_Dx_eef          :: ڥȥǡ X ʬѤ
  ! eef_Dy_eef          :: ڥȥǡ Y ʬѤ
  ! eef_Dz_eef          :: ڥȥǡ Z ʬѤ
  !
  !==== ׻
  !
  ! ee2f_RotVelxVor_ee2f   :: Euler ׻
  ! eef_VorFromZeta_ee2f   ::  2 ʬ(_1, _2)鱲٤ 1 ʬ׻
  ! eef_VelFromZeta_ee2f   ::  2 ʬ(_1, _2)®٤ 1 ʬ׻
  ! ee2f_ZetaFromVor_eef_eef_eef :: ٤鱲 2 ʬ(_1, _2)׻
  !
  !==== ʬʿ
  !
  ! IntZXV_zxv, AvrZXV_zxv   :: 3 ʻǡΰʬʿ
  ! z_IntXV_zxv, z_AvrXV_zxv :: 3 ʻǡ X,Y ʬʿ
  ! x_IntZV_zxv, x_AvrZV_zxv :: 3 ʻǡ Y,Z ʬʿ
  ! y_IntZX_zxv, y_AvrZX_zxv :: 3 ʻǡ Z,X ʬʿ
  ! zv_IntX_zxv, zv_AvrX_zxv :: 3 ʻǡ X ʬʿ
  ! zx_IntY_zxv, zx_AvrY_zxv :: 3 ʻǡ Y ʬʿ
  ! vx_IntZ_zxv, vx_AvrZ_zxv :: 3 ʻǡ Z ʬʿ
  !
  ! IntXV_xv,  AvrXV_xv  :: 2 (XY)ʻǡ X,Y ʬʿ
  ! v_IntX_xv, v_AvrX_xv :: 2 (XY)ʻǡ X ʬʿ
  ! x_IntV_xv, x_AvrV_xv :: 2 (XY)ʻǡ Y ʬʿ
  ! IntZX_zx, AvrZX_zx   :: 2 (ZX)ʻǡ Z,X ʬʿ
  ! z_IntX_zx, z_AvrX_zx :: 2 (ZX)ʻǡ X ʬʿ
  ! x_IntZ_zx, x_AvrZ_zx :: 2 (ZX)ʻǡ Z ʬʿ
  ! IntZV_zv, AvrZV_zv   :: 2 (YZ)ʻǡ Y,Z ʬʿ
  ! v_IntZ_zv, v_AvrZ_zv :: 2 (YZ)ʻǡ Z ʬʿ
  ! z_IntV_zv, z_AvrV_zv :: 2 (YZ)ʻǡ Y ʬʿ
  !
  ! IntX_x, AvrX_x       :: 1 (X)ʻǡ X ʬʿ
  ! IntV_v, AvrV_v       :: 1 (Y)ʻǡ Y ʬʿ
  ! IntZ_z, AvrZ_z       :: 1 (Z)ʻǡ Z ʬʿ
  !
  !==== ڥȥ
  !
  ! EnergyHelicityFromZeta_ee2f  :: ͥ륮إꥷƥ׻. 
  ! ESpectralFromZeta            :: ͥ륮ڥȥ׻. 
  !
  use dc_message, only : MessageNotify
  use mpi
  implicit none

  private
  public ls, le, lc
  public js, je, jc
  public lf_l
  public eee_mpi_Initial                                  ! 롼
  public eee_ChangeResolution                             ! ѹ
  public zxv_eef, eef_zxv                                 ! Ѵ
  public xyz_zxv                                          ! Ѵ
  public eee2_ee2f, ee2f_eee2                             ! Ѵ
  public eef_Dx_eef, eef_Dy_eef, eef_Dz_eef               ! ʬ
  public eef_Lapla_eef, eef_LaplaInv_eef                  ! ʬ
  public ee2f_RotVelxVor_ee2f                             ! ׻
  public eef_VorFromZeta_ee2f, eef_VelFromZeta_ee2f       ! ®ٷ׻
  public ee2f_ZetaFromVor_eef_eef_eef                     ! Ѵ

  public IntZXV_zxv, AvrZXV_zxv                           ! ʬʿ
  public z_IntXV_zxv, z_AvrXV_zxv                         ! ʬʿ
  public x_IntZV_zxv, x_AvrZV_zxv                         ! ʬʿ
  public v_IntZX_zxv, v_AvrZX_zxv                         ! ʬʿ
  public zv_IntX_zxv, zv_AvrX_zxv                         ! ʬʿ
  public zx_IntV_zxv, zx_AvrV_zxv                         ! ʬʿ
  public xv_IntZ_zxv, xv_AvrZ_zxv                         ! ʬʿ

  public IntXV_xv,  AvrXV_xv                              ! ʬʿ
  public v_IntX_xv, v_AvrX_xv                             ! ʬʿ
  public x_IntV_xv, x_AvrV_xv                             ! ʬʿ
  public IntZX_zx, AvrZX_zx                               ! ʬʿ
  public z_IntX_zx, z_AvrX_zx                             ! ʬʿ
  public x_IntZ_zx, x_AvrZ_zx                             ! ʬʿ
  public IntZV_zv, AvrZV_zv                               ! ʬʿ
  public v_IntZ_zv, v_AvrZ_zv                             ! ʬʿ
  public z_IntV_zv, z_AvrV_zv                             ! ʬʿ

  public IntX_x, AvrX_x                                   ! ʬʿ
  public IntV_v, AvrV_v                                   ! ʬʿ
  public IntZ_z, AvrZ_z                                   ! ʬʿ

  public EnergyHelicityFromZeta_ee2f                      ! ͥ륮إꥷƥ
  public ESpectralFromZeta                                ! ͥ륮ڥȥ

  public x_X, v_Y, z_Z                                    ! ɸѿ
  public x_X_Weight, v_Y_Weight, z_Z_Weight               ! ɸѿ
  public zxv_X, zxv_Y, zxv_Z                              ! ɸѿ

  integer   :: im=32, jm=32, km=32                      ! ʻ(X,Y,Z)
  integer   :: lm=10, mm=10, nm=10                      ! ȿ(X,Y,Z)

  integer, dimension(:),   pointer :: le => null()      ! X ȿϰ, 
  integer, dimension(:),   pointer :: ls => null()      ! X ȿϰ, 
  integer, dimension(:),   pointer :: lc => null()      ! X ȿϰ, 
  integer, dimension(:),   pointer :: je => null()      ! Y ɸʻϰ, 
  integer, dimension(:),   pointer :: js => null()      ! Y ɸʻϰ, 
  integer, dimension(:),   pointer :: jc => null()      ! Y ɸʻϰ, 
  integer   :: np, ip                             ! MPI ץ, ץ ID

  integer, dimension(:),   pointer :: itk => null()
  real(8), dimension(:),   pointer :: tk => null()
  integer, dimension(:),   pointer :: itj => null()
  real(8), dimension(:),   pointer :: tj => null()
  integer, dimension(:),   pointer :: iti => null()
  real(8), dimension(:),   pointer :: ti => null()


  real(8), dimension(:),   pointer :: x_X => null()   ! ʻɸ(X)
  real(8), dimension(:),   pointer :: v_Y => null()   ! ʻɸ(Y)
  real(8), dimension(:),   pointer :: z_Z => null()   ! ʻɸ(Y)

  real(8), dimension(:),   pointer :: x_X_Weight => null()
                                         ! ʻŤ(X)
                                         ! X γʻδֳ֤ǼƤ.
  real(8), dimension(:),   pointer :: v_Y_Weight => null()
                                         ! ʻŤ(Y)
                                         ! Y γʻδֳ֤ǼƤ.
  real(8), dimension(:),   pointer :: z_Z_Weight => null()
                                         ! ʻŤ(Y)
                                         ! Z γʻδֳ֤ǼƤ.

  real(8), dimension(:,:,:), pointer :: zxv_X => null()
                          ! ʻ(X)ɸ(3 )
                          ! Ƴʻ(i,j,k)ΰ֤ X ɸǼʻҥǡ
  real(8), dimension(:,:,:), pointer :: zxv_Y => null()
                          ! ʻ(Y)ɸ(3 )
                          ! Ƴʻ(i,j,k)ΰ֤ Y ɸǼʻҥǡ
  real(8), dimension(:,:,:), pointer :: zxv_Z => null()
                          ! ʻ(Z)ɸ(3 )
                          ! Ƴʻ(i,j,k)ΰ֤ Z ɸǼʻҥǡ

  real(8), dimension(:), pointer :: w => null(), ws => null(), wg => null()
  real(8), dimension(:), pointer :: sgwork => null()

  integer, parameter :: nparams_max = 10  ! eee_Initial Ƥ٤
  type eee_param                          ! ΰ¤
     integer   :: im, jm, km
     integer   :: lm, mm, nm
     integer, dimension(:),     pointer :: ls, le, lc
     integer, dimension(:),     pointer :: js, je, jc
     integer, dimension(:),     pointer :: itk
     real(8), dimension(:),     pointer :: tk
     integer, dimension(:),     pointer :: itj
     real(8), dimension(:),     pointer :: tj
     integer, dimension(:),     pointer :: iti
     real(8), dimension(:),     pointer :: ti
     real(8), dimension(:),     pointer :: x_X
     real(8), dimension(:),     pointer :: v_Y
     real(8), dimension(:),     pointer :: z_Z
     real(8), dimension(:),     pointer :: x_X_Weight
     real(8), dimension(:),     pointer :: v_Y_Weight
     real(8), dimension(:),     pointer :: z_Z_Weight
     real(8), dimension(:,:,:), pointer :: zxv_X
     real(8), dimension(:,:,:), pointer :: zxv_Y 
     real(8), dimension(:,:,:), pointer :: zxv_Z
     real(8), dimension(:),     pointer :: w, ws, wg
     real(8), dimension(:),     pointer :: sgwork
  end type eee_param
  type(eee_param) :: params(nparams_max)  ! ΰ
  integer :: nparams                      ! ΰθĿ

  real(8), parameter  :: pi=3.1415926535897932385D0

  save im, jm, km, lm, mm, nm, itk, tk, itj, tj, iti, ti
  save ls, le, lc, js, je, jc, np, ip
  save x_X, v_Y, z_Z, x_X_Weight, v_Y_Weight, z_Z_Weight, zxv_X, zxv_Y, zxv_Z
  save params, nparams

  contains
  !---------------  -----------------
    subroutine eee_mpi_Initial(i,j,k,l,m,n,id)
      !
      ! ڥȥѴγʻ, ȿꤹ.
      ! ΰϰϤ [0,2pi]x[0,2pi]x[0,2pi] ˷Ǥ
      !
      ! ¾δؿѿƤ, ǽˤΥ֥롼Ƥ
      ! 򤷤ʤФʤʤ.
      !
      ! ץʥ id Ѥưۤʤ, ΰƱ
      ! ȤǤ. eee_Initial , ΰ褴Ȥ˸Ƥ
      !  id 򥭡פ, eee_ChangeResolution ؤ.
      !
      integer,intent(in) :: i           ! ʻ(X)
      integer,intent(in) :: j           ! ʻ(Y)
      integer,intent(in) :: k           ! ʻ(Z)
      integer,intent(in) :: l           ! ȿ(X)
      integer,intent(in) :: m           ! ȿ(Y)
      integer,intent(in) :: n           ! ȿ(X)

      integer, intent(out), optional :: id  ! ΰֹ

      character(len=3) cid
      integer :: ii, jj, kk
      integer :: lls, lle, llc, jjs, jje, jjc
      integer :: iip
      integer :: lp, jp
      integer :: ierr

      im = i         ; jm = j         ; km = k
      lm = l         ; mm = m         ; nm = n

      if ( nparams .ge. nparams_max ) then
         call MessageNotify('W','eee_initial',&
              'too many call of eee_Initial, nothing was done.')
         if ( present(id) ) id = -1
         return
      end if

      CALL MPI_COMM_RANK(MPI_COMM_WORLD,IP,IERR)
      CALL MPI_COMM_SIZE(MPI_COMM_WORLD,NP,IERR)

      lp=lm/np+1
      lls=lp*ip
      lle=min(lp*(ip+1)-1,lm)
      if(lle.ge.lls) then
         llc=lle-lls+1
      else
         llc=0 ;  lls=0  ; lle=0
      end if

      jp=(jm-1)/np+1
      jjs=jp*ip
      jje=min(jp*(ip+1)-1,jm-1)
      if(jje.ge.jjs) then
         jjc=jje-jjs+1
      else
         jjc=0 ; jjs=0 ; jje=0
      end if

      nparams = nparams + 1

      params(nparams)%im = im
      params(nparams)%jm = jm
      params(nparams)%km = km
      params(nparams)%lm = lm
      params(nparams)%mm = mm
      params(nparams)%nm = nm
      allocate(params(nparams)%ls(0:np-1))
      allocate(params(nparams)%le(0:np-1))
      allocate(params(nparams)%lc(0:np-1))
      allocate(params(nparams)%js(0:np-1))
      allocate(params(nparams)%je(0:np-1))
      allocate(params(nparams)%jc(0:np-1))

      allocate(params(nparams)%itk(5))
      allocate(params(nparams)%itj(5))
      allocate(params(nparams)%iti(5))
      allocate(params(nparams)%tk(km*2))
      allocate(params(nparams)%tj(jm*2))
      allocate(params(nparams)%ti(im*2))
      allocate(params(nparams)%w(km*max(im*((jm-1)/np+1),jm*2*(lm/np+1))))
      allocate(params(nparams)%ws((2*mm+1)*(2*nm+1)*2*2*(lm+1)))
      allocate(params(nparams)%wg(4*km*max(im*((jm-1)/np+1),jm*2*(lm/np+1))))
      allocate(params(nparams)%sgwork(km*max(im*((jm-1)/np+1),jm*2*(lm/np+1))))

      allocate(params(nparams)%x_X(0:im-1))
      allocate(params(nparams)%x_X_Weight(0:im-1))
      allocate(params(nparams)%v_Y(jjs:jje))
      allocate(params(nparams)%v_Y_Weight(jjs:jje))
      allocate(params(nparams)%z_Z(0:km-1))
      allocate(params(nparams)%z_Z_Weight(0:km-1))
      allocate(params(nparams)%zxv_X(0:km-1,0:im-1,jjs:jje))
      allocate(params(nparams)%zxv_Y(0:km-1,0:im-1,jjs:jje))
      allocate(params(nparams)%zxv_Z(0:km-1,0:im-1,jjs:jje))

      call eee_ChangeResolution(nparams)

      call p3init(km,jm,im,itk,tk,itj,tj,iti,ti)

      do iip=0,np-1
         lp=lm/np+1
         ls(iip)=lp*iip
         le(iip)=min(lp*(iip+1)-1,lm)
         if(le(iip).ge.ls(iip)) then
            lc(iip)=le(iip)-ls(iip)+1
         else
            lc(iip)=0 ;  ls(iip)=0  ; le(iip)=0
         end if

         jp=(jm-1)/np+1
         js(iip)=jp*iip
         je(iip)=min(jp*(iip+1)-1,jm-1)
         if(je(iip).ge.js(iip)) then
            jc(iip)=je(iip)-js(iip)+1
         else
            jc(iip)=0 ; js(iip)=0 ; je(iip)=0
         end if
      enddo

      do ii=0,im-1
         x_X(ii) = 2*pi/im*ii
      enddo
      x_X_Weight = 2*pi/im

      do jj=js(ip),je(ip)
         v_Y(jj) = 2*pi/jm*jj
      enddo
      v_Y_Weight = 2*pi/jm

      do kk=0,km-1
         z_Z(kk) = 2*pi/km*kk
      enddo
      z_Z_Weight = 2*pi/km

      zxv_X = spread(spread(x_X,1,km),3,jc(ip))
      zxv_Y = spread(spread(v_Y,1,im),1,km)
      zxv_Z = spread(spread(z_Z,2,im),3,jc(ip))

      if ( present(id) ) id = nparams

      write(cid,'(I3)') nparams
      call MessageNotify('M','eee_mpi_initial','eee_mpi_module is initialized')
      call MessageNotify('M','eee_mpi_initial',&
           'Resolution ID is '//trim(adjustl(cid)))
    end subroutine eee_mpi_Initial

  !--------------- id ѹ -----------------
    subroutine eee_ChangeResolution(id)
      !
      ! ѹ. eee_Initial ꤹݤ
      ! äƤ륪ץʥ id ͤѤ. 
      !
      integer, intent(in) :: id

      if (id .gt. nparams .or. id .lt. 1) then
         write(*,*)"id is invalid"
      end if

      im = params(id)%im
      jm = params(id)%jm
      km = params(id)%km
      lm = params(id)%lm
      mm = params(id)%mm
      nm = params(id)%nm
      ls => params(id)%ls
      le => params(id)%le
      lc => params(id)%lc
      js => params(id)%js
      je => params(id)%je
      jc => params(id)%jc
      itk => params(id)%itk
      tk  => params(id)%tk
      itj => params(id)%itj
      tj  => params(id)%tj
      iti => params(id)%iti
      ti  => params(id)%ti
      x_X => params(id)%x_X
      v_Y => params(id)%v_Y
      z_Z => params(id)%z_Z
      x_X_Weight => params(id)%x_X_Weight
      v_Y_Weight => params(id)%v_Y_Weight
      z_Z_Weight => params(id)%z_Z_Weight
      zxv_X => params(id)%zxv_X
      zxv_Y => params(id)%zxv_Y
      zxv_Z => params(id)%zxv_Z
      w => params(id)%w
      ws => params(id)%ws
      wg => params(id)%wg
      sgwork => params(id)%sgwork

    end subroutine eee_ChangeResolution

  !--------------- ȿ䤤碌 -----------------
    function lf_l(l)
      !
      ! ڥȥǡ eef(-nm:nm,-mm,mm,2*lc) Ǥ
      ! X ȿ L ΰ־( 3 ź)Ĵ٤.
      !
      ! X ȿˤĤƤ ls,ls+1,... le, -le,-le+1,...,-ls
      ! ν˳ǼƤ(ISPACK/P3PACK ޥ˥奢뻲ȤΤ)
      !
      integer, intent(IN)  ::  l        ! X ȿ
      integer              ::  lf_l     ! ڥȥǡ 3 ź

      if ( abs(l) < ls(ip) .OR. le(ip) < abs(l) ) then
         call MessageNotify('E','l_l','Input wavenumber out of range')
      endif
      
      if ( l >= 0 ) then
         lf_l = l-ls(ip)+1
      else
         lf_l = ls(ip)+2*lc(ip)-abs(l)
      endif

    end function lf_l

  !--------------- Ѵ -----------------
    function zxv_eef(eef)
      !
      ! ڥȥǡʻҥǡѴ.
      !
      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip))        :: zxv_eef
                                                        !(out) ʻǡ
      real(8), dimension(-nm:nm,-mm:mm,2*lc(ip)), intent(in) :: eef
                                                        !(in)  ڥȥǡ
      sgwork(1:(2*nm+1)*(2*mm+1)*2*lc(ip)) &
           = reshape(eef,(/(2*nm+1)*(2*mm+1)*2*lc(ip)/))

      call p3smgb(nm,mm,lm,km,jm,im,sgwork,w,itk,tk,itj,tj,iti,ti)

      zxv_eef = reshape(sgwork(1:im*km*jc(ip)),(/km,im,jc(ip)/))
    end function zxv_eef

    function eef_zxv(zxv)
      !
      ! ʻҥǡ饹ڥȥǡѴ.
      !
      real(8), dimension(-nm:nm,-mm:mm,2*lc(ip))                  :: eef_zxv
                                                      !(out)  ڥȥǡ
      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)), intent(in) :: zxv
                                                      !(in) ʻǡ

      sgwork(1:im*jc(ip)*km) = reshape(zxv,(/im*jc(ip)*km/))

      call p3gmsb(nm,mm,lm,km,jm,im,sgwork,w,itk,tk,itj,tj,iti,ti)

      eef_zxv = reshape(sgwork(1:(2*nm+1)*(2*mm+1)*2*lc(ip)),&
                               (/2*nm+1,2*mm+1,2*lc(ip)/))

    end function eef_zxv

    function eee2_ee2f(ee2f)
      !
      ! ʬڥȥǡѤ
      !
      real(8), dimension(-nm:nm,-mm:mm,-lm:lm,2)             :: eee2_ee2f
      !(out)  ڥȥǡ

      real(8), dimension(-nm:nm,-mm:mm,2,2*lc(ip)),intent(IN) :: ee2f
      !(in) ʬڥȥǡ
      
      real(8), dimension(-nm:nm,-mm:mm,2,0:2*sum(lc)-1)       :: ee2e
      ! ȥǡ
      integer, dimension(0:np-1) :: nm2ls
      integer :: ierr, iip
      integer :: l

      nm2ls(0)   = 0
      do iip=1,np-1
         nm2ls(iip) = nm2ls(iip-1) + (2*nm+1)*(2*mm+1)*2*2*lc(iip-1)
      enddo

      call MPI_ALLGATHERV(ee2f,(2*nm+1)*(2*mm+1)*2*2*lc(ip),MPI_REAL8,&
                          ee2e,(2*nm+1)*(2*mm+1)*2*2*lc,nm2ls,&
                          MPI_REAL8,MPI_COMM_WORLD,IERR)

      do l=ls(0),le(0)
         eee2_ee2f(:,:,l,:) = ee2e(:,:,:,l-ls(0))
         if ( l /= 0 ) then
            eee2_ee2f(:,:,-l,:) = ee2e(:,:,:,2*lc(0)-(l-ls(0)+1))
         endif
      enddo

      do iip=1,np-1
         do l=ls(iip),le(iip)
            eee2_ee2f(:,:,l,:) = ee2e(:,:,:,2*sum(lc(0:iip-1))+(l-ls(iip)))
            eee2_ee2f(:,:,-l,:) = ee2e(:,:,:,2*sum(lc(0:iip))-(l-ls(iip)+1))
         enddo
      enddo

    end function eee2_ee2f

    function ee2f_eee2(eee2)
      !
      ! ڥȥǡʬ
      !
      real(8), dimension(-nm:nm,-mm:mm,2,2*lc(ip))       :: ee2f_eee2
      !(out)  ڥȥǡ

      real(8), dimension(-nm:nm,-mm:mm,-lm:lm,2), intent(IN) :: eee2
      !(in) ʬڥȥǡ
      
      ! ȥǡ
      integer :: ierr, iip
      integer :: l 

      do l=ls(ip),le(ip)
         ee2f_eee2(:,:,:,l-ls(ip)+1) = eee2(:,:,l,:)
         ee2f_eee2(:,:,:,2*lc(ip)-(l-ls(ip))) = eee2(:,:,-l,:)
      enddo
      
    end function ee2f_eee2

    function xyz_zxv(zxv)
      !
      ! ʬʻҥǡν
      !
      real(8), dimension(0:im-1,0:jm-1,0:km-1)             :: xyz_zxv
                                                        !(out) ʻǡ

      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)), intent(in)  :: zxv
                                                        !(in) ʻǡ
      real(8), dimension(0:km-1,0:im-1,0:jm-1)  :: zxy
      ! ѿ

      integer :: i,j,k
      integer :: ierr

      call MPI_ALLGATHERV(zxv,km*im*jc(ip),MPI_REAL8,&
                          zxy,km*im*jc,km*im*js,MPI_REAL8,&
                          MPI_COMM_WORLD,IERR)

      do k=0,km-1
         do j=0,jm-1
            do i=0,im-1
               xyz_zxv(i,j,k) = zxy(k,i,j)
            enddo
         enddo
      enddo

    end function xyz_zxv
    
  !--------------- ʬ׻ -----------------
    function eef_Lapla_eef(eef)
      !
      ! ϥڥȥǡ˥ץ饷(xx+yy+zz)Ѥ.
      !
      ! ڥȥǡΥץ饷Ȥ, бʻǡ
      ! ץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡȿ (l**2 + m**2 + n**2) 򤫤
      ! ׻ԤäƤ. 
      !
      real(8), dimension(-nm:nm,-mm:mm,2*lc(ip))              :: eef_Lapla_eef
      !(out) ڥȥǡΥץ饷

      real(8), dimension(-nm:nm,-mm:mm,2*lc(ip)), intent(in)  :: eef
      !(in) ϥڥȥǡ

      integer l,m,n
      ! ѿ

      eef_Lapla_eef = 0.0

      do l=ls(ip),le(ip)
         do m=-mm,mm
            do n=-nm,nm
               eef_Lapla_eef(n,m,lf_l(l)) = -(l**2+m**2+n**2)*eef(n,m,lf_l(l))
               eef_Lapla_eef(n,m,lf_l(-l)) = -(l**2+m**2+n**2)*eef(n,m,lf_l(-l))
            enddo
         enddo
      enddo

    end function eef_Lapla_eef

    function eef_LaplaInv_eef(eef)
      !
      ! ϥڥȥǡ˵եץ饷(xx+yy+zz)**(-1)Ѥ.
      !
      ! ڥȥǡεեץ饷Ȥ, бʻǡ
      ! եץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡȿ (l**2 + m**2 + n**2) ǳ
      ! ׻ԤäƤ. l=m=n=0 ʬˤ 0 Ƥ. 
      !
      real(8), dimension(-nm:nm,-mm:mm,2*lc(ip))             :: eef_LaplaInv_eef
      !(out) ڥȥǡεեץ饷

      real(8), dimension(-nm:nm,-mm:mm,2*lc(ip)), intent(in) :: eef
      !(in) ڥȥǡ

      integer l,m,n

      eef_LaplaInv_eef = 0.0
      do l=ls(ip),le(ip)
         do m=-mm,mm
            do n=-nm,nm
               if ( l.ne.0 .or. m.ne.0 .or. n.ne.0 ) then
                  eef_LaplaInv_eef(n,m,lf_l(l)) = -eef(n,m,lf_l(l))/(l**2+m**2+n**2)
                  eef_LaplaInv_eef(n,m,lf_l(-l)) = -eef(n,m,lf_l(-l))/(l**2+m**2+n**2)
               endif
            enddo
         enddo
      enddo
    end function eef_LaplaInv_eef

    function eef_Dx_eef(eef)
      !
      ! ϥڥȥǡ X ʬ(x)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ X ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ l 򤫤
      !  <-> ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-nm:nm,-mm:mm,2*lc(ip))              :: eef_Dx_eef
      !(out) ڥȥǡ X ʬ

      real(8), dimension(-nm:nm,-mm:mm,2*lc(ip)), intent(in)  :: eef
      !(in) ϥڥȥǡ

      integer l,m,n
      ! ѿ

      eef_Dx_eef = 0.0
      do l=ls(ip),le(ip)
         do m=-mm,mm
            do n=-nm,nm
               eef_Dx_eef(n,m,lf_l(l)) = -l*eef(-n,-m,lf_l(-l))
            enddo
         enddo
      enddo

      do l=-le(ip),-ls(ip)
         do m=-mm,mm
            do n=-nm,nm
               eef_Dx_eef(n,m,lf_l(l)) = -l*eef(-n,-m,lf_l(-l))
            enddo
         enddo
      enddo
    end function eef_Dx_eef

    function eef_Dy_eef(eef)
      !
      ! ϥڥȥǡ Y ʬ(y)Ѥ.
      !
      ! ڥȥǡ Y ʬȤ, бʻǡ Y ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ Y ȿ m 򤫤
      !  <-> ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-nm:nm,-mm:mm,2*lc(ip))              :: eef_Dy_eef
      !(out) ڥȥǡ X ʬ

      real(8), dimension(-nm:nm,-mm:mm,2*lc(ip)), intent(in)  :: eef
      !(in) ϥڥȥǡ

      integer l,m,n
      ! ѿ

      eef_Dy_eef = 0.0
      do l=ls(ip),le(ip)
         do m=-mm,mm
            do n=-nm,nm
               eef_Dy_eef(n,m,lf_l(l)) = -m*eef(-n,-m,lf_l(-l))
            enddo
         enddo
      enddo

      do l=-le(ip),-ls(ip)
         do m=-mm,mm
            do n=-nm,nm
               eef_Dy_eef(n,m,lf_l(l)) = -m*eef(-n,-m,lf_l(-l))
            enddo
         enddo
      enddo

    end function eef_Dy_eef

    function eef_Dz_eef(eef)
      !
      ! ϥڥȥǡ Z ʬ(z)Ѥ.
      !
      ! ڥȥǡ Z ʬȤ, бʻǡ Z ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ Z ȿ n 򤫤
      !  <-> ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-nm:nm,-mm:mm,2*lc(ip))              :: eef_Dz_eef
      !(out) ڥȥǡ X ʬ

      real(8), dimension(-nm:nm,-mm:mm,2*lc(ip)), intent(in)  :: eef
      !(in) ϥڥȥǡ

      integer l,m,n
      ! ѿ

      eef_Dz_eef = 0.0
      do l=ls(ip),le(ip)
         do m=-mm,mm
            do n=-nm,nm
               eef_Dz_eef(n,m,lf_l(l)) = -n*eef(-n,-m,lf_l(-l))
            enddo
         enddo
      enddo

      do l=-le(ip),-ls(ip)
         do m=-mm,mm
            do n=-nm,nm
               eef_Dz_eef(n,m,lf_l(l)) = -n*eef(-n,-m,lf_l(-l))
            enddo
         enddo
      enddo

    end function eef_Dz_eef

  !--------------- ׻ -----------------

    function ee2f_RotVelxVor_ee2f(ee2f)
      !
      !   2 ʬ(_1, _2)Υڥȥǡ Euler 
      !
      !     x(u x ) 
      !
      !   2 ʬ׻.
      !
      !  (_1, _2) ȱ  Ȥδط ISPACK/P3PACK Υޥ˥奢򻲾
      !
      real(8), dimension(-nm:nm,-mm:mm,2,2*lc(ip))     :: ee2f_RotVelxVor_ee2f
      !(out) Υڥȥǡ 2 Ĥʬ

      real(8), dimension(-nm:nm,-mm:mm,2,2*lc(ip)), intent(in)  :: ee2f
      !(in) ϥڥȥǡ. ٤ 2 ʬ(_1, _2)

      call p3emnl(nm,mm,lm,km,jm,im,ee2f,ee2f_RotVelxVor_ee2f, &
                  wg,itk,tk,itj,tj,iti,ti)

    end function ee2f_RotVelxVor_ee2f

    function eef_VorFromZeta_ee2f(ee2f,isw)
      !
      !   2 ʬ(_1, _2)Υڥȥǡ鱲٤Υڥȥ 1 ʬ
      !  ׻.
      !
      !  (_1, _2) ȱ  Ȥδط ISPACK/P3PACK Υޥ˥奢򻲾
      !
      real(8), dimension(-nm:nm,-mm:mm,2*lc(ip))     :: eef_VorFromZeta_ee2f
      !(out) Υڥȥǡ 2 Ĥʬ

      real(8), dimension(-nm:nm,-mm:mm,2,2*lc(ip)), intent(in)  :: ee2f
      !(in) ϥڥȥǡ. ٤ 2 ʬ(_1, _2)

      integer, intent(IN) :: isw
      !(in) Ϥ뱲٤ʬΥǥå(1,2,3)

      call p3gmto(nm,mm,lm,ee2f,eef_VorFromZeta_ee2f,isw)

    end function eef_VorFromZeta_ee2f

    function eef_VelFromZeta_ee2f(ee2f,isw)
      !
      !   2 ʬ(_1, _2)Υڥȥǡ®٥ڥȥ 1 ʬ
      !  ׻.
      !
      !  (_1, _2) ȱ  Ȥδط ISPACK/P3PACK Υޥ˥奢򻲾
      !
      real(8), dimension(-nm:nm,-mm:mm,2*lc(ip))     :: eef_VelFromZeta_ee2f
      !(out) Υڥȥǡ 2 Ĥʬ

      real(8), dimension(-nm:nm,-mm:mm,2,2*lc(ip)), intent(in)  :: ee2f
      !(in) ϥڥȥǡ. ٤ 2 ʬ(_1, _2)

      integer, intent(IN) :: isw
      !(in) Ϥ뱲٤ʬΥǥå(1,2,3)

      call p3gmtu(nm,mm,lm,ee2f,eef_VelFromZeta_ee2f,isw)

    end function eef_VelFromZeta_ee2f

    function ee2f_ZetaFromVor_eef_eef_eef(eef_1,eef_2,eef_3)
      !
      !  ٤Υڥȥ뤫鱲 2 ʬ(_1, _2)׻.
      !
      !  (_1, _2) ȱ  Ȥδط ISPACK/P3PACK Υޥ˥奢򻲾
      !
      real(8), dimension(-nm:nm,-mm:mm,2,2*lc(ip))     :: ee2f_ZetaFromVor_eef_eef_eef
      !(out) ٤ 2 ʬ(_1, _2)

      real(8), dimension(-nm:nm,-mm:mm,2*lc(ip)), intent(in)  :: eef_1, eef_2, eef_3
      !(in) ٥ڥȥǡγʬ

      integer :: l,m,n

      ee2f_ZetaFromVor_eef_eef_eef = 0.0D0
      do l=ls(ip),le(ip)
         do m=-mm,mm
            do n=-nm,nm
               if ( l /= 0 ) then
                  ee2f_ZetaFromVor_eef_eef_eef(n,m,1,lf_l(l)) = eef_2(n,m,lf_l(l))
                  ee2f_ZetaFromVor_eef_eef_eef(n,m,2,lf_l(l)) = eef_3(n,m,lf_l(l))
               elseif( m /= 0 ) then
                  ee2f_ZetaFromVor_eef_eef_eef(n,m,1,lf_l(l)) = eef_3(n,m,lf_l(l))
                  ee2f_ZetaFromVor_eef_eef_eef(n,m,2,lf_l(l)) = eef_1(n,m,lf_l(l))
               else
                  ee2f_ZetaFromVor_eef_eef_eef(n,m,1,lf_l(l)) = eef_1(n,m,lf_l(l))
                  ee2f_ZetaFromVor_eef_eef_eef(n,m,2,lf_l(l)) = eef_2(n,m,lf_l(l))
               endif
            enddo
         enddo
      enddo

      do l=-le(ip),-ls(ip)
         do m=-mm,mm
            do n=-nm,nm
               if ( l /= 0 ) then
                  ee2f_ZetaFromVor_eef_eef_eef(n,m,1,lf_l(l)) = eef_2(n,m,lf_l(l))
                  ee2f_ZetaFromVor_eef_eef_eef(n,m,2,lf_l(l)) = eef_3(n,m,lf_l(l))
               elseif( m /= 0 ) then
                  ee2f_ZetaFromVor_eef_eef_eef(n,m,1,lf_l(l)) = eef_3(n,m,lf_l(l))
                  ee2f_ZetaFromVor_eef_eef_eef(n,m,2,lf_l(l)) = eef_1(n,m,lf_l(l))
               else
                  ee2f_ZetaFromVor_eef_eef_eef(n,m,1,lf_l(l)) = eef_1(n,m,lf_l(l))
                  ee2f_ZetaFromVor_eef_eef_eef(n,m,2,lf_l(l)) = eef_2(n,m,lf_l(l))
               endif
            enddo
         enddo
      enddo

    end function ee2f_ZetaFromVor_eef_eef_eef

  !--------------- ʬ׻ -----------------
    function IntZXV_zxv(zxv)
      !
      ! 3 ʻǡΰʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight, z_Z_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)), intent(IN)   :: zxv
      !(in)  3 ʻǡ

      real(8)                                    :: IntZXV_zxv
      !(out) ʬ

      real(8) :: IntZXVTMP
      integer :: i, j, k
      integer :: ierr
      ! ѿ

      IntZXV_zxv = 0.0d0
      do j=js(ip),je(ip)
         do i=0,im-1
            do k=0,km-1
               IntZXV_zxv = IntZXV_zxv &
                    + zxv(k,i,j) * z_Z_Weight(k) * v_Y_Weight(j) * x_X_Weight(i)
            enddo
         enddo
      end do

      IntZXVTMP=IntZXV_zxv
      CALL MPI_ALLREDUCE(IntZXVTMP,IntZXV_zxv,1,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function IntZXV_zxv

    function z_IntXV_zxv(zxv)
      !
      ! 3 ʻǡ X,Y ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)), intent(IN)   :: zxv
      !(in) 2 ʻǡ

      real(8), dimension(0:km-1)          :: z_IntXV_zxv
      !(out) ʬ줿 1 (Y)ʻǡ

      real(8), dimension(0:km-1)          :: z_IntXVTmp
      integer :: i, j
      integer :: ierr
      ! ѿ

      z_IntXV_zxv = 0.0d0
      do i=0,im-1
         do j=js(ip),je(ip)
            z_IntXV_zxv(:) = &
                 z_IntXV_zxv(:) + zxv(:,i,j) * x_X_Weight(i)* v_Y_Weight(j)
         enddo
      enddo

      z_IntXVTMP=z_IntXV_zxv
      CALL MPI_ALLREDUCE(z_IntXVTMP,z_IntXV_zxv,km,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function z_IntXV_zxv

    function v_IntZX_zxv(zxv)
      !
      ! 3 ʻǡ X,Z ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight, z_Z_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)), intent(IN)   :: zxv
      !(in) 2 ʻǡ

      real(8), dimension(js(ip):je(ip))          :: v_IntZX_zxv
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: i, k
      ! ѿ

      v_IntZX_zxv = 0.0d0
      do i=0,im-1
         do k=0,km-1
            v_IntZX_zxv(:) = &
                 v_IntZX_zxv(:) + zxv(k,i,:) * x_X_Weight(i)* z_Z_Weight(k)
         enddo
      enddo
    end function v_IntZX_zxv

    function x_IntZV_zxv(zxv)
      !
      ! 3 ʻǡ Y,Z ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight, z_Z_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)), intent(IN)   :: zxv
      !(in) 2 ʻǡ

      real(8), dimension(0:im-1)          :: x_IntZV_zxv
      !(out) ʬ줿 1 (Y)ʻǡ

      real(8), dimension(0:im-1)          :: x_IntZVTMP
      integer :: j, k
      integer :: ierr
      ! ѿ

      x_IntZV_zxv = 0.0d0
      do j=js(ip),je(ip)
         do k=0,km-1
            x_IntZV_zxv(:) = &
                 x_IntZV_zxv(:) + zxv(k,:,j) * v_Y_Weight(j)* z_Z_Weight(k)
         enddo
      enddo

      x_IntZVTMP=x_IntZV_zxv
      CALL MPI_ALLREDUCE(x_IntZVTMP,x_IntZV_zxv,im,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function x_IntZV_zxv

    function zv_IntX_zxv(zxv)
      !
      ! 3 ʻǡ X ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)), intent(IN)   :: zxv
      !(in) 2 ʻǡ

      real(8), dimension(0:km-1,js(ip):je(ip))          :: zv_IntX_zxv
      !(out) ʬ줿 2 (ZY)ʻǡ

      integer :: i
      ! ѿ

      zv_IntX_zxv = 0.0d0
      do i=0,im-1
         zv_IntX_zxv(:,:) = zv_IntX_zxv(:,:) + zxv(:,i,:) * x_X_Weight(i)
      enddo

    end function zv_IntX_zxv

    function zx_IntV_zxv(zxv)
      !
      ! 3 ʻǡ Y ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)), intent(IN)   :: zxv
      !(in) 2 ʻǡ

      real(8), dimension(0:km-1,0:im-1)          :: zx_IntV_zxv
      !(out) ʬ줿 1 (Y)ʻǡ

      real(8), dimension(0:km-1,0:im-1)          :: zx_IntVTMP
      integer :: j
      integer :: ierr
      ! ѿ

      zx_IntV_zxv = 0.0d0
      do j=js(ip),je(ip)
         zx_IntV_zxv(:,:) = zx_IntV_zxv(:,:) + zxv(:,:,j) * v_Y_Weight(j)
      enddo

      zx_IntVTMP=zx_IntV_zxv
      CALL MPI_ALLREDUCE(zx_IntVTMP,zx_IntV_zxv,im*km,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)
    end function zx_IntV_zxv

    function xv_IntZ_zxv(zxv)
      !
      ! 3 ʻǡ Z ʬ
      !
      ! ºݤˤϳʻǡ z_Z_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)), intent(IN)   :: zxv
      !(in) 2 ʻǡ

      real(8), dimension(0:im-1,js(ip):je(ip))          :: xv_IntZ_zxv
      !(out) ʬ줿 1 (YX)ʻǡ

      integer :: k 
      ! ѿ

      xv_IntZ_zxv = 0.0d0
      do k=0,km-1
         xv_IntZ_zxv(:,:) = xv_IntZ_zxv(:,:) + zxv(k,:,:) * z_Z_Weight(k)
      enddo

    end function xv_IntZ_zxv

    function IntXV_xv(xv)
      !
      ! 2 (XY)ʻǡΰʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:im-1,js(ip):je(ip)), intent(IN)   :: xv          
      !(in)  2 (YX)ʻǡ

      real(8)                             :: IntXV_xv
      !(out) ʬ

      real(8) :: IntXVTMP
      integer :: i, j
      integer :: ierr
      ! ѿ

      IntXV_xv = 0.0d0
      do j=js(ip),je(ip)
         do i=0,im-1
            IntXV_xv = IntXV_xv + xv(i,j) * v_Y_Weight(j) * x_X_Weight(i)
         enddo
      enddo

      IntXVTMP=IntXV_xv
      CALL MPI_ALLREDUCE(IntXVTMP,IntXV_xv,1,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function IntXV_xv

    function v_IntX_xv(xv)
      !
      ! 2 (XV)ʻǡ X ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:im-1,js(ip):je(ip)), intent(IN)   :: xv
      !(in) 2 (YX)ʻǡ

      real(8), dimension(js(ip):je(ip))          :: v_IntX_xv
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: i
      ! ѿ

      v_IntX_xv = 0.0d0
      do i=0,im-1
         v_IntX_xv(:) = v_IntX_xv(:) + xv(i,:) * x_X_Weight(i)
      enddo
    end function v_IntX_xv

    function x_IntV_xv(xv)
      !
      ! 2 (YX)ʻǡ Y ʬ
      !
      ! ºݤˤϳʻǡ v_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:im-1,js(ip):je(ip)), intent(IN)   :: xv      
      !(in)  2 (XV)ʻǡ

      real(8), dimension(0:im-1)        :: x_IntV_xv 
      !(out) ʬ줿 1 (X)ʻǡ

      real(8), dimension(0:im-1)        :: x_IntVTMP
      integer :: j
      integer :: ierr
      ! ѿ

      x_IntV_xv = 0.0d0
      do j=js(ip),je(ip)
         x_IntV_xv(:) = x_IntV_xv(:) + xv(:,j) * v_Y_Weight(j)
      enddo

      x_IntVTMP=x_IntV_xv
      CALL MPI_ALLREDUCE(x_IntVTMP,x_IntV_xv,im,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)
    end function x_IntV_xv

    function IntZV_zv(zv)
      !
      ! 2 (ZY)ʻǡΰʬʿ.
      !
      ! ºݤˤϳʻǡ z_Z_Weight, y_Y_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,js(ip):je(ip)), intent(IN)   :: zv          
      !(in)  2 (ZY)ʻǡ

      real(8)                             :: IntZV_zv
      !(out) ʬ

      real(8) :: IntZVTMP
      integer :: j, k
      integer :: ierr
      ! ѿ

      IntZV_zv = 0.0d0
      do j=js(ip),je(ip)
         do k=0,km-1
            IntZV_zv = IntZV_zv + zv(k,j) * v_Y_Weight(j) * z_Z_Weight(k)
         enddo
      enddo

      IntZVTMP=IntZV_zv
      CALL MPI_ALLREDUCE(IntZVTMP,IntZV_zv,1,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function IntZV_zv

    function v_IntZ_zv(zv)
      !
      ! 2 (ZY)ʻǡ Z ʬ
      !
      ! ºݤˤϳʻǡ z_Z_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,js(ip):je(ip)), intent(IN)   :: zv          
      !(in)  2 (ZY)ʻǡ

      real(8), dimension(js(ip):je(ip))          :: v_IntZ_zv
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: k
      ! ѿ

      v_IntZ_zv = 0.0d0
      do k=0,km-1
         v_IntZ_zv(:) = v_IntZ_zv(:) + zv(k,:) * z_Z_Weight(k)
      enddo
    end function v_IntZ_zv

    function z_IntV_zv(zv)
      !
      ! 2 (ZY)ʻǡ Y ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,js(ip):je(ip)), intent(IN)   :: zv          
      !(in)  2 ʻǡ

      real(8), dimension(0:km-1)        :: z_IntV_zv 
      !(out) ʬ줿 1 (X)ʻǡ

      real(8), dimension(0:km-1)        :: z_IntVTMP
      integer :: j
      integer :: ierr
      ! ѿ

      z_IntV_zv = 0.0d0
      do j=js(ip),je(ip)
         z_IntV_zv(:) = z_IntV_zv(:) + zv(:,j) * v_Y_Weight(j)
      enddo

      z_IntVTMP=z_IntV_zv
      CALL MPI_ALLREDUCE(z_IntVTMP,z_IntV_zv,km,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function z_IntV_zv

    function IntZX_zx(zx)
      !
      ! 2 (ZX)ʻǡΰʬʿ.
      !
      ! ºݤˤϳʻǡ z_Z_Weight, x_X_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:im-1), intent(IN)   :: zx          
      !(in)  2 (ZX)ʻǡ

      real(8)                             :: IntZX_zx
      !(out) ʬ

      integer :: i, k
      ! ѿ

      IntZX_zx = 0.0d0
      do i=0,im-1
         do k=0,km-1
            IntZX_zx = IntZX_zx + zx(k,i) * x_X_Weight(i) * z_Z_Weight(k)
         enddo
      enddo
    end function IntZX_zx

    function x_IntZ_zx(zx)
      !
      ! 2 (ZX)ʻǡ Z ʬ
      !
      ! ºݤˤϳʻǡ z_Z_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:im-1), intent(IN)   :: zx          
      !(in)  2 (ZX)ʻǡ

      real(8), dimension(0:im-1)          :: x_IntZ_zx
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: k
      ! ѿ

      x_IntZ_zx = 0.0d0
      do k=0,km-1
         x_IntZ_zx(:) = x_IntZ_zx(:) + zx(k,:) * z_Z_Weight(k)
      enddo
    end function x_IntZ_zx

    function z_IntX_zx(zx)
      !
      ! 2 (ZX)ʻǡ X ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:im-1), intent(IN)   :: zx          
      !(in)  2 ʻǡ

      real(8), dimension(0:km-1)        :: z_IntX_zx 
      !(out) ʬ줿 1 (X)ʻǡ

      integer :: i
      ! ѿ

      z_IntX_zx = 0.0d0
      do i=0,im-1
         z_IntX_zx(:) = z_IntX_zx(:) + zx(:,i) * x_X_Weight(i)
      enddo
    end function z_IntX_zx

    function IntX_x(x)
      !
      ! 1 (X)ʻǡ X ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:im-1)   :: x          !(in)  1 ʻǡ
      real(8)                      :: IntX_x     !(out) ʬ

      IntX_x = sum(x*x_X_Weight)
    end function IntX_x

    function IntV_v(v)
      !
      ! 1 (Y)ʻǡ Y ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(js(ip):je(ip))    :: v          !(in)  1 ʻǡ
      real(8)                      :: IntV_v     !(out) ʬ
      
      real(8) :: IntVTMP
      integer :: ierr

      IntV_v = sum(v*v_Y_Weight)

      IntVTMP=IntV_v
      CALL MPI_ALLREDUCE(IntVTMP,IntV_v,1,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)
    end function IntV_v

    function IntZ_z(z)
      !
      ! 1 (Z)ʻǡ Z ʬ
      !
      ! ºݤˤϳʻǡ z_Z_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:km-1)   :: z         !(in)  1 ʻǡ
      real(8)                      :: IntZ_z     !(out) ʬ

      IntZ_z = sum(z*z_Z_Weight)
    end function IntZ_z

  !--------------- ʿѷ׻ -----------------
    function AvrZXV_zxv(zxv)
      !
      ! 2 ʻǡΰʿ.
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight, z_Z_Weight 
      ! ¤׻, x_X_Weight*y_Y_Weight*z_Z_Weight ¤ǳ
      ! ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)), intent(IN)   :: zxv
      !(in)  3 ʻǡ

      real(8)                                    :: AvrZXV_zxv
      !(out) ʬ

      real(8) :: Vol, VolTMP
      integer :: ierr
      ! ѿ

      VolTMP=sum(x_X_weight)*sum(v_Y_weight)*sum(z_Z_weight)
      
      CALL MPI_ALLREDUCE(VolTMP,Vol,1,MPI_REAL8,MPI_SUM,MPI_COMM_WORLD,IERR)

      AvrZXV_zxv = IntZXV_zxv(zxv)/Vol

    end function AvrZXV_zxv

    function z_AvrXV_zxv(zxv)
      !
      ! 3 ʻǡ X,Y ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻, x_X_Weight*y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)), intent(IN)   :: zxv
      !(in) 2 ʻǡ

      real(8), dimension(0:km-1)          :: z_AvrXV_zxv
      !(out) ʬ줿 1 (Y)ʻǡ

      real(8) :: Area, AreaTMP
      integer :: ierr
      ! ѿ

      AreaTMP = sum(x_X_weight)*sum(v_Y_weight)
      CALL MPI_ALLREDUCE(AreaTMP,Area,1,MPI_REAL8,MPI_SUM,MPI_COMM_WORLD,IERR)

      z_AvrXV_zxv = z_IntXV_zxv(zxv)/Area

    end function z_AvrXV_zxv

    function v_AvrZX_zxv(zxv)
      !
      ! 3 ʻǡ X,Z ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight, z_Z_Weight 򤫤
      ! ¤׻, x_X_Weight*z_Z_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)), intent(IN)   :: zxv
      !(in) 2 ʻǡ

      real(8), dimension(js(ip):je(ip))          :: v_AvrZX_zxv
      !(out) ʬ줿 1 (Y)ʻǡ

      v_AvrZX_zxv = v_IntZX_zxv(zxv)/(sum(x_X_weight)*sum(z_Z_weight))

    end function v_AvrZX_zxv

    function x_AvrZV_zxv(zxv)
      !
      ! 3 ʻǡ Y,Z ʿ
      !
      ! ºݤˤϳʻǡ y_Y_Weight, z_Z_Weight 򤫤
      ! ¤׻, y_Y_Weight*z_Z_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)), intent(IN)   :: zxv
      !(in) 2 ʻǡ

      real(8), dimension(0:im-1)          :: x_AvrZV_zxv
      !(out) ʬ줿 1 (Y)ʻǡ

      real(8) :: Area, AreaTMP
      integer :: ierr
      ! ѿ

      AreaTMP = sum(z_Z_weight)*sum(v_Y_weight)
      CALL MPI_ALLREDUCE(AreaTMP,Area,1,MPI_REAL8,MPI_SUM,MPI_COMM_WORLD,IERR)

      x_AvrZV_zxv = x_IntZV_zxv(zxv)/Area

    end function x_AvrZV_zxv

    function zv_AvrX_zxv(zxv)
      !
      ! 3 ʻǡ X ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤
      ! ¤׻, x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)), intent(IN)   :: zxv
      !(in) 2 ʻǡ

      real(8), dimension(0:km-1,js(ip):je(ip))          :: zv_AvrX_zxv
      !(out) ʬ줿 2 (ZY)ʻǡ

      zv_AvrX_zxv = zv_IntX_zxv(zxv)/sum(x_X_weight)

    end function zv_AvrX_zxv

    function zx_AvrV_zxv(zxv)
      !
      ! 3 ʻǡ Y ʿ
      !
      ! ºݤˤϳʻǡ v_Y_Weight 򤫤
      ! ¤׻, v_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)), intent(IN)   :: zxv
      !(in) 2 ʻǡ

      real(8), dimension(0:km-1,0:im-1)          :: zx_AvrV_zxv
      !(out) ʬ줿 1 (Y)ʻǡ

      real(8) :: Length, LengthTMP
      integer :: ierr
      ! ѿ

      LengthTMP = sum(v_Y_weight)
      CALL MPI_ALLREDUCE(LengthTMP,Length,1,MPI_REAL8,MPI_SUM,MPI_COMM_WORLD,IERR)

      zx_AvrV_zxv = zx_IntV_zxv(zxv)/Length

    end function zx_AvrV_zxv

    function xv_AvrZ_zxv(zxv)
      !
      ! 3 ʻǡ Z ʿ
      !
      ! ºݤˤϳʻǡ z_Z_Weight 򤫤
      ! ¤׻, z_Z_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:im-1,js(ip):je(ip)), intent(IN)   :: zxv
      !(in) 2 ʻǡ

      real(8), dimension(0:im-1,js(ip):je(ip))          :: xv_AvrZ_zxv
      !(out) ʬ줿 1 (YX)ʻǡ

      xv_AvrZ_zxv = xv_IntZ_zxv(zxv)/sum(z_Z_weight)

    end function xv_AvrZ_zxv

    function AvrXV_xv(xv)
      !
      ! 2 ʻǡΰʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻, x_X_Weight*y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:im-1,js(ip):je(ip)), intent(IN)   :: xv
      !(in)  2 ʻǡ

      real(8)                             :: AvrXV_xv    
      !(out) ʿ

      real(8) :: Area, AreaTMP
      integer :: ierr
      ! ѿ

      AreaTMP = sum(x_X_weight)*sum(v_Y_weight)
      CALL MPI_ALLREDUCE(AreaTMP,Area,1,MPI_REAL8,MPI_SUM,MPI_COMM_WORLD,IERR)

      AvrXV_xv = IntXV_xv(xv)/Area

    end function AvrXV_xv

    function v_AvrX_xv(xv)
      !
      ! 2 ʻǡ X ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:im-1,js(ip):je(ip)), intent(IN)   :: xv
      !(in) 2 ʻǡ

      real(8), dimension(js(ip):je(ip))          :: v_AvrX_xv
      !(out) ʿѤ줿 1 (Y)ʻǡ

      v_AvrX_xv = v_IntX_xv(xv)/sum(x_X_weight)
    end function v_AvrX_xv

    function x_AvrV_xv(xv)
      !
      ! 2 ʻǡ Y ʿ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:im-1,js(ip):je(ip)), intent(IN)   :: xv
      !(in) 2 ʻǡ

      real(8), dimension(0:im-1)          :: x_AvrV_xv
      !(out) ʿѤ줿 1 (X)ʻǡ

      real(8) :: Length, LengthTMP
      integer :: ierr
      ! ѿ

      LengthTMP = sum(v_Y_weight)
      CALL MPI_ALLREDUCE(LengthTMP,Length,1,MPI_REAL8,MPI_SUM,MPI_COMM_WORLD,IERR)

      x_AvrV_xv = x_IntV_xv(xv)/Length
    end function x_AvrV_xv

    function AvrZX_zx(zx)
      !
      ! 2 (ZX)ʻǡΰʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight, z_Z_Weight 򤫤
      ! ¤׻, x_X_Weight*z_Z_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:im-1), intent(IN)   :: zx
      !(in)  2 (ZX)ʻǡ

      real(8)                             :: AvrZX_zx    
      !(out) ʿ

      AvrZX_zx = IntZX_zx(zx)/(sum(x_X_weight)*sum(z_Z_weight))
    end function AvrZX_zx

    function z_AvrX_zx(zx)
      !
      ! 2 (ZX)ʻǡ X ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:im-1), intent(IN)   :: zx
      !(in) 2 (ZX)ʻǡ

      real(8), dimension(0:km-1)          :: z_AvrX_zx
      !(out) ʿѤ줿 1 (Z)ʻǡ

      z_AvrX_zx = z_IntX_zx(zx)/sum(x_X_weight)
    end function z_AvrX_zx

    function x_AvrZ_zx(zx)
      !
      ! 2 (ZX)ʻǡ Z ʿ
      !
      ! ºݤˤϳʻǡ z_Z_Weight 򤫤¤׻, 
      ! z_Z_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:im-1), intent(IN)   :: zx
      !(in) 2 (ZX)ʻǡ

      real(8), dimension(0:im-1)          :: x_AvrZ_zx
      !(out) ʿѤ줿 1 (X)ʻǡ

      x_AvrZ_zx = x_IntZ_zx(zx)/sum(z_Z_weight)
    end function x_AvrZ_zx

    function AvrZV_zv(zv)
      !
      ! 2 (ZV)ʻǡΰʿ
      !
      ! ºݤˤϳʻǡ z_Z_Weight, y_Y_Weight 򤫤
      ! ¤׻, z_Z_Weight*v_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,js(ip):je(ip)), intent(IN)   :: zv
      !(in)  2 (ZY)ʻǡ

      real(8)                             :: AvrZV_zv    
      !(out) ʿ

      real(8) :: Area, AreaTMP
      integer :: ierr
      ! ѿ

      AreaTMP = sum(z_Z_weight)*sum(v_Y_weight)
      CALL MPI_ALLREDUCE(AreaTMP,Area,1,MPI_REAL8,MPI_SUM,MPI_COMM_WORLD,IERR)

      AvrZV_zv = IntZV_zv(zv)/Area
    end function AvrZV_zv

    function z_AvrV_zv(zv)
      !
      ! 2 (ZY)ʻǡ Y ʿ
      !
      ! ºݤˤϳʻǡ v_Y_Weight 򤫤¤׻, 
      ! v_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,js(ip):je(ip)), intent(IN)   :: zv
      !(in) 2 (ZV)ʻǡ

      real(8), dimension(0:km-1)          :: z_AvrV_zv
      !(out) ʿѤ줿 1 (Z)ʻǡ
      real(8) :: Length, LengthTMP
      integer :: ierr
      ! ѿ

      LengthTMP = sum(v_Y_weight)
      CALL MPI_ALLREDUCE(LengthTMP,Length,1,MPI_REAL8,MPI_SUM,MPI_COMM_WORLD,IERR)

      z_AvrV_zv = z_IntV_zv(zv)/Length
    end function z_AvrV_zv

    function v_AvrZ_zv(zv)
      !
      ! 2 (ZY)ʻǡ Z ʿ
      !
      ! ºݤˤϳʻǡ z_Z_Weight 򤫤¤׻, 
      ! z_Z_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,js(ip):je(ip)), intent(IN)   :: zv
      !(in) 2 (ZY)ʻǡ

      real(8), dimension(js(ip):je(ip))          :: v_AvrZ_zv
      !(out) ʿѤ줿 1 (X)ʻǡ

      v_AvrZ_zv = v_IntZ_zv(zv)/sum(z_Z_weight)
    end function v_AvrZ_zv

    function AvrX_x(x)
      !
      ! 1 (X)ʻǡ X ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:im-1), intent(IN) :: x       !(in)  1 ʻǡ
      real(8)                                :: AvrX_x  !(out) ʿ

      AvrX_x = IntX_x(x)/sum(x_X_weight)
    end function AvrX_x

    function AvrV_v(v)
      !
      ! 1 (Y)ʻǡ Y ʿ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(js(ip):je(ip)), intent(IN) :: v
      !(in)  1 ʻǡ

      real(8)                               :: AvrV_v !(out) ʿ

      real(8) :: Length, LengthTMP
      integer :: ierr
      ! ѿ

      LengthTMP = sum(v_Y_weight)
      CALL MPI_ALLREDUCE(LengthTMP,Length,1,MPI_REAL8,MPI_SUM,MPI_COMM_WORLD,IERR)

      AvrV_v = IntV_v(v)/Length
    end function AvrV_v

    function AvrZ_z(z)
      !
      ! 1 (Z)ʻǡ Z ʿ
      !
      ! ºݤˤϳʻǡ z_Z_Weight 򤫤¤׻, 
      ! z_Z_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1), intent(IN) :: z      !(in)  1 ʻǡ
      real(8)                                :: AvrZ_z !(out) ʿ

      AvrZ_z = IntZ_z(z)/sum(z_Z_weight)
    end function AvrZ_z

  !--------------- ڥȥ׻ -----------------
    function EnergyHelicityFromZeta_ee2f(ee2f)
      !
      ! ʬ(_1, _2)ΰʿѥͥ륮ȥإꥷƥ׻.
      !
      real(8), dimension(2)                 :: EnergyHelicityFromZeta_ee2f
      ! ͥ륮إꥷƥ

      real(8), dimension(-nm:nm,-mm:mm,2,2*lc(ip)), intent(in) :: ee2f
      ! ʬ(_1, _2)

      real(8) :: E, H           ! ͥ륮, إꥷƥ
      
      call p3cmsv(nm,mm,lm,ee2f,E,H)

      EnergyHelicityFromZeta_ee2f(1) = E ; EnergyHelicityFromZeta_ee2f(2) = H

    end function EnergyHelicityFromZeta_ee2f

    subroutine ESpectralFromZeta(esp,ee2f)
      !
      ! ʬ(_1, _2)饨ͥ륮ڥȥ׻. 
      !
      !   * esp ΥǵȿϰϤ
      !   * esp ¤ EFFromZeta ǵ륨ͥ륮
      !     (ΰʿ)
      !
      real(8), dimension(:), intent(OUT)  :: esp
      ! ͥ륮ڥȥ

      real(8), dimension(-nm:nm,-mm:mm,2,2*lc(ip)), intent(in) :: ee2f
      ! ʬ(_1, _2)

      integer kmax
      ! ѿ
      real(8), allocatable :: wesp(:)

      kmax=size(esp)
      allocate(wesp(kmax))
      call p3empt(nm,mm,lm,kmax,ee2f,esp,wesp)
      deallocate(wesp)

    end subroutine ESpectralFromZeta

  end module eee_mpi_module
