# coding: utf-8
lib = File.expand_path('../lib', __FILE__)
$LOAD_PATH.unshift(lib) unless $LOAD_PATH.include?(lib)
require 'numru/gphys/version'

Gem::Specification.new do |spec|
  spec.name          = "gphys"
  spec.version       = NumRu::GPhys::VERSION
  spec.authors           = ["Takeshi Horinouchi", "Ryo Mizuta",\
    "Daisuke Tsukahara", "Seiya Nishizawa", "Shin-ichi Takehiro"]
  spec.email         = ["horinout@gfd-dennou.org"]

  #if spec.respond_to?(:metadata)
  #  spec.metadata['allowed_push_host'] = "TODO: Set to 'http://mygemserver.com' to prevent pushes to rubygems.org, or delete to allow pushes to any server."
  #end

  spec.summary          = %q{A multi-purpose class to handle Gridded Physical quantities}
  spec.description      = %q{Comprehensive library for self-descriptive gridded physical data (in NetCDF, GrADS, or on memory) with graphics. This version works with Ruby 2.0.}
  spec.homepage         = 'http://www.gfd-dennou.org/arch/ruby/products/gphys/'
  spec.licenses       = ["BSD-2-Clause"]

  spec.files         = Dir['{bin/*,ext/**/*[cb],lib/**/*.rb,doc/**/*,test/*.rb,testdata/*[a-z]}'].sort + %w(ChangeLog .ChangeLog.until201303 Gemfile LICENSE.txt README Rakefile gphys.gemspec)
  spec.bindir        = "bin"
  spec.executables   = spec.files.grep(%r{^bin/}) { |f| File.basename(f) }
  spec.require_paths = ["ext","lib"]
  spec.test_files    = spec.files.grep(%r{^(test|test_old|sample|testdata)/})
  spec.extensions << "ext/numru/gphys/extconf.rb"
  spec.extensions << "ext/numru/ganalysis/extconf.rb"

  spec.post_install_message = "Thanks for installing! You can add extra libraries (i.e., ruby-lapack, rb-gsl) to enjoy powerful calculating and handling datasets."

  spec.required_ruby_version = Gem::Requirement.new(">= 1.8")

  spec.add_runtime_dependency(%q<narray>, [">= 0.5.7"])
  spec.add_runtime_dependency(%q<numru-misc>, [">= 0.1.0"])
  spec.add_runtime_dependency(%q<numru-units>, [">= 1.7"])
  spec.add_runtime_dependency(%q<narray_miss>, [">= 1.2.4"])
  spec.add_runtime_dependency(%q<ruby-netcdf>, [">= 0.6.6"])
  spec.add_runtime_dependency(%q<ruby-dcl>, [">= 1.6.1"])
  spec.add_runtime_dependency(%q<ruby-fftw3>, [">= 0.3"])
  #spec.add_runtime_dependency(%q<rb-gsl>, [">= 1.14"])
  #spec.add_runtime_dependency(%q<ruby-lapack>, [">= 1.5"])
  #spec.add_development_dependency(%q<rb-grib>, [">= 0.2.0"])
end
