!------------------------------------------------------------------------
! COPYRIGHT (c) 2007-2010 SPMODEL Development Group. All rights reserved.
!------------------------------------------------------------------------
!
!ɽ  au_module ƥȥץ
!
!  2007/12/28  ݹ
!      2008/01/05  ݹ  g_Dr2_u Υƥɲ
!      2010/12/21  ʿ dc_test Ѥ褦˽
!
program au_test_base1d

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use au_module
  implicit none
  integer, parameter :: im=32, km=32
  real(8), parameter :: ra=2.0D0
  real(8), dimension(0:im) :: g_z
  real(8), dimension(0:km) :: u_z_sol
  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  call MessageNotify('M','au_test_base1d','au_module 1-dim function tests')

  call au_initial(im,km,ra,(/0/))

  call MessageNotify('M','au_test_base1d', 'Test1: T_1(2*r**2/a**2 - 1)')

  g_z = 2*(g_R/ra)**2 - 1
  u_z_sol = 0.0D0 ; u_z_sol(1) = 1.0D0

  call AssertEqual(&
    message='u_g(g_z)',                                           &
    answer = u_z_sol,                                             &
    check = u_g(g_z),                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call AssertEqual(&
    message='g_u(u_g(g_z))',                                      &
    answer = g_z,                                                 &
    check = g_u(u_g(g_z)),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call AssertEqual(&
    message='g_dr_u(u_g(g_z))',                                   &
    answer = 4.0d0*g_R/ra**2,                                     &
    check = g_Dr_u(u_g(g_z)),                                     &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','au_test_base1d', 'Test1: OK')

  call MessageNotify('M','au_test_base1d', 'Test2: T_2(2*r**2/a**2 - 1) - 1')

  g_z = 2.0d0*(2.0d0*g_R**2/ra**2 - 1.0d0)**2 - 1.0d0
  u_z_sol = 0.0d0 ;  u_z_sol(2) = 1.0d0

  call AssertEqual(&
    message='u_g(g_z)',                                           &
    answer = u_z_sol,                                             &
    check = u_g(g_z),                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call AssertEqual(&
    message='g_u(u_g(g_z))',                                      &
    answer = g_z,                                                 &
    check = g_u(u_g(g_z)),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call AssertEqual(&
    message='g_dr_u(u_g(g_z))',                                   &
    answer = 16.0d0*g_R/ra**2*(2*g_R**2/ra**2-1),                 &
    check = g_Dr_u(u_g(g_z)),                                     &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call AssertEqual(&
    message='g_dr2_u(u_g(g_z))',                                  &
    answer = 96.0d0*g_R**2/ra**4 - 16.0d0/ra**2 ,                 &
    check = g_Dr2_u(u_g(g_z)),                                    &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','au_test_base1d', 'Test2: OK')

  call MessageNotify('M','au_test_base1d','au_module 1-dim test suceeded!')

end program au_test_base1d
